/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.generation.lib;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.generation.lib.OclAnyModelElementImpl;
import org.oslo.ocl20.generation.lib.OclBagImpl;
import org.oslo.ocl20.generation.lib.OclBooleanImpl;
import org.oslo.ocl20.generation.lib.OclEnumerationImpl;
import org.oslo.ocl20.generation.lib.OclIntegerImpl;
import org.oslo.ocl20.generation.lib.OclOrderedSetImpl;
import org.oslo.ocl20.generation.lib.OclRealImpl;
import org.oslo.ocl20.generation.lib.OclSequenceImpl;
import org.oslo.ocl20.generation.lib.OclSetImpl;
import org.oslo.ocl20.generation.lib.OclStringImpl;
import org.oslo.ocl20.generation.lib.OclTupleImpl;
import org.oslo.ocl20.generation.lib.OclTypeImpl;
import org.oslo.ocl20.generation.lib.OclUndefinedImpl;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.model.types.BagType;
import org.oslo.ocl20.semantics.model.types.BooleanType;
import org.oslo.ocl20.semantics.model.types.CollectionType;
import org.oslo.ocl20.semantics.model.types.IntegerType;
import org.oslo.ocl20.semantics.model.types.OclAnyType;
import org.oslo.ocl20.semantics.model.types.OrderedSetType;
import org.oslo.ocl20.semantics.model.types.RealType;
import org.oslo.ocl20.semantics.model.types.SequenceType;
import org.oslo.ocl20.semantics.model.types.SetType;
import org.oslo.ocl20.semantics.model.types.StringType;
import org.oslo.ocl20.semantics.model.types.TupleType;
import org.oslo.ocl20.semantics.model.types.VoidType;
import org.oslo.ocl20.standard.lib.OclAny;
import org.oslo.ocl20.standard.lib.OclAnyModelElement;
import org.oslo.ocl20.standard.lib.OclBag;
import org.oslo.ocl20.standard.lib.OclBoolean;
import org.oslo.ocl20.standard.lib.OclCollection;
import org.oslo.ocl20.standard.lib.OclEnumeration;
import org.oslo.ocl20.standard.lib.OclInteger;
import org.oslo.ocl20.standard.lib.OclOrderedSet;
import org.oslo.ocl20.standard.lib.OclReal;
import org.oslo.ocl20.standard.lib.OclSequence;
import org.oslo.ocl20.standard.lib.OclSet;
import org.oslo.ocl20.standard.lib.OclString;
import org.oslo.ocl20.standard.lib.OclTuple;
import org.oslo.ocl20.standard.lib.OclType;
import org.oslo.ocl20.standard.lib.OclUndefined;
import org.oslo.ocl20.standard.lib.StdLibAdapter;

public class StdLibGenerationAdapterImpl
implements StdLibAdapter {
    protected static Map tempVarCounters = new HashMap();
    private OclProcessor processor;

    public static String newTempVar(String key) {
        Integer i = (Integer)tempVarCounters.get(key);
        int counter = 0;
        if (i != null) {
            counter = i;
        }
        tempVarCounters.put(key, new Integer(++counter));
        return String.valueOf(key) + counter;
    }

    public static String newTempVar() {
        return StdLibGenerationAdapterImpl.newTempVar("t");
    }

    public void resetCounters() {
        tempVarCounters = new HashMap();
    }

    @Override
    public OclProcessor getProcessor() {
        return this.processor;
    }

    public StdLibGenerationAdapterImpl(OclProcessor proc) {
        this.processor = proc;
        OclUndefinedImpl.UNDEFINED = new OclUndefinedImpl("", null, this);
        OclBooleanImpl.FALSE = this.Boolean("java.lang.Boolean.FALSE", false);
        OclBooleanImpl.TRUE = this.Boolean("java.lang.Boolean.TRUE", false);
    }

    @Override
    public OclAny OclAny(Object obj) {
        if (obj == null) {
            return this.Undefined();
        }
        if (obj instanceof OclAny) {
            return (OclAny)obj;
        }
        if (obj instanceof Boolean) {
            return this.Boolean((Boolean)obj);
        }
        if (obj instanceof String) {
            return this.String((String)obj);
        }
        if (obj instanceof Double) {
            return this.Real((Double)obj);
        }
        if (obj instanceof Float) {
            return this.Real(new Double(((Float)obj).doubleValue()));
        }
        if (obj instanceof Integer) {
            return this.Integer((Integer)obj);
        }
        return this.Undefined();
    }

    @Override
    public OclAny OclAny(Classifier type, Object obj) {
        return this.OclAny(type, (String)obj, false);
    }

    public OclAny OclAny(Classifier type, String obj) {
        return this.OclAny(type, obj, false);
    }

    public OclAny OclAny(Classifier type, String obj, boolean newVariable) {
        if (type == null) {
            return this.Undefined();
        }
        if (type instanceof VoidType) {
            return this.Undefined();
        }
        if (type instanceof BooleanType) {
            return this.Boolean(obj, newVariable);
        }
        if (type instanceof StringType) {
            return this.String(obj, newVariable);
        }
        if (type instanceof IntegerType) {
            return this.Integer(obj, newVariable);
        }
        if (type instanceof RealType) {
            return this.Real(obj, newVariable);
        }
        if (type instanceof TupleType) {
            return this.Tuple((TupleType)type, obj, newVariable);
        }
        if (type instanceof CollectionType) {
            return this.OclCollection((CollectionType)type, obj, newVariable);
        }
        return this.OclAnyModelElement(type, obj, newVariable);
    }

    @Override
    public OclType Type(Classifier cls) {
        return new OclTypeImpl(cls, this);
    }

    @Override
    public OclAnyModelElement OclAnyModelElement(Classifier type, Object obj) {
        return this.OclAnyModelElement(type, obj, false);
    }

    public OclAnyModelElement OclAnyModelElement(Classifier type, Object obj, boolean newVariable) {
        if (obj instanceof String) {
            return new OclAnyModelElementImpl(type, (String)obj, this, newVariable);
        }
        return null;
    }

    @Override
    public OclEnumeration Enumeration(Classifier type, Object obj) {
        if (obj instanceof String) {
            return new OclEnumerationImpl(type, (String)obj, this, false);
        }
        return null;
    }

    @Override
    public OclUndefined Undefined() {
        return OclUndefinedImpl.UNDEFINED;
    }

    @Override
    public OclBoolean Boolean(boolean b) {
        if (b) {
            return OclBooleanImpl.TRUE;
        }
        return OclBooleanImpl.FALSE;
    }

    @Override
    public OclBoolean Boolean(Boolean b) {
        if (b.booleanValue()) {
            return OclBooleanImpl.TRUE;
        }
        return OclBooleanImpl.FALSE;
    }

    @Override
    public OclBoolean Boolean(String b) {
        return new OclBooleanImpl(b, this, false);
    }

    public OclBoolean Boolean(String b, boolean newVariable) {
        return new OclBooleanImpl(b, this, newVariable);
    }

    @Override
    public OclReal Real(double r) {
        return this.Real(String.valueOf(r));
    }

    @Override
    public OclReal Real(Double r) {
        return this.Real(r.toString());
    }

    @Override
    public OclReal Real(String r) {
        return this.Real(r, false);
    }

    public OclReal Real(String r, boolean newVariable) {
        return new OclRealImpl(r, this, newVariable);
    }

    @Override
    public OclReal Real(float r) {
        return this.Real(String.valueOf(r));
    }

    @Override
    public OclInteger Integer(int i) {
        return this.Integer(String.valueOf(i));
    }

    @Override
    public OclInteger Integer(Integer i) {
        return this.Integer(i.toString());
    }

    @Override
    public OclInteger Integer(String i) {
        return this.Integer(i, false);
    }

    public OclInteger Integer(String i, boolean newVariable) {
        return new OclIntegerImpl(i, this, newVariable);
    }

    @Override
    public OclString String(String s) {
        return this.String(s, false);
    }

    public OclString String(String s, boolean newVariable) {
        return new OclStringImpl(s, this, newVariable);
    }

    @Override
    public OclTuple Tuple(TupleType tT, Map m) {
        Vector types = new Vector();
        Vector keys = new Vector();
        Vector<OclAny> values = new Vector<OclAny>();
        for (Map.Entry me : m.entrySet()) {
            types.add(me.getValue().getClass());
            keys.add(me.getKey());
            values.add(this.OclAny(me.getValue()));
        }
        return this.Tuple(tT, values.toArray(new OclAny[0]));
    }

    @Override
    public OclTuple Tuple(TupleType tT, OclAny[] arr) {
        return new OclTupleImpl(tT, arr, this);
    }

    public OclTuple Tuple(TupleType type, String obj) {
        return this.Tuple(type, obj, false);
    }

    public OclTuple Tuple(TupleType tT, String tup, boolean newVariable) {
        return new OclTupleImpl(tT, tup, this, newVariable);
    }

    @Override
    public OclCollection Collection(Collection obj) {
        OclAnyType oat = this.processor.getTypeFactory().buildOclAnyType();
        if (obj == null) {
            return this.Undefined();
        }
        if (obj instanceof List) {
            return this.Sequence((Classifier)oat, (List)obj);
        }
        if (obj instanceof Set) {
            return this.Set((Classifier)oat, (Set)obj);
        }
        if (obj instanceof Collection) {
            return this.Bag((Classifier)oat, obj);
        }
        return this.Undefined();
    }

    @Override
    public OclCollection Collection(Classifier eT) {
        if (eT instanceof OrderedSetType) {
            return this.OrderedSet(eT);
        }
        if (eT instanceof SetType) {
            return this.Set(eT);
        }
        if (eT instanceof SequenceType) {
            return this.Sequence(eT);
        }
        if (eT instanceof BagType) {
            return this.Bag(eT);
        }
        return this.Undefined();
    }

    public OclCollection OclCollection(CollectionType type, String obj) {
        return this.OclCollection(type, obj, false);
    }

    public OclCollection OclCollection(CollectionType type, String obj, boolean newVariable) {
        if (obj == null) {
            return this.Undefined();
        }
        if (type instanceof OrderedSetType) {
            return this.OrderedSet(type.getElementType(), obj, newVariable);
        }
        if (type instanceof SetType) {
            return this.Set(type.getElementType(), obj, newVariable);
        }
        if (type instanceof SequenceType) {
            return this.Sequence(type.getElementType(), obj, newVariable);
        }
        if (type instanceof BagType) {
            return this.Bag(type.getElementType(), obj, newVariable);
        }
        return this.Undefined();
    }

    @Override
    public OclSet Set(Classifier eT) {
        return this.Set(eT, new OclAny[0]);
    }

    @Override
    public OclSet Set(Classifier eT, Collection impl) {
        if (impl != null) {
            return this.Set(eT, this.convert(impl.toArray()));
        }
        return this.Set(eT);
    }

    public OclSet Set(Classifier eT, String expr) {
        return this.Set(eT, expr, false);
    }

    public OclSet Set(Classifier eT, String expr, boolean newVariable) {
        return new OclSetImpl(eT, expr, this, newVariable);
    }

    @Override
    public OclSet Set(Classifier eT, Object[] array) {
        return new OclSetImpl(eT, this.convert(array), this);
    }

    public OclOrderedSet OrderedSet(Class eT) {
        return this.OrderedSet(this.processor.getBridgeFactory().buildClassifier(eT));
    }

    @Override
    public OclOrderedSet OrderedSet(Classifier eT) {
        return this.OrderedSet(eT, new OclAny[0]);
    }

    @Override
    public OclOrderedSet OrderedSet(Classifier eT, Collection impl) {
        return this.OrderedSet(eT, this.convert(impl.toArray()));
    }

    public OclOrderedSet OrderedSet(Classifier eT, String os) {
        return this.OrderedSet(eT, os, false);
    }

    public OclOrderedSet OrderedSet(Classifier eT, String os, boolean newVariable) {
        return new OclOrderedSetImpl(eT, os, this, newVariable);
    }

    @Override
    public OclOrderedSet OrderedSet(Classifier eT, Object[] array) {
        return new OclOrderedSetImpl(eT, this.convert(array), this);
    }

    @Override
    public OclSequence Sequence(Classifier eT) {
        return this.Sequence(eT, new OclAny[0]);
    }

    @Override
    public OclSequence Sequence(Classifier eT, Collection impl) {
        return this.Sequence(eT, this.convert(impl.toArray()));
    }

    public OclSequence Sequence(Classifier eT, String seq) {
        return this.Sequence(eT, seq, false);
    }

    public OclSequence Sequence(Classifier eT, String seq, boolean newVariable) {
        return new OclSequenceImpl(eT, seq, this, newVariable);
    }

    @Override
    public OclSequence Sequence(Classifier eT, Object[] array) {
        return new OclSequenceImpl(eT, this.convert(array), this);
    }

    @Override
    public OclBag Bag(Classifier eT) {
        return this.Bag(eT, new OclAny[0]);
    }

    @Override
    public OclBag Bag(Classifier eT, Collection impl) {
        return this.Bag(eT, this.convert(impl.toArray()));
    }

    public OclBag Bag(Classifier eT, String b) {
        return this.Bag(eT, b, false);
    }

    public OclBag Bag(Classifier eT, String b, boolean newVariable) {
        return new OclBagImpl(eT, b, this, newVariable);
    }

    @Override
    public OclBag Bag(Classifier eT, Object[] array) {
        return new OclBagImpl(eT, this.convert(array), this);
    }

    protected OclAny[] convert(Object[] array) {
        if (array instanceof OclAny[]) {
            return (OclAny[])array;
        }
        OclAny[] oclArray = new OclAny[array.length];
        int i = 0;
        while (i < array.length) {
            oclArray[i] = this.OclAny(array[i]);
            ++i;
        }
        return oclArray;
    }
}

