/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.semantics.analyser;

import org.oslo.ocl20.semantics.SemanticsVisitor;
import org.oslo.ocl20.semantics.bridge.CallAction;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.bridge.DataType;
import org.oslo.ocl20.semantics.bridge.EnumLiteral;
import org.oslo.ocl20.semantics.bridge.EnumerationType;
import org.oslo.ocl20.semantics.bridge.Environment;
import org.oslo.ocl20.semantics.bridge.ModelElement;
import org.oslo.ocl20.semantics.bridge.NamedElement;
import org.oslo.ocl20.semantics.bridge.Namespace;
import org.oslo.ocl20.semantics.bridge.OclModelElementType;
import org.oslo.ocl20.semantics.bridge.Operation;
import org.oslo.ocl20.semantics.bridge.Primitive;
import org.oslo.ocl20.semantics.bridge.Property;
import org.oslo.ocl20.semantics.bridge.SendAction;
import org.oslo.ocl20.semantics.bridge.Signal;
import org.oslo.ocl20.semantics.model.contexts.ClassifierContextDecl;
import org.oslo.ocl20.semantics.model.contexts.Constraint;
import org.oslo.ocl20.semantics.model.contexts.ConstraintKind;
import org.oslo.ocl20.semantics.model.contexts.ConstraintKind$Class;
import org.oslo.ocl20.semantics.model.contexts.ContextDeclaration;
import org.oslo.ocl20.semantics.model.contexts.OperationContextDecl;
import org.oslo.ocl20.semantics.model.contexts.PropertyContextDecl;
import org.oslo.ocl20.semantics.model.expressions.BooleanLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.CallExp;
import org.oslo.ocl20.semantics.model.expressions.CollectionItem;
import org.oslo.ocl20.semantics.model.expressions.CollectionKind;
import org.oslo.ocl20.semantics.model.expressions.CollectionKind$Class;
import org.oslo.ocl20.semantics.model.expressions.CollectionLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.CollectionLiteralPart;
import org.oslo.ocl20.semantics.model.expressions.CollectionRange;
import org.oslo.ocl20.semantics.model.expressions.EnumLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.IfExp;
import org.oslo.ocl20.semantics.model.expressions.IntegerLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.IterateExp;
import org.oslo.ocl20.semantics.model.expressions.IteratorExp;
import org.oslo.ocl20.semantics.model.expressions.LetExp;
import org.oslo.ocl20.semantics.model.expressions.LiteralExp;
import org.oslo.ocl20.semantics.model.expressions.LoopExp;
import org.oslo.ocl20.semantics.model.expressions.ModelPropertyCallExp;
import org.oslo.ocl20.semantics.model.expressions.NumericalLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.OclExpression;
import org.oslo.ocl20.semantics.model.expressions.OclMessageArg;
import org.oslo.ocl20.semantics.model.expressions.OclMessageExp;
import org.oslo.ocl20.semantics.model.expressions.OperationCallExp;
import org.oslo.ocl20.semantics.model.expressions.PropertyCallExp;
import org.oslo.ocl20.semantics.model.expressions.RealLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.StringLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.TupleLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.TypeLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.UndefinedLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.UnspecifiedValueExp;
import org.oslo.ocl20.semantics.model.expressions.VariableDeclaration;
import org.oslo.ocl20.semantics.model.expressions.VariableExp;
import org.oslo.ocl20.semantics.model.types.BagType;
import org.oslo.ocl20.semantics.model.types.BooleanType;
import org.oslo.ocl20.semantics.model.types.CollectionType;
import org.oslo.ocl20.semantics.model.types.IntegerType;
import org.oslo.ocl20.semantics.model.types.OclAnyType;
import org.oslo.ocl20.semantics.model.types.OclMessageType;
import org.oslo.ocl20.semantics.model.types.OrderedSetType;
import org.oslo.ocl20.semantics.model.types.RealType;
import org.oslo.ocl20.semantics.model.types.SequenceType;
import org.oslo.ocl20.semantics.model.types.SetType;
import org.oslo.ocl20.semantics.model.types.StringType;
import org.oslo.ocl20.semantics.model.types.TupleType;
import org.oslo.ocl20.semantics.model.types.VoidType;

public class OclDebugVisitorImpl
implements SemanticsVisitor {
    protected static String tab = "    ";

    @Override
    public Object visit(Classifier host, Object data) {
        String indent = (String)data;
        return String.valueOf(indent) + host.toString();
    }

    @Override
    public Object visit(Property host, Object data) {
        String indent = (String)data;
        String type = String.valueOf(indent) + "null";
        if (host.getType() != null) {
            type = (String)host.getType().accept(this, "");
        }
        String result = new String();
        result = String.valueOf(result) + indent + "Property " + host.getName() + ":" + type;
        return result;
    }

    @Override
    public Object visit(Operation host, Object data) {
        String indent = (String)data;
        String result = String.valueOf(indent) + "Operation " + host.getName() + "(";
        int n = host.getParameterNames().size();
        int i = 0;
        while (i < n) {
            String name = (String)host.getParameterNames().get(i);
            String type = "null";
            if (host.getParameterTypes().get(i) != null) {
                type = "" + host.getParameterTypes().get(i);
            }
            result = String.valueOf(result) + name + ":" + type;
            if (i != n - 1) {
                result = String.valueOf(result) + ", ";
            }
            ++i;
        }
        result = String.valueOf(result) + ")";
        return result;
    }

    @Override
    public Object visit(Environment host, Object data) {
        return null;
    }

    @Override
    public Object visit(CallAction host, Object data) {
        return null;
    }

    @Override
    public Object visit(SendAction host, Object data) {
        return null;
    }

    @Override
    public Object visit(Signal host, Object data) {
        return null;
    }

    @Override
    public Object visit(ModelElement host, Object data) {
        return null;
    }

    @Override
    public Object visit(EnumerationType host, Object data) {
        return host.toString();
    }

    @Override
    public Object visit(Namespace host, Object data) {
        return null;
    }

    @Override
    public Object visit(NamedElement host, Object data) {
        return null;
    }

    @Override
    public Object visit(ContextDeclaration host, Object data) {
        return null;
    }

    @Override
    public Object visit(ClassifierContextDecl host, Object data) {
        String expStr = "error";
        for (Constraint con : host.getConstraint()) {
            if (con.getKind() != ConstraintKind$Class.INV) continue;
            OclExpression exp = con.getBodyExpression();
            Classifier type = null;
            if (exp == null) continue;
            type = exp.getType();
            expStr = (String)exp.accept(this, "");
            expStr = String.valueOf(expStr) + "\nType = " + type;
        }
        return expStr;
    }

    @Override
    public Object visit(OperationContextDecl host, Object data) {
        return null;
    }

    @Override
    public Object visit(PropertyContextDecl host, Object data) {
        return null;
    }

    @Override
    public Object visit(VariableDeclaration host, Object data) {
        String indent = (String)data;
        String result = String.valueOf(indent) + "Variable " + host.getName() + ":" + host.getType();
        if (host.getInitExpression() != null) {
            result = String.valueOf(result) + " = \n" + host.getInitExpression().accept(this, String.valueOf(tab) + data);
        }
        return result;
    }

    @Override
    public Object visit(Constraint host, Object data) {
        return null;
    }

    @Override
    public Object visit(ConstraintKind host, Object data) {
        return null;
    }

    @Override
    public Object visit(OclExpression host, Object data) {
        return "No debugVisit method for " + host.getClass().getName();
    }

    @Override
    public Object visit(LiteralExp host, Object data) {
        throw new RuntimeException("Should not be here!");
    }

    @Override
    public Object visit(UndefinedLiteralExp host, Object data) {
        return "undefined";
    }

    @Override
    public Object visit(NumericalLiteralExp host, Object data) {
        return null;
    }

    @Override
    public Object visit(BooleanLiteralExp host, Object data) {
        return String.valueOf((String)data) + "Boolean(" + host.getBooleanSymbol() + ")";
    }

    @Override
    public Object visit(TypeLiteralExp host, Object data) {
        return String.valueOf((String)data) + host.getType();
    }

    @Override
    public Object visit(IntegerLiteralExp host, Object data) {
        return String.valueOf((String)data) + "Integer(" + host.getIntegerSymbol() + ")";
    }

    @Override
    public Object visit(RealLiteralExp host, Object data) {
        return String.valueOf((String)data) + "Real(" + host.getRealSymbol() + ")";
    }

    @Override
    public Object visit(StringLiteralExp host, Object data) {
        return String.valueOf((String)data) + "String(" + host.getStringSymbol() + ")";
    }

    @Override
    public Object visit(EnumLiteralExp host, Object data) {
        return String.valueOf((String)data) + "Enum(" + host.getType().getName() + "." + host.getName() + ")";
    }

    @Override
    public Object visit(EnumLiteral host, Object data) {
        return String.valueOf((String)data) + host.toString();
    }

    @Override
    public Object visit(CollectionLiteralExp host, Object data) {
        String indent = (String)data;
        String kind = "null";
        if (host.getKind() != null) {
            kind = (String)host.getKind().accept(this, "");
        }
        String result = String.valueOf(indent) + kind + "{\n";
        for (CollectionLiteralPart part : host.getParts()) {
            if (part instanceof CollectionItem) {
                if (part != null) {
                    result = String.valueOf(result) + part.accept(this, String.valueOf(indent) + tab) + "\n";
                    continue;
                }
                result = String.valueOf(result) + indent + tab + "null\n";
                continue;
            }
            result = part != null ? String.valueOf(result) + part.accept(this, String.valueOf(indent) + tab) + "\n" : String.valueOf(result) + indent + tab + "null\n";
        }
        result = String.valueOf(result) + indent + "}";
        return result;
    }

    @Override
    public Object visit(CollectionKind host, Object data) {
        if (host == CollectionKind$Class.BAG) {
            return "Bag";
        }
        if (host == CollectionKind$Class.COLLECTION) {
            return "Collection";
        }
        if (host == CollectionKind$Class.ORDERED_SET) {
            return "OrderedSet";
        }
        if (host == CollectionKind$Class.SEQUENCE) {
            return "Sequence";
        }
        if (host == CollectionKind$Class.SET) {
            return "Set";
        }
        return "null";
    }

    @Override
    public Object visit(CollectionLiteralPart host, Object data) {
        return null;
    }

    @Override
    public Object visit(CollectionItem host, Object data) {
        return host.getItem().accept(this, data);
    }

    @Override
    public Object visit(CollectionRange host, Object data) {
        String indent = (String)data;
        String first = String.valueOf(indent) + "null";
        if (host.getFirst() != null) {
            first = (String)host.getFirst().accept(this, data);
        }
        String last = "null";
        if (host.getLast() != null) {
            last = (String)host.getLast().accept(this, "");
        }
        String result = String.valueOf(first) + ".." + last;
        return result;
    }

    @Override
    public Object visit(TupleLiteralExp host, Object data) {
        String indent = (String)data;
        String result = String.valueOf(indent) + "Tuple {\n";
        for (VariableDeclaration var : host.getTuplePart()) {
            result = var != null ? String.valueOf(result) + var.accept(this, String.valueOf(indent) + tab) + "\n" : String.valueOf(result) + indent + tab + "null\n";
        }
        result = String.valueOf(result) + indent + "}";
        return result;
    }

    @Override
    public Object visit(CallExp host, Object data) {
        return null;
    }

    @Override
    public Object visit(ModelPropertyCallExp host, Object data) {
        return null;
    }

    @Override
    public Object visit(OperationCallExp host, Object data) {
        String indent = (String)data;
        String source = String.valueOf(indent) + tab + "null";
        if (host.getSource() != null) {
            source = (String)host.getSource().accept(this, String.valueOf(indent) + tab);
        }
        String operation = String.valueOf(indent) + tab + "null";
        if (host.getReferredOperation() != null) {
            operation = (String)host.getReferredOperation().accept(this, String.valueOf(indent) + tab);
        }
        String result = String.valueOf(indent) + "OperationCall {\n";
        result = String.valueOf(result) + source + "\n";
        result = String.valueOf(result) + operation + "\n";
        for (OclExpression arg : host.getArguments()) {
            result = arg != null ? String.valueOf(result) + arg.accept(this, String.valueOf(indent) + tab) + "\n" : String.valueOf(result) + indent + tab + "null\n";
        }
        result = String.valueOf(result) + indent + "}";
        return result;
    }

    @Override
    public Object visit(PropertyCallExp host, Object data) {
        String indent = (String)data;
        String source = String.valueOf(indent) + tab + "null";
        String property = String.valueOf(indent) + tab + "null";
        if (host.getSource() != null) {
            source = (String)host.getSource().accept(this, String.valueOf(indent) + tab);
        }
        if (host.getReferredProperty() != null) {
            property = (String)host.getReferredProperty().accept(this, String.valueOf(indent) + tab);
        }
        String result = String.valueOf(indent) + "PropertyCall {\n";
        result = String.valueOf(result) + source + "\n";
        result = String.valueOf(result) + property + "\n";
        result = String.valueOf(result) + indent + "}";
        return result;
    }

    @Override
    public Object visit(LoopExp host, Object data) {
        return null;
    }

    @Override
    public Object visit(IteratorExp host, Object data) {
        String indent = (String)data;
        String source = String.valueOf(indent) + tab + "null";
        if (host.getSource() != null) {
            source = (String)host.getSource().accept(this, String.valueOf(indent) + tab);
        }
        String it1Str = String.valueOf(indent) + tab + "null";
        if (host.getIterators().size() >= 1) {
            it1Str = (String)((VariableDeclaration)host.getIterators().toArray()[0]).accept(this, String.valueOf(indent) + tab);
        }
        String it2Str = String.valueOf(indent) + tab + "null";
        if (host.getIterators().size() >= 2) {
            it2Str = (String)((VariableDeclaration)host.getIterators().toArray()[1]).accept(this, String.valueOf(indent) + tab);
        }
        String body = String.valueOf(indent) + tab + "null";
        if (host.getBody() != null) {
            body = (String)host.getBody().accept(this, String.valueOf(indent) + tab);
        }
        String result = String.valueOf(indent) + "Iterator " + host.getName() + " {\n";
        result = String.valueOf(result) + source + "\n";
        result = String.valueOf(result) + it1Str + "\n";
        result = String.valueOf(result) + it2Str + "\n";
        result = String.valueOf(result) + body + "\n";
        result = String.valueOf(result) + indent + "}";
        return result;
    }

    @Override
    public Object visit(IterateExp host, Object data) {
        String indent = (String)data;
        String source = String.valueOf(indent) + tab + "null";
        if (host.getSource() != null) {
            source = (String)host.getSource().accept(this, String.valueOf(indent) + tab);
        }
        String it1Str = String.valueOf(indent) + tab + "null";
        if (host.getIterators().size() >= 1) {
            it1Str = (String)((VariableDeclaration)host.getIterators().toArray()[0]).accept(this, String.valueOf(indent) + tab);
        }
        String it2Str = String.valueOf(indent) + tab + "null";
        if (host.getResult() != null) {
            it2Str = (String)host.getResult().accept(this, String.valueOf(indent) + tab);
        }
        String body = String.valueOf(indent) + tab + "null";
        if (host.getBody() != null) {
            body = (String)host.getBody().accept(this, String.valueOf(indent) + tab);
        }
        String result = String.valueOf(indent) + "Iterate {\n";
        result = String.valueOf(result) + source + "\n";
        result = String.valueOf(result) + it1Str + "\n";
        result = String.valueOf(result) + it2Str + "\n";
        result = String.valueOf(result) + body + "\n";
        result = String.valueOf(result) + indent + "}";
        return result;
    }

    @Override
    public Object visit(VariableExp host, Object data) {
        String indent = (String)data;
        String result = String.valueOf(indent) + "VariableExp {\n";
        String var = String.valueOf(indent) + tab + "null";
        if (host.getReferredVariable() != null) {
            var = (String)host.getReferredVariable().accept(this, String.valueOf(indent) + tab);
        }
        result = String.valueOf(result) + var + "\n";
        result = String.valueOf(result) + indent + "}";
        return result;
    }

    @Override
    public Object visit(IfExp host, Object data) {
        String indent = (String)data;
        String condition = String.valueOf(indent) + tab + "null";
        if (host.getCondition() != null) {
            condition = (String)host.getCondition().accept(this, String.valueOf(indent) + tab);
        }
        String thenStr = String.valueOf(indent) + tab + "null";
        if (host.getThenExpression() != null) {
            thenStr = (String)host.getThenExpression().accept(this, String.valueOf(indent) + tab);
        }
        String elseStr = String.valueOf(indent) + tab + "null";
        if (host.getElseExpression() != null) {
            elseStr = (String)host.getElseExpression().accept(this, String.valueOf(indent) + tab);
        }
        String result = String.valueOf(indent) + "IfExp {\n";
        result = String.valueOf(result) + condition + "\n";
        result = String.valueOf(result) + thenStr + "\n";
        result = String.valueOf(result) + elseStr + "\n";
        result = String.valueOf(result) + indent + "}";
        return result;
    }

    @Override
    public Object visit(LetExp host, Object data) {
        String indent = (String)data;
        String result = String.valueOf(indent) + "LetExp {\n";
        VariableDeclaration var = host.getVariable();
        result = var != null ? String.valueOf(result) + (String)var.accept(this, String.valueOf(indent) + tab) : String.valueOf(result) + indent + tab + "null";
        result = String.valueOf(result) + "\n";
        String in = String.valueOf(indent) + tab + "null";
        if (host.getIn() != null) {
            in = (String)host.getIn().accept(this, String.valueOf(indent) + tab);
        }
        result = String.valueOf(result) + in + "\n";
        result = String.valueOf(result) + indent + "}";
        return result;
    }

    @Override
    public Object visit(OclMessageExp host, Object data) {
        return null;
    }

    @Override
    public Object visit(OclMessageArg host, Object data) {
        return null;
    }

    @Override
    public Object visit(UnspecifiedValueExp host, Object data) {
        return null;
    }

    @Override
    public Object visit(OclAnyType host, Object data) {
        String indent = (String)data;
        return String.valueOf(indent) + host.toString();
    }

    @Override
    public Object visit(DataType host, Object data) {
        String indent = (String)data;
        return String.valueOf(indent) + host.toString();
    }

    @Override
    public Object visit(Primitive host, Object data) {
        String indent = (String)data;
        return String.valueOf(indent) + host.toString();
    }

    @Override
    public Object visit(BooleanType host, Object data) {
        String indent = (String)data;
        return String.valueOf(indent) + host.toString();
    }

    @Override
    public Object visit(IntegerType host, Object data) {
        String indent = (String)data;
        return String.valueOf(indent) + host.toString();
    }

    @Override
    public Object visit(RealType host, Object data) {
        String indent = (String)data;
        return String.valueOf(indent) + host.toString();
    }

    @Override
    public Object visit(StringType host, Object data) {
        String indent = (String)data;
        return String.valueOf(indent) + host.toString();
    }

    @Override
    public Object visit(TupleType host, Object data) {
        String indent = (String)data;
        return String.valueOf(indent) + host.toString();
    }

    @Override
    public Object visit(CollectionType host, Object data) {
        String indent = (String)data;
        return String.valueOf(indent) + host.toString();
    }

    @Override
    public Object visit(SequenceType host, Object data) {
        String indent = (String)data;
        return String.valueOf(indent) + host.toString();
    }

    @Override
    public Object visit(OrderedSetType host, Object data) {
        String indent = (String)data;
        return String.valueOf(indent) + host.toString();
    }

    @Override
    public Object visit(SetType host, Object data) {
        String indent = (String)data;
        return String.valueOf(indent) + host.toString();
    }

    @Override
    public Object visit(BagType host, Object data) {
        String indent = (String)data;
        return String.valueOf(indent) + host.toString();
    }

    @Override
    public Object visit(OclModelElementType host, Object data) {
        String indent = (String)data;
        return String.valueOf(indent) + host.toString();
    }

    @Override
    public Object visit(OclMessageType host, Object data) {
        String indent = (String)data;
        return String.valueOf(indent) + host.toString();
    }

    @Override
    public Object visit(VoidType host, Object data) {
        String indent = (String)data;
        return String.valueOf(indent) + host.toString();
    }
}

