/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.semantics.analyser;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.semantics.SemanticsVisitor;
import org.oslo.ocl20.semantics.analyser.OclSemanticAnalyser;
import org.oslo.ocl20.semantics.bridge.Environment;
import org.oslo.ocl20.semantics.model.contexts.ContextDeclaration;
import org.oslo.ocl20.syntax.ast.astVisitor;
import org.oslo.ocl20.syntax.ast.contexts.PackageDeclarationAS;
import uk.ac.kent.cs.kmf.util.ILog;
import uk.ac.kent.cs.kmf.util.OutputStreamLog;

public class OclSemanticAnalyserImpl
implements OclSemanticAnalyser {
    protected OclProcessor processor;
    protected astVisitor semanticAnalyzerVisitor;
    protected SemanticsVisitor debugVisitor = null;
    protected ILog log;
    protected boolean hasErrors;

    public OclSemanticAnalyserImpl(OclProcessor proc, astVisitor semanticAnalyzerVisitor, SemanticsVisitor debugVisitor, ILog log) {
        this.processor = proc;
        this.semanticAnalyzerVisitor = semanticAnalyzerVisitor;
        this.debugVisitor = debugVisitor;
        this.log = log;
    }

    @Override
    public List analyse(PackageDeclarationAS decl) {
        Environment env = this.processor.getBridgeFactory().buildEnvironment();
        new OutputStreamLog((OutputStream)System.out);
        return this.analyse(decl, env);
    }

    @Override
    public List analyse(PackageDeclarationAS decl, Environment env) {
        OutputStreamLog log = new OutputStreamLog((OutputStream)System.out);
        return this.analyse(decl, env, (ILog)log);
    }

    @Override
    public List analyse(PackageDeclarationAS decl, Environment env, ILog log) {
        return this.analyse(decl, env, log, false);
    }

    @Override
    public List analyse(PackageDeclarationAS decl, Environment env, ILog log, boolean debugFlag) {
        int errNo = log.getErrors();
        HashMap<String, Environment> context = new HashMap<String, Environment>();
        context.put("env", env);
        context.put("log", (Environment)log);
        List l = (List)decl.accept(this.semanticAnalyzerVisitor, context);
        boolean bl = this.hasErrors = log.getErrors() > errNo && !log.tooManyViolations();
        if (debugFlag) {
            for (ContextDeclaration contextDecl : l) {
                String exprStr = (String)contextDecl.accept(this.debugVisitor, "");
                log.reportMessage("OCL Model:");
                log.reportMessage(exprStr);
            }
        }
        return l;
    }

    @Override
    public boolean hasErrors() {
        return this.hasErrors;
    }
}

