/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.semantics.analyser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.semantics.SemanticsElement;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.bridge.EnumLiteral;
import org.oslo.ocl20.semantics.bridge.EnumerationType;
import org.oslo.ocl20.semantics.bridge.Environment;
import org.oslo.ocl20.semantics.bridge.ModelElement;
import org.oslo.ocl20.semantics.bridge.NamedElement;
import org.oslo.ocl20.semantics.bridge.Namespace;
import org.oslo.ocl20.semantics.bridge.OclModelElementType;
import org.oslo.ocl20.semantics.bridge.Operation;
import org.oslo.ocl20.semantics.bridge.Primitive;
import org.oslo.ocl20.semantics.bridge.Property;
import org.oslo.ocl20.semantics.model.contexts.ClassifierContextDecl;
import org.oslo.ocl20.semantics.model.contexts.ClassifierContextDecl$Class;
import org.oslo.ocl20.semantics.model.contexts.Constraint$Class;
import org.oslo.ocl20.semantics.model.contexts.ConstraintKind;
import org.oslo.ocl20.semantics.model.contexts.ConstraintKind$Class;
import org.oslo.ocl20.semantics.model.contexts.DefinedOperation;
import org.oslo.ocl20.semantics.model.contexts.DefinedOperationImpl;
import org.oslo.ocl20.semantics.model.contexts.DefinedProperty;
import org.oslo.ocl20.semantics.model.contexts.DefinedPropertyImpl;
import org.oslo.ocl20.semantics.model.contexts.OperationContextDecl$Class;
import org.oslo.ocl20.semantics.model.contexts.PropertyContextDecl$Class;
import org.oslo.ocl20.semantics.model.expressions.BooleanLiteralExp$Class;
import org.oslo.ocl20.semantics.model.expressions.CallExp;
import org.oslo.ocl20.semantics.model.expressions.CollectionItem$Class;
import org.oslo.ocl20.semantics.model.expressions.CollectionKind;
import org.oslo.ocl20.semantics.model.expressions.CollectionKind$Class;
import org.oslo.ocl20.semantics.model.expressions.CollectionLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.CollectionLiteralExp$Class;
import org.oslo.ocl20.semantics.model.expressions.CollectionLiteralPart;
import org.oslo.ocl20.semantics.model.expressions.CollectionRange$Class;
import org.oslo.ocl20.semantics.model.expressions.EnumLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.EnumLiteralExp$Class;
import org.oslo.ocl20.semantics.model.expressions.IfExp$Class;
import org.oslo.ocl20.semantics.model.expressions.IntegerLiteralExp$Class;
import org.oslo.ocl20.semantics.model.expressions.IterateExp$Class;
import org.oslo.ocl20.semantics.model.expressions.IteratorExp$Class;
import org.oslo.ocl20.semantics.model.expressions.LetExp;
import org.oslo.ocl20.semantics.model.expressions.LetExp$Class;
import org.oslo.ocl20.semantics.model.expressions.OclExpression;
import org.oslo.ocl20.semantics.model.expressions.OperationCallExp$Class;
import org.oslo.ocl20.semantics.model.expressions.PropertyCallExp;
import org.oslo.ocl20.semantics.model.expressions.PropertyCallExp$Class;
import org.oslo.ocl20.semantics.model.expressions.RealLiteralExp$Class;
import org.oslo.ocl20.semantics.model.expressions.StringLiteralExp$Class;
import org.oslo.ocl20.semantics.model.expressions.TupleLiteralExp$Class;
import org.oslo.ocl20.semantics.model.expressions.TypeLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.TypeLiteralExp$Class;
import org.oslo.ocl20.semantics.model.expressions.UndefinedLiteralExp$Class;
import org.oslo.ocl20.semantics.model.expressions.VariableDeclaration;
import org.oslo.ocl20.semantics.model.expressions.VariableDeclaration$Class;
import org.oslo.ocl20.semantics.model.expressions.VariableExp;
import org.oslo.ocl20.semantics.model.expressions.VariableExp$Class;
import org.oslo.ocl20.semantics.model.types.BagType;
import org.oslo.ocl20.semantics.model.types.BooleanType;
import org.oslo.ocl20.semantics.model.types.CollectionType;
import org.oslo.ocl20.semantics.model.types.OrderedSetType;
import org.oslo.ocl20.semantics.model.types.SequenceType;
import org.oslo.ocl20.semantics.model.types.SetType;
import org.oslo.ocl20.semantics.model.types.TupleType;
import org.oslo.ocl20.semantics.model.types.TypeType;
import org.oslo.ocl20.semantics.model.types.VoidType;
import org.oslo.ocl20.syntax.ast.SyntaxElement;
import org.oslo.ocl20.syntax.ast.astVisitor;
import org.oslo.ocl20.syntax.ast.contexts.ClassifierContextDeclAS;
import org.oslo.ocl20.syntax.ast.contexts.ConstraintAS;
import org.oslo.ocl20.syntax.ast.contexts.ConstraintKindAS;
import org.oslo.ocl20.syntax.ast.contexts.ContextDeclarationAS;
import org.oslo.ocl20.syntax.ast.contexts.OperationAS;
import org.oslo.ocl20.syntax.ast.contexts.OperationContextDeclAS;
import org.oslo.ocl20.syntax.ast.contexts.PackageDeclarationAS;
import org.oslo.ocl20.syntax.ast.contexts.PropertyContextDeclAS;
import org.oslo.ocl20.syntax.ast.contexts.VariableDeclarationAS;
import org.oslo.ocl20.syntax.ast.contexts.contextsVisitor;
import org.oslo.ocl20.syntax.ast.expressions.AndExpAS;
import org.oslo.ocl20.syntax.ast.expressions.ArrowSelectionExpAS;
import org.oslo.ocl20.syntax.ast.expressions.AssociationCallExpAS;
import org.oslo.ocl20.syntax.ast.expressions.BooleanLiteralExpAS;
import org.oslo.ocl20.syntax.ast.expressions.CallExpAS;
import org.oslo.ocl20.syntax.ast.expressions.CollectionItemAS;
import org.oslo.ocl20.syntax.ast.expressions.CollectionKindAS;
import org.oslo.ocl20.syntax.ast.expressions.CollectionLiteralExpAS;
import org.oslo.ocl20.syntax.ast.expressions.CollectionLiteralPartAS;
import org.oslo.ocl20.syntax.ast.expressions.CollectionRangeAS;
import org.oslo.ocl20.syntax.ast.expressions.DotSelectionExpAS;
import org.oslo.ocl20.syntax.ast.expressions.EnumLiteralExpAS;
import org.oslo.ocl20.syntax.ast.expressions.IfExpAS;
import org.oslo.ocl20.syntax.ast.expressions.ImpliesExpAS;
import org.oslo.ocl20.syntax.ast.expressions.IntegerLiteralExpAS;
import org.oslo.ocl20.syntax.ast.expressions.IterateExpAS;
import org.oslo.ocl20.syntax.ast.expressions.IteratorExpAS;
import org.oslo.ocl20.syntax.ast.expressions.LetExpAS;
import org.oslo.ocl20.syntax.ast.expressions.NotExpAS;
import org.oslo.ocl20.syntax.ast.expressions.OclExpressionAS;
import org.oslo.ocl20.syntax.ast.expressions.OclMessageArgAS;
import org.oslo.ocl20.syntax.ast.expressions.OclMessageExpAS;
import org.oslo.ocl20.syntax.ast.expressions.OclMessageKindAS;
import org.oslo.ocl20.syntax.ast.expressions.OperationCallExpAS;
import org.oslo.ocl20.syntax.ast.expressions.OrExpAS;
import org.oslo.ocl20.syntax.ast.expressions.PathNameExpAS;
import org.oslo.ocl20.syntax.ast.expressions.RealLiteralExpAS;
import org.oslo.ocl20.syntax.ast.expressions.SelectionExpAS;
import org.oslo.ocl20.syntax.ast.expressions.StringLiteralExpAS;
import org.oslo.ocl20.syntax.ast.expressions.TupleLiteralExpAS;
import org.oslo.ocl20.syntax.ast.expressions.XorExpAS;
import org.oslo.ocl20.syntax.ast.expressions.expressionsVisitor;
import org.oslo.ocl20.syntax.ast.types.BagTypeAS;
import org.oslo.ocl20.syntax.ast.types.ClassifierAS;
import org.oslo.ocl20.syntax.ast.types.CollectionTypeAS;
import org.oslo.ocl20.syntax.ast.types.OrderedSetTypeAS;
import org.oslo.ocl20.syntax.ast.types.SequenceTypeAS;
import org.oslo.ocl20.syntax.ast.types.SetTypeAS;
import org.oslo.ocl20.syntax.ast.types.TupleTypeAS;
import org.oslo.ocl20.syntax.ast.types.typesVisitor;
import org.oslo.ocl20.syntax.parser.ErrorManager;
import uk.ac.kent.cs.kmf.patterns.Visitable;
import uk.ac.kent.cs.kmf.patterns.VisitorImpl;
import uk.ac.kent.cs.kmf.util.ILog;

public class OclSemanticAnalyserVisitorImpl
extends VisitorImpl
implements astVisitor,
contextsVisitor,
expressionsVisitor,
typesVisitor {
    protected Object symbol = null;
    protected boolean DEBUG = false;
    protected OclProcessor processor = null;
    static long counter = 0L;

    public Object visit(Visitable host, Object data) {
        Object o = null;
        return o;
    }

    @Override
    public Object visit(SyntaxElement host, Object data) {
        Object o = null;
        return o;
    }

    @Override
    public Object visit(OclExpressionAS host, Object data) {
        Object o = null;
        return o;
    }

    @Override
    public Object visit(ContextDeclarationAS host, Object data) {
        Object o = null;
        return o;
    }

    public OclSemanticAnalyserVisitorImpl(OclProcessor proc) {
        super(proc.getLog());
        this.processor = proc;
    }

    protected String newName() {
        return "_tempIt" + counter++;
    }

    @Override
    public Object visit(PackageDeclarationAS host, Object data) {
        ((Map)data).put("action", "declare defs");
        for (ContextDeclarationAS asContext : host.getContextDecls()) {
            asContext.accept(this, data);
        }
        ((Map)data).put("action", null);
        Vector<Object> semContexts = new Vector<Object>();
        for (ContextDeclarationAS asContext : host.getContextDecls()) {
            semContexts.add(asContext.accept(this, data));
        }
        return semContexts;
    }

    @Override
    public Object visit(ClassifierContextDeclAS host, Object data) {
        Environment env = (Environment)((Map)data).get("env");
        Environment newEnv = null;
        ILog log = (ILog)((Map)data).get("log");
        this.symbol = host.getSymbol();
        ClassifierContextDecl$Class semContext = new ClassifierContextDecl$Class();
        if (host.getType() == null) {
            host.getPathName();
            log.reportError("Context type is null - " + host);
            return null;
        }
        TypeLiteralExp tle = (TypeLiteralExp)host.getType().accept(this, data);
        Classifier contextCls = tle.getLiteralType();
        semContext.setReferredClassifier(contextCls);
        newEnv = env.addVariableDeclaration("self", contextCls, Boolean.TRUE);
        Vector<Object> semConstraints = new Vector<Object>();
        Iterator i = host.getConstraints().iterator();
        HashMap<String, SemanticsElement> newData = new HashMap<String, SemanticsElement>();
        newData.putAll((Map)data);
        newData.put("env", newEnv);
        newData.put("context", semContext);
        while (i.hasNext()) {
            ConstraintAS asConstraint = (ConstraintAS)i.next();
            semConstraints.add(asConstraint.accept(this, newData));
        }
        semContext.setConstraint(semConstraints);
        return semContext;
    }

    @Override
    public Object visit(PropertyContextDeclAS host, Object data) {
        Iterator i;
        Environment env = (Environment)((Map)data).get("env");
        ILog log = (ILog)((Map)data).get("log");
        this.symbol = host.getSymbol();
        PropertyContextDecl$Class semContext = new PropertyContextDecl$Class();
        semContext.setReferredNamespace((Namespace)env.lookupPathName(host.getPathName()));
        List pathName = host.getPathName();
        String name = host.getName();
        pathName.add(name);
        ModelElement element = env.lookupPathName(pathName);
        if (element instanceof Property) {
            Property property = (Property)element;
            semContext.setReferredProperty((Property)element);
            if (host.getType() != null) {
                TypeLiteralExp tle = (TypeLiteralExp)host.getType().accept(this, data);
                property.setType(tle.getLiteralType());
            }
        } else {
            String pathNameStr = new String();
            i = host.getPathName().iterator();
            while (i.hasNext()) {
                pathNameStr = String.valueOf(pathNameStr) + (String)i.next();
                if (!i.hasNext()) continue;
                pathNameStr = String.valueOf(pathNameStr) + ".";
            }
            ErrorManager.reportError(log, this.symbol, "SA: Unknown property '" + pathName + "'");
        }
        Vector<Object> semConstraints = new Vector<Object>();
        i = host.getConstraints().iterator();
        HashMap<String, PropertyContextDecl$Class> newData = new HashMap<String, PropertyContextDecl$Class>();
        newData.putAll((Map)data);
        if (element instanceof Property) {
            newData.put("context", semContext);
        }
        while (i.hasNext()) {
            ConstraintAS asConstraint = (ConstraintAS)i.next();
            semConstraints.add(asConstraint.accept(this, newData));
        }
        semContext.setConstraint(semConstraints);
        return semContext;
    }

    @Override
    public Object visit(OperationContextDeclAS host, Object data) {
        Environment env = (Environment)((Map)data).get("env");
        ILog cfr_ignored_0 = (ILog)((Map)data).get("log");
        OperationContextDecl$Class semContext = new OperationContextDecl$Class();
        semContext.setReferredNamespace((Namespace)env.lookupPathName(host.getOperation().getPathName()));
        if (host.getOperation() != null) {
            semContext.setReferredOperation((Operation)host.getOperation().accept(this, data));
        }
        Vector<Object> semConstraints = new Vector<Object>();
        Iterator i = host.getConstraints().iterator();
        HashMap<String, OperationContextDecl$Class> newData = new HashMap<String, OperationContextDecl$Class>();
        newData.putAll((Map)data);
        newData.put("context", semContext);
        while (i.hasNext()) {
            ConstraintAS asConstraint = (ConstraintAS)i.next();
            semConstraints.add(asConstraint.accept(this, newData));
        }
        semContext.setConstraint(semConstraints);
        return semContext;
    }

    @Override
    public Object visit(VariableDeclarationAS host, Object data) {
        Environment cfr_ignored_0 = (Environment)((Map)data).get("env");
        ILog log = (ILog)((Map)data).get("log");
        VariableDeclaration$Class semVar = new VariableDeclaration$Class();
        semVar.setName(host.getName());
        if (host.getType() != null) {
            TypeLiteralExp tle = (TypeLiteralExp)host.getType().accept(this, data);
            semVar.setType(tle.getLiteralType());
        } else {
            semVar.setType(null);
        }
        if (host.getInitExp() != null) {
            OclExpression initExp = (OclExpression)host.getInitExp().accept(this, data);
            if (initExp == null) {
                ErrorManager.reportError(log, this.symbol, "SA: Problem analysing expression - " + host.getInitExp());
                return null;
            }
            if (semVar.getType() == null) {
                semVar.setType(initExp.getType());
            } else {
                Classifier varType = semVar.getType();
                Classifier initType = initExp.getType();
                if (!initType.conformsTo(varType).booleanValue()) {
                    ErrorManager.reportError(log, this.symbol, "SA: Non-conforming types '" + varType + "' and '" + initType + "' in variable declaration.");
                }
                if (varType instanceof TypeType && ((TypeType)varType).getClassifier() == null) {
                    semVar.setType(initExp.getType());
                }
            }
            semVar.setInitExpression(initExp);
        }
        return semVar;
    }

    @Override
    public Object visit(OperationAS host, Object data) {
        Vector<Object> semParameters = new Vector<Object>();
        for (VariableDeclarationAS asVar : host.getParameters()) {
            semParameters.add(asVar.accept(this, data));
        }
        Operation semOper = this.processor.getBridgeFactory().buildOperation(null, host.getName(), null);
        return semOper;
    }

    @Override
    public Object visit(ConstraintAS host, Object data) {
        Environment env = (Environment)((Map)data).get("env");
        ILog log = (ILog)((Map)data).get("log");
        String action = (String)((Map)data).get("action");
        ClassifierContextDecl context = (ClassifierContextDecl)((Map)data).get("context");
        ConstraintKind consKind = (ConstraintKind)host.getKind().accept(this, data);
        Constraint$Class semCons = new Constraint$Class();
        semCons.setName(host.getName());
        semCons.setContext(context);
        semCons.setKind(consKind);
        if (consKind == ConstraintKind$Class.BODY) {
            semCons = new Constraint$Class();
            if (host.getDefOperation() != null) {
                semCons.setDefOperation((Operation)host.getDefOperation().accept(this, data));
            }
        } else if (consKind == ConstraintKind$Class.DEF) {
            VariableDeclarationAS defVar = host.getDefVariable();
            if (defVar != null) {
                Classifier type = this.processor.getTypeFactory().buildOclAnyType();
                if (defVar.getType() != null) {
                    TypeLiteralExp tle = (TypeLiteralExp)defVar.getType().accept(this, data);
                    type = tle.getLiteralType();
                } else {
                    OclExpression exp = (OclExpression)defVar.getInitExp().accept(this, data);
                    type = exp.getType();
                }
                Classifier selfType = context.getReferredClassifier();
                Property prop = selfType.lookupProperty(defVar.getName());
                if (action != null && action.equals("declare defs")) {
                    prop = new DefinedPropertyImpl(defVar.getName(), type, null);
                    selfType.addProperty(prop);
                } else {
                    semCons.setDefProperty(prop);
                    semCons.setName(prop.getName());
                    if (prop instanceof DefinedProperty) {
                        ((DefinedProperty)prop).setDefinition(semCons);
                    } else {
                        log.reportError("Error: Trying to 'def' property " + prop.getName() + " on class " + selfType + "\n" + "property already defined in the model");
                    }
                    if (prop == null) {
                        log.reportError("Code Error: Property " + prop.getName() + " on class " + selfType + "\n" + "doesn't exist. visit ConstraintAS with action set to 'define property' first.");
                    }
                }
            } else {
                OperationAS defOp = host.getDefOperation();
                if (defOp != null) {
                    Classifier type = this.processor.getTypeFactory().buildOclAnyType();
                    if (defOp.getType() != null) {
                        TypeLiteralExp tle = (TypeLiteralExp)defOp.getType().accept(this, data);
                        type = tle.getLiteralType();
                    }
                    Vector<String> pNames = new Vector<String>();
                    Vector<Classifier> pTypes = new Vector<Classifier>();
                    if (defOp.getParameters() != null) {
                        List params = defOp.getParameters();
                        for (VariableDeclarationAS varDec : params) {
                            VariableDeclaration var = (VariableDeclaration)varDec.accept(this, data);
                            pNames.add(var.getName());
                            pTypes.add(var.getType());
                        }
                    }
                    Classifier selfType = context.getReferredClassifier();
                    Operation op = selfType.lookupOperation(defOp.getName(), pTypes);
                    if (action != null && action.equals("declare defs")) {
                        op = new DefinedOperationImpl(defOp.getName(), type, pTypes, pNames, null);
                        selfType.addOperation(op);
                    } else {
                        semCons.setDefOperation(op);
                        semCons.setName(op.getName());
                        int i_p = 0;
                        while (i_p < pNames.size()) {
                            String name = (String)pNames.get(i_p);
                            Classifier clsf = (Classifier)pTypes.get(i_p);
                            env = env.addVariableDeclaration(name, clsf, Boolean.TRUE);
                            ++i_p;
                        }
                        ((Map)data).put("env", env);
                        if (op instanceof DefinedOperation) {
                            ((DefinedOperation)op).setDefinition(semCons);
                        } else {
                            log.reportError("Error: Trying to 'def' operation " + op.getName() + " on class " + selfType + "\n" + "operation already defined in the model");
                        }
                        if (op == null) {
                            log.reportError("Code Error: Operation " + op.getName() + " on class " + selfType + "\n" + "doesn't exist. visit ConstraintAS with action set to 'define defs' first.");
                        }
                    }
                }
            }
        } else if (consKind != ConstraintKind$Class.DERIVE && consKind != ConstraintKind$Class.INIT && consKind != ConstraintKind$Class.INV && consKind != ConstraintKind$Class.PRE) {
        }
        if (action == null) {
            Object val = host.getBodyExpression().accept(this, data);
            semCons.setBodyExpression((OclExpression)val);
        }
        return semCons;
    }

    @Override
    public Object visit(ConstraintKindAS host, Object data) {
        ConstraintKind kind = null;
        if (host == ConstraintKindAS.BODY) {
            kind = ConstraintKind$Class.BODY;
        } else if (host == ConstraintKindAS.DEF) {
            kind = ConstraintKind$Class.DEF;
        } else if (host == ConstraintKindAS.DERIVE) {
            kind = ConstraintKind$Class.DERIVE;
        } else if (host == ConstraintKindAS.INIT) {
            kind = ConstraintKind$Class.INIT;
        } else if (host == ConstraintKindAS.INV) {
            kind = ConstraintKind$Class.INV;
        } else if (host == ConstraintKindAS.PRE) {
            kind = ConstraintKind$Class.PRE;
        } else if (host == ConstraintKindAS.POST) {
            kind = ConstraintKind$Class.POST;
        }
        return kind;
    }

    @Override
    public Object visit(BooleanLiteralExpAS host, Object data) {
        if (host.getValue() == null) {
            UndefinedLiteralExp$Class result = new UndefinedLiteralExp$Class();
            result.setType(this.processor.getTypeFactory().buildVoidType());
            result.setIsMarkedPre(host.getIsMarkedPre());
            return result;
        }
        BooleanLiteralExp$Class result = new BooleanLiteralExp$Class();
        result.setBooleanSymbol(host.getValue());
        result.setType(this.processor.getTypeFactory().buildBooleanType());
        result.setIsMarkedPre(host.getIsMarkedPre());
        return result;
    }

    @Override
    public Object visit(IntegerLiteralExpAS host, Object data) {
        IntegerLiteralExp$Class result = new IntegerLiteralExp$Class();
        result.setIntegerSymbol(host.getValue());
        result.setType(this.processor.getTypeFactory().buildIntegerType());
        result.setIsMarkedPre(host.getIsMarkedPre());
        return result;
    }

    @Override
    public Object visit(RealLiteralExpAS host, Object data) {
        RealLiteralExp$Class result = new RealLiteralExp$Class();
        result.setRealSymbol(host.getValue());
        result.setType(this.processor.getTypeFactory().buildRealType());
        result.setIsMarkedPre(host.getIsMarkedPre());
        return result;
    }

    @Override
    public Object visit(StringLiteralExpAS host, Object data) {
        StringLiteralExp$Class result = new StringLiteralExp$Class();
        result.setStringSymbol(host.getValue());
        result.setType(this.processor.getTypeFactory().buildStringType());
        result.setIsMarkedPre(host.getIsMarkedPre());
        return result;
    }

    @Override
    public Object visit(EnumLiteralExpAS host, Object data) {
        Environment env = (Environment)((Map)data).get("env");
        ILog cfr_ignored_0 = (ILog)((Map)data).get("log");
        List pathName = host.getPathName().subList(0, host.getPathName().size() - 1);
        String enumName = (String)host.getPathName().get(host.getPathName().size() - 1);
        Classifier type = (Classifier)env.lookupPathName(pathName);
        EnumLiteralExp$Class result = new EnumLiteralExp$Class();
        result.setType(type);
        result.setName(enumName);
        result.setReferredEnumLiteral(((EnumerationType)type).lookupEnumLiteral(enumName));
        result.setIsMarkedPre(host.getIsMarkedPre());
        return result;
    }

    @Override
    public Object visit(CollectionLiteralExpAS host, Object data) {
        try {
            Environment cfr_ignored_0 = (Environment)((Map)data).get("env");
            ILog log = (ILog)((Map)data).get("log");
            Iterator i = host.getCollectionParts().iterator();
            Classifier elementType = this.processor.getTypeFactory().buildVoidType();
            while (i.hasNext()) {
                Object o = i.next();
                CollectionLiteralPart crtElement = (CollectionLiteralPart)((CollectionLiteralPartAS)o).accept(this, data);
                Classifier crtElementType = crtElement.getType();
                Classifier tempType = this.checkTypes(elementType, crtElementType);
                if (tempType == null) {
                    ErrorManager.reportWarning(log, this.symbol, "SA: Non-conforming types '" + elementType + "' and '" + crtElementType + "' in collection literal.");
                    elementType = this.processor.getTypeFactory().buildOclAnyType();
                    break;
                }
                elementType = tempType;
            }
            CollectionType type = null;
            CollectionKindAS kind = host.getKind();
            type = kind == CollectionKindAS.BAG ? this.processor.getTypeFactory().buildBagType(elementType) : (kind == CollectionKindAS.SET ? this.processor.getTypeFactory().buildSetType(elementType) : (kind == CollectionKindAS.ORDERED_SET ? this.processor.getTypeFactory().buildOrderedSetType(elementType) : (kind == CollectionKindAS.SEQUENCE ? this.processor.getTypeFactory().buildSequenceType(elementType) : this.processor.getTypeFactory().buildCollectionType(elementType))));
            type.setElementType(elementType);
            Vector<Object> colParts = new Vector<Object>();
            i = host.getCollectionParts().iterator();
            while (i.hasNext()) {
                colParts.add(((CollectionLiteralPartAS)i.next()).accept(this, data));
            }
            CollectionLiteralExp$Class result = new CollectionLiteralExp$Class();
            result.setKind((CollectionKind)host.getKind().accept(this, data));
            result.setParts(colParts);
            result.setType(type);
            result.setIsMarkedPre(host.getIsMarkedPre());
            return result;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    @Override
    public Object visit(CollectionKindAS host, Object data) {
        CollectionKind kind = null;
        if (host == CollectionKindAS.COLLECTION) {
            kind = CollectionKind$Class.COLLECTION;
        } else if (host == CollectionKindAS.BAG) {
            kind = CollectionKind$Class.BAG;
        } else if (host == CollectionKindAS.SET) {
            kind = CollectionKind$Class.SET;
        } else if (host == CollectionKindAS.SEQUENCE) {
            kind = CollectionKind$Class.SEQUENCE;
        } else if (host == CollectionKindAS.ORDERED_SET) {
            kind = CollectionKind$Class.ORDERED_SET;
        }
        return kind;
    }

    @Override
    public Object visit(CollectionItemAS host, Object data) {
        CollectionItem$Class result = new CollectionItem$Class();
        result.setItem((OclExpression)host.getItem().accept(this, data));
        result.setType(result.getItem().getType());
        return result;
    }

    @Override
    public Object visit(CollectionRangeAS host, Object data) {
        try {
            Environment cfr_ignored_0 = (Environment)((Map)data).get("env");
            ILog log = (ILog)((Map)data).get("log");
            Classifier type = null;
            OclExpression firstExp = (OclExpression)host.getFirst().accept(this, data);
            Classifier firstType = firstExp.getType();
            OclExpression lastExp = (OclExpression)host.getLast().accept(this, data);
            Classifier lastType = lastExp.getType();
            type = this.checkTypes(firstType, lastType);
            if (type == null) {
                ErrorManager.reportError(log, this.symbol, "SA: Non-conforming types '" + firstType + "' and '" + lastType + "' in collection range.");
                type = this.processor.getTypeFactory().buildVoidType();
            }
            CollectionRange$Class result = new CollectionRange$Class();
            result.setType(type);
            result.setFirst(firstExp);
            result.setLast(lastExp);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    @Override
    public Object visit(TupleLiteralExpAS host, Object data) {
        try {
            TupleType type = this.processor.getTypeFactory().buildTupleType(new String[0], new Classifier[0]);
            Vector<VariableDeclaration$Class> semTupleParts = new Vector<VariableDeclaration$Class>();
            for (VariableDeclarationAS varDeclAS : host.getTupleParts()) {
                VariableDeclaration$Class varDecl = new VariableDeclaration$Class();
                varDecl.setName(varDeclAS.getName());
                Classifier varType = null;
                if (varDeclAS.getType() != null) {
                    TypeLiteralExp tle = (TypeLiteralExp)varDeclAS.getType().accept(this, data);
                    varType = tle.getLiteralType();
                }
                OclExpression init = null;
                if (varDeclAS.getInitExp() != null) {
                    init = (OclExpression)varDeclAS.getInitExp().accept(this, data);
                    if (varType == null) {
                        varType = init.getType();
                    }
                }
                varDecl.setInitExpression(init);
                if (varType == null) {
                    varDecl.setType(this.processor.getTypeFactory().buildOclAnyType());
                } else {
                    varDecl.setType(varType);
                }
                semTupleParts.add(varDecl);
            }
            type.setPartType(semTupleParts);
            TupleLiteralExp$Class result = new TupleLiteralExp$Class();
            result.setTuplePart(semTupleParts);
            result.setType(type);
            result.setIsMarkedPre(host.getIsMarkedPre());
            return result;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    protected String getString(List pathName) {
        String res = new String();
        Iterator i = pathName.iterator();
        while (i.hasNext()) {
            res = String.valueOf(res) + (String)i.next();
            if (!i.hasNext()) continue;
            res = String.valueOf(res) + "::";
        }
        return res;
    }

    protected boolean isPartOfCall(OclExpressionAS host) {
        OclExpressionAS parent = host.getParent();
        return parent != null && parent instanceof CallExpAS;
    }

    @Override
    public Object visit(PathNameExpAS host, Object data) {
        try {
            Environment env = (Environment)((Map)data).get("env");
            ILog log = (ILog)((Map)data).get("log");
            OclExpression result = null;
            Classifier type = null;
            List pathName = host.getPathName();
            String pathNameStr = this.getString(pathName);
            if (pathName.size() == 1) {
                ModelElement element = env.lookup(pathNameStr);
                if (element != null && element instanceof VariableDeclaration) {
                    type = ((VariableDeclaration)element).getType();
                    VariableDeclaration semVarDecl = (VariableDeclaration)element;
                    result = new VariableExp$Class();
                    ((VariableExp)result).setReferredVariable(semVarDecl);
                    result.setType(type);
                } else if (element != null && element instanceof Classifier) {
                    if (host.getParent() != null) {
                        String operation = host.getParent().toString();
                        if ((operation = operation.substring(pathNameStr.length() + 1)).equals("allInstances")) {
                            type = (Classifier)element;
                            result = new TypeLiteralExp$Class(pathNameStr, Boolean.FALSE, (Classifier)element);
                            result.setType(type);
                        } else {
                            type = this.processor.getTypeFactory().buildTypeType((Classifier)element);
                            result = new TypeLiteralExp$Class(pathNameStr, Boolean.FALSE, (Classifier)element);
                            result.setType(type);
                        }
                    } else {
                        type = this.processor.getTypeFactory().buildTypeType((Classifier)element);
                        result = new TypeLiteralExp$Class(pathNameStr, Boolean.FALSE, (Classifier)element);
                        result.setType(type);
                    }
                } else {
                    NamedElement entry = env.lookupImplicitSourceForProperty(pathNameStr);
                    Property prop = env.lookupImplicitProperty(pathNameStr);
                    PropertyCallExp$Class propCall = new PropertyCallExp$Class();
                    result = propCall;
                    propCall.setReferredProperty(prop);
                    if (entry != null) {
                        VariableExp$Class sourceExp = new VariableExp$Class();
                        sourceExp.setReferredVariable((VariableDeclaration)entry.getReferredElement());
                        sourceExp.setType(((VariableDeclaration)entry.getReferredElement()).getType());
                        propCall.setSource(sourceExp);
                        type = prop.getType();
                    } else {
                        ErrorManager.reportError(log, this.symbol, "SA: Unknown property or variable or pathName'" + pathNameStr + "'");
                    }
                    propCall.setType(type);
                }
            } else {
                ModelElement element = env.lookupPathName(pathName);
                if (element == null) {
                    ErrorManager.reportError(log, this.symbol, "SA: Unknown pathname '" + pathNameStr + "'");
                } else if (element instanceof Property) {
                    type = ((Property)element).getType();
                    result = new PropertyCallExp$Class();
                    ((PropertyCallExp)result).setReferredProperty((Property)element);
                    result.setType(type);
                } else if (element instanceof EnumLiteral) {
                    result = new EnumLiteralExp$Class();
                    ((EnumLiteralExp)result).setReferredEnumLiteral((EnumLiteral)element);
                    type = ((EnumLiteral)element).getEnumeration();
                    result.setType(type);
                } else if (element != null && element instanceof Classifier) {
                    type = this.processor.getTypeFactory().buildTypeType((Classifier)element);
                    result = new TypeLiteralExp$Class(pathNameStr, Boolean.FALSE, (Classifier)element);
                    result.setType(type);
                } else {
                    ErrorManager.reportError(log, this.symbol, "SA: Unknown pathname '" + pathNameStr + "'");
                    type = this.processor.getTypeFactory().buildVoidType();
                }
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    @Override
    public Object visit(DotSelectionExpAS host, Object data) {
        try {
            Environment cfr_ignored_0 = (Environment)((Map)data).get("env");
            ILog log = (ILog)((Map)data).get("log");
            CallExp result = null;
            Classifier type = null;
            OclExpressionAS source = host.getSource();
            OclExpression semSource = (OclExpression)source.accept(this, data);
            if (semSource != null) {
                Classifier sourceType = semSource.getType();
                if (sourceType instanceof CollectionType) {
                    Classifier elementType = ((CollectionType)sourceType).getElementType();
                    Property property = elementType.lookupProperty(host.getName());
                    if (property != null) {
                        IteratorExp$Class itExp = new IteratorExp$Class();
                        result = itExp;
                        itExp.setIsMarkedPre(host.getIsMarkedPre());
                        itExp.setName("collect");
                        itExp.setSource(semSource);
                        VariableDeclaration$Class it = new VariableDeclaration$Class();
                        it.setName(this.newName());
                        it.setType(elementType);
                        itExp.setIterators(new LinkedHashSet());
                        itExp.getIterators().add(it);
                        PropertyCallExp$Class propCall = new PropertyCallExp$Class();
                        VariableExp$Class propSource = new VariableExp$Class();
                        propSource.setReferredVariable(it);
                        propSource.setType(it.getType());
                        propCall.setSource(propSource);
                        propCall.setReferredProperty(property);
                        itExp.setBody(propCall);
                        Classifier propertyType = property.getType();
                        propCall.setType(propertyType);
                        if (propertyType instanceof CollectionType) {
                            type = this.baseElementType((CollectionType)propertyType);
                        } else if (propertyType instanceof Classifier) {
                            type = propertyType;
                        }
                        Operation op = sourceType.lookupOperation("collect", Arrays.asList(propertyType));
                        if (op != null) {
                            type = op.getReturnType();
                            itExp.setType(type);
                        } else {
                            ErrorManager.reportError(log, this.symbol, "SA: No operation " + sourceType + "->collect(" + propertyType + ")");
                        }
                    } else {
                        ErrorManager.reportError(log, this.symbol, "SA: Unknown property '" + host.getName() + "' on '" + elementType + "'");
                    }
                } else if (sourceType instanceof Classifier) {
                    Property property = sourceType.lookupProperty(host.getName());
                    if (property != null) {
                        Classifier propertyType;
                        PropertyCallExp$Class propCall;
                        result = propCall = new PropertyCallExp$Class();
                        propCall.setIsMarkedPre(host.getIsMarkedPre());
                        propCall.setSource(semSource);
                        propCall.setReferredProperty(property);
                        type = propertyType = property.getType();
                        propCall.setType(type);
                    } else {
                        ErrorManager.reportError(log, this.symbol, "SA: Unknown property '" + host.getName() + "' on '" + sourceType + "'");
                    }
                }
            } else {
                ErrorManager.reportError(log, this.symbol, "SA: Left hand side of '.' operator is undefined");
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    public Classifier baseElementType(Classifier t) {
        if (t instanceof CollectionType) {
            return this.baseElementType(((CollectionType)t).getElementType());
        }
        return t;
    }

    @Override
    public Object visit(ArrowSelectionExpAS host, Object data) {
        try {
            Environment cfr_ignored_0 = (Environment)((Map)data).get("env");
            ILog cfr_ignored_1 = (ILog)((Map)data).get("log");
            return this.visit(host.getSource(), data);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    protected static boolean isIteratorOperation(CollectionType type, String name) {
        String collection = "*exists*forAll*isUnique*any*one*collect*collectNested*";
        String bag = "*select*reject*collectNested*sortedBy*";
        String set = "*select*reject*collectNested*sortedBy*";
        String sequence = "*select*reject*collectNested*sortedBy*";
        String orderedSet = "*select*reject*collectNested*sortedBy*";
        String x = "*" + name + "*";
        if (type instanceof BagType) {
            return collection.indexOf(x) != -1 || bag.indexOf(x) != -1;
        }
        if (type instanceof OrderedSetType) {
            return collection.indexOf(x) != -1 || orderedSet.indexOf(x) != -1;
        }
        if (type instanceof SequenceType) {
            return collection.indexOf(x) != -1 || sequence.indexOf(x) != -1;
        }
        if (type instanceof SetType) {
            return collection.indexOf(x) != -1 || set.indexOf(x) != -1;
        }
        if (type instanceof CollectionType) {
            return collection.indexOf(x) != -1;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object visit(OperationCallExpAS host, Object data) {
        try {
            Classifier type;
            CallExp result;
            block27: {
                OclExpressionAS source;
                Operation oper;
                Vector<OclExpression> args;
                Vector<Classifier> types;
                ILog log;
                block25: {
                    String pathNameStr;
                    block26: {
                        List pathName;
                        OperationCallExp$Class callExp;
                        Environment env = (Environment)((Map)data).get("env");
                        log = (ILog)((Map)data).get("log");
                        result = null;
                        type = null;
                        types = new Vector<Classifier>();
                        args = new Vector<OclExpression>();
                        Iterator i = host.getArguments().iterator();
                        while (true) {
                            if (!i.hasNext()) {
                                oper = null;
                                source = host.getSource();
                                if (!(source instanceof PathNameExpAS)) break block25;
                                result = callExp = new OperationCallExp$Class();
                                pathName = ((PathNameExpAS)source).getPathName();
                                pathNameStr = this.getString(pathName);
                                if (pathName.size() != 1) break;
                                oper = env.lookupImplicitOperation(pathNameStr, types);
                                NamedElement entry = env.lookupImplicitSourceForOperation(pathNameStr, types);
                                if (entry != null) {
                                    VariableExp$Class sourceExp = new VariableExp$Class();
                                    sourceExp.setReferredVariable((VariableDeclaration)entry.getReferredElement());
                                    sourceExp.setType(((VariableDeclaration)entry.getReferredElement()).getType());
                                    callExp.setSource(sourceExp);
                                }
                                callExp.setReferredOperation(oper);
                                callExp.setArguments(args);
                                break block26;
                            }
                            OclExpressionAS pExp = (OclExpressionAS)i.next();
                            OclExpression paramExp = (OclExpression)pExp.accept(this, data);
                            if (paramExp == null) {
                                log.reportError("Problem evaluating expression : " + pExp);
                                return null;
                            }
                            Classifier paramType = paramExp.getType();
                            args.add(paramExp);
                            types.add(paramType);
                        }
                        oper = env.lookupPathName(pathName, types);
                        callExp.setSource(null);
                        callExp.setReferredOperation(oper);
                        callExp.setArguments(args);
                    }
                    if (oper != null) {
                        type = oper.getReturnType();
                        if ("collect collectNested".indexOf(pathNameStr) != -1 && type instanceof CollectionType && types.size() != 0) {
                            ((CollectionType)type).setElementType((Classifier)types.get(0));
                        }
                        break block27;
                    } else {
                        ErrorManager.reportError(log, this.symbol, "SA: Unknown operation '" + pathNameStr + "' or type mismatch between parameters and arguments");
                    }
                    break block27;
                }
                if (source instanceof ArrowSelectionExpAS) {
                    OclExpressionAS realSource = ((ArrowSelectionExpAS)source).getSource();
                    OclExpression semRealSource = (OclExpression)realSource.accept(this, data);
                    if (semRealSource == null) {
                        log.reportError("Proplem analysing expression - " + realSource);
                        return null;
                    }
                    String name = ((ArrowSelectionExpAS)source).getName();
                    Classifier realSourceType = semRealSource.getType();
                    if (!(realSourceType instanceof CollectionType)) {
                        CollectionItem$Class colItem = new CollectionItem$Class();
                        colItem.setItem(semRealSource);
                        semRealSource = new CollectionLiteralExp$Class();
                        realSourceType = this.processor.getTypeFactory().buildSetType(realSourceType);
                        semRealSource.setType(realSourceType);
                        ((CollectionLiteralExp)semRealSource).setKind(CollectionKind$Class.SET);
                        ((CollectionLiteralExp)semRealSource).getParts().add(colItem);
                    }
                    if (realSourceType instanceof CollectionType && OclSemanticAnalyserVisitorImpl.isIteratorOperation((CollectionType)realSourceType, name)) {
                        IteratorExp$Class itExp = new IteratorExp$Class();
                        result = itExp;
                        itExp.setName(name);
                        itExp.setIterators(new LinkedHashSet());
                        VariableDeclaration$Class it = new VariableDeclaration$Class();
                        Classifier elementType = ((CollectionType)realSourceType).getElementType();
                        it.setType(elementType);
                        itExp.getIterators().add(it);
                        itExp.setSource(semRealSource);
                        itExp.setName(name);
                        if (args != null && args.size() > 0) {
                            itExp.setBody((OclExpression)args.get(0));
                        }
                        oper = realSourceType.lookupOperation(name, types);
                    } else {
                        OperationCallExp$Class callExp;
                        result = callExp = new OperationCallExp$Class();
                        callExp.setSource(semRealSource);
                        callExp.setArguments(args);
                        oper = realSourceType.lookupOperation(name, types);
                        callExp.setReferredOperation(oper);
                    }
                    if (oper == null) {
                        ErrorManager.reportError(log, this.symbol, "SA: Unknown operation '" + name + "(" + types + ")' in type '" + realSourceType + "' or type mismatch between parameters and arguments");
                        return null;
                    }
                    type = oper.getReturnType();
                    if (type instanceof TypeType) {
                        type = ((TypeType)type).getClassifier();
                    }
                    if ("collect collectNested".indexOf(name) != -1 && type instanceof CollectionType && types.size() != 0) {
                        ((CollectionType)type).setElementType((Classifier)types.get(0));
                    }
                } else if (source instanceof DotSelectionExpAS) {
                    String name = ((SelectionExpAS)source).getName();
                    OclExpressionAS realSource = ((SelectionExpAS)source).getSource();
                    OclExpression semRealSource = (OclExpression)realSource.accept(this, data);
                    if (semRealSource == null) {
                        ErrorManager.reportError(log, null, "SA: Problem analysing expression : " + realSource);
                        return null;
                    }
                    Classifier realSourceType = semRealSource.getType();
                    oper = realSourceType.lookupOperation(name, types);
                    OperationCallExp$Class callExp = new OperationCallExp$Class();
                    callExp.setSource(semRealSource);
                    callExp.setArguments(args);
                    callExp.setReferredOperation(oper);
                    result = callExp;
                    if (oper == null && realSourceType instanceof CollectionType) {
                        IteratorExp$Class itExp = new IteratorExp$Class();
                        result = itExp;
                        itExp.setIterators(new LinkedHashSet());
                        VariableDeclaration$Class it = new VariableDeclaration$Class();
                        Classifier elementType = ((CollectionType)realSourceType).getElementType();
                        it.setType(elementType);
                        itExp.getIterators().add(it);
                        itExp.setSource(semRealSource);
                        itExp.setName(name);
                        OperationCallExp$Class body = new OperationCallExp$Class();
                        VariableExp$Class bodySource = new VariableExp$Class();
                        bodySource.setReferredVariable(it);
                        bodySource.setType(it.getType());
                        body.setSource(bodySource);
                        body.setArguments(args);
                        oper = elementType.lookupOperation(name, types);
                        body.setReferredOperation(oper);
                    }
                    if (oper == null) {
                        ErrorManager.reportError(log, this.symbol, "SA: Unknown operation '" + name + types + "' in '" + realSourceType + "' or type mismatch between parameters and arguments");
                        return null;
                    }
                    type = oper.getReturnType();
                    if (type instanceof TypeType) {
                        type = ((TypeType)type).getClassifier();
                    }
                    if ("collect collectNested".indexOf(name) != -1 && type instanceof CollectionType && types.size() != 0) {
                        ((CollectionType)type).setElementType((Classifier)types.get(0));
                    }
                }
            }
            result.setType(type);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object visit(AssociationCallExpAS host, Object data) {
        try {
            void var5_10;
            Classifier type;
            block12: {
                OclExpressionAS source;
                Environment env = (Environment)((Map)data).get("env");
                ILog log = (ILog)((Map)data).get("log");
                Object var5_6 = null;
                type = null;
                Vector<Object> semQuals = new Vector<Object>();
                Iterator i = host.getArguments().iterator();
                while (true) {
                    if (!i.hasNext()) {
                        PropertyCallExp$Class propCall;
                        source = host.getSource();
                        if (!(source instanceof PathNameExpAS)) break;
                        PropertyCallExp$Class propertyCallExp$Class = propCall = new PropertyCallExp$Class();
                        propCall.setQualifiers(semQuals);
                        String name = this.getString(((PathNameExpAS)((Object)host)).getPathName());
                        Property prop = env.lookupImplicitProperty(name);
                        propCall.setReferredProperty(prop);
                        NamedElement entry = env.lookupImplicitSourceForProperty(name);
                        if (entry != null) {
                            VariableExp$Class sourceExp = new VariableExp$Class();
                            sourceExp.setReferredVariable((VariableDeclaration)entry.getReferredElement());
                            sourceExp.setType(((VariableDeclaration)entry.getReferredElement()).getType());
                            propCall.setSource(sourceExp);
                        }
                        type = prop.getType();
                        break block12;
                    }
                    OclExpressionAS arg = (OclExpressionAS)i.next();
                    semQuals.add(arg.accept(this, data));
                }
                if (source instanceof DotSelectionExpAS) {
                    OclExpressionAS realSource = ((DotSelectionExpAS)source).getSource();
                    OclExpression realSemSource = (OclExpression)realSource.accept(this, data);
                    Classifier realSourceType = realSemSource.getType();
                    if (realSourceType instanceof CollectionType) {
                        IteratorExp$Class itExp;
                        String name;
                        Classifier elementType = ((CollectionType)realSourceType).getElementType();
                        Property property = elementType.lookupProperty(name = ((DotSelectionExpAS)source).getName());
                        if (property == null) {
                            ErrorManager.reportError(log, this.symbol, "SA: Unknown property '" + name + "' on type '" + elementType + "'");
                            return null;
                        }
                        IteratorExp$Class iteratorExp$Class = itExp = new IteratorExp$Class();
                        itExp.setIsMarkedPre(host.getIsMarkedPre());
                        itExp.setSource(realSemSource);
                        itExp.setName("collect");
                        VariableDeclaration$Class it = new VariableDeclaration$Class();
                        it.setName(this.newName());
                        it.setType(elementType);
                        itExp.setIterators(new LinkedHashSet());
                        itExp.getIterators().add(it);
                        PropertyCallExp$Class propCall = new PropertyCallExp$Class();
                        VariableExp$Class propSource = new VariableExp$Class();
                        propSource.setReferredVariable(it);
                        propSource.setType(it.getType());
                        propCall.setSource(propSource);
                        propCall.setReferredProperty(property);
                        itExp.setBody(propCall);
                        Classifier propertyType = property.getType();
                        propCall.setType(propertyType);
                        if (propertyType instanceof CollectionType) {
                            type = ((CollectionType)propertyType).getElementType();
                        } else if (propertyType instanceof Classifier) {
                            type = propertyType;
                        }
                        type = realSourceType instanceof BagType ? this.processor.getTypeFactory().buildBagType(type) : (realSourceType instanceof OrderedSetType ? this.processor.getTypeFactory().buildOrderedSetType(type) : (realSourceType instanceof SetType ? this.processor.getTypeFactory().buildBagType(type) : this.processor.getTypeFactory().buildSequenceType(type)));
                        itExp.setType(type);
                    } else {
                        PropertyCallExp$Class propCall;
                        PropertyCallExp$Class propertyCallExp$Class = propCall = new PropertyCallExp$Class();
                        propCall.setQualifiers(semQuals);
                        String name = this.getString(((PathNameExpAS)((Object)host)).getPathName());
                        Property prop = realSourceType.lookupProperty(name);
                        propCall.setReferredProperty(prop);
                        propCall.setSource(realSemSource);
                        type = prop.getType();
                    }
                }
            }
            var5_10.setType(type);
            return var5_10;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    @Override
    public Object visit(IteratorExpAS host, Object data) {
        Classifier type;
        IteratorExp$Class result;
        block12: {
            ILog log;
            block14: {
                block15: {
                    Vector<Classifier> types;
                    OclExpression body;
                    Vector<VariableDeclaration> iteratorVars;
                    String name;
                    Classifier sourceType;
                    OclExpression semRealSource;
                    block17: {
                        Classifier elementType;
                        block16: {
                            Environment env;
                            block13: {
                                env = (Environment)((Map)data).get("env");
                                log = (ILog)((Map)data).get("log");
                                result = new IteratorExp$Class();
                                type = null;
                                OclExpressionAS source = host.getSource();
                                if (!(source instanceof SelectionExpAS)) break block12;
                                OclExpressionAS realSource = ((SelectionExpAS)source).getSource();
                                semRealSource = (OclExpression)realSource.accept(this, data);
                                if (semRealSource != null) break block13;
                                ErrorManager.reportError(log, this.symbol, "SA: Problem analysing expression - " + realSource);
                                return null;
                            }
                            try {
                                sourceType = semRealSource.getType();
                                if (sourceType == null) break block14;
                                if (sourceType instanceof OclModelElementType || sourceType instanceof Primitive) {
                                    sourceType = this.processor.getTypeFactory().buildSetType(sourceType);
                                }
                                if (!(sourceType instanceof CollectionType)) break block15;
                                elementType = ((CollectionType)sourceType).getElementType();
                                name = ((ArrowSelectionExpAS)host.getSource()).getName();
                                Environment env1 = env.nestedEnvironment();
                                iteratorVars = new Vector<VariableDeclaration>();
                                for (VariableDeclarationAS varAs : host.getIterator()) {
                                    VariableDeclaration var = (VariableDeclaration)varAs.accept(this, data);
                                    Classifier varType = var.getType();
                                    if (varType == null || varType instanceof VoidType) {
                                        varType = elementType;
                                        var.setType(elementType);
                                    }
                                    iteratorVars.add(var);
                                    env1 = env1.addVariableDeclaration(var.getName(), var.getType(), Boolean.FALSE);
                                }
                                HashMap<String, Environment> data1 = new HashMap<String, Environment>();
                                data1.putAll((Map)data);
                                data1.put("env", env1);
                                OclExpressionAS bodyAS = host.getBody();
                                body = (OclExpression)bodyAS.accept(this, data1);
                                if (body != null) break block16;
                                log.reportError("Propblem analysing body expression - " + bodyAS);
                                return null;
                            }
                            catch (Exception e) {
                                e.printStackTrace(System.out);
                                return null;
                            }
                        }
                        Classifier bodyType = body.getType();
                        Classifier var1Type = ((VariableDeclaration)iteratorVars.get(0)).getType();
                        types = new Vector<Classifier>();
                        types.add(var1Type);
                        types.add(bodyType);
                        if (elementType.conformsTo(var1Type).booleanValue()) break block17;
                        ErrorManager.reportError(log, this.symbol, "SA: Element type '" + elementType + "' does not conform to iterator type '" + var1Type + "'");
                        return null;
                    }
                    Operation oper = ((CollectionType)sourceType).lookupOperation(name, types);
                    if (oper != null) {
                        type = oper.getReturnType();
                        result.setSource(semRealSource);
                        result.setName(name);
                        result.setIterators(new HashSet(iteratorVars));
                        result.setBody(body);
                        break block12;
                    }
                    ErrorManager.reportError(log, this.symbol, "SA: Unknown iterator '" + sourceType + "->" + name + types + "' or type mismatch between parameters and arguments");
                    return null;
                }
                ErrorManager.reportError(log, this.symbol, "SA: Left hand side of '->' operator should be a collection type");
                return null;
            }
            ErrorManager.reportError(log, this.symbol, "SA: Left hand side of '->' operator has a wrong type");
            return null;
        }
        result.setType(type);
        return result;
    }

    @Override
    public Object visit(IterateExpAS host, Object data) {
        OclExpression source;
        IterateExp$Class result;
        Environment env;
        block7: {
            env = (Environment)((Map)data).get("env");
            ILog log = (ILog)((Map)data).get("log");
            result = new IterateExp$Class();
            result.setIsMarkedPre(host.getIsMarkedPre());
            source = (OclExpression)host.getSource().accept(this, data);
            if (source.getType() instanceof CollectionType) break block7;
            ErrorManager.reportError(log, this.symbol, "SA: Source of 'iterate' must be a collection");
            return null;
        }
        try {
            Classifier varType;
            Classifier elementType = ((CollectionType)source.getType()).getElementType();
            result.setSource(source);
            Environment env1 = env.nestedEnvironment();
            Vector<VariableDeclaration> iteratorVars = new Vector<VariableDeclaration>();
            for (VariableDeclarationAS varAs : host.getIterator()) {
                VariableDeclaration var = (VariableDeclaration)varAs.accept(this, data);
                varType = var.getType();
                if (varType == null || varType instanceof VoidType) {
                    varType = elementType;
                    var.setType(elementType);
                }
                iteratorVars.add(var);
                env1 = env1.addVariableDeclaration(var.getName(), var.getType(), Boolean.FALSE);
            }
            result.setIterators(new HashSet());
            result.getIterators().add((VariableDeclaration)iteratorVars.get(0));
            VariableDeclaration var = (VariableDeclaration)host.getResult().accept(this, data);
            env1 = env1.addVariableDeclaration(var.getName(), var.getType(), Boolean.FALSE);
            result.setResult(var);
            HashMap<String, Environment> data1 = new HashMap<String, Environment>();
            data1.putAll((Map)data);
            data1.put("env", env1);
            data = data1;
            result.setBody((OclExpression)host.getBody().accept(this, data));
            varType = result.getBody().getType();
            if (varType == null) {
                varType = this.processor.getTypeFactory().buildOclAnyType();
            }
            result.setType(varType);
            return result;
        }
        catch (Exception e) {
            if (this.DEBUG) {
                e.printStackTrace(System.out);
            }
            return null;
        }
    }

    @Override
    public Object visit(NotExpAS host, Object data) {
        try {
            String opName = "not";
            Environment cfr_ignored_0 = (Environment)((Map)data).get("env");
            ILog log = (ILog)((Map)data).get("log");
            OperationCallExp$Class opExp = new OperationCallExp$Class();
            Classifier type = null;
            OclExpression leftExp = (OclExpression)host.getLeftOperand().accept(this, data);
            type = leftExp.getType();
            if (type == null || !(type instanceof BooleanType)) {
                ErrorManager.reportError(log, this.symbol, "SA: The 'not' method is not defined for the type '" + type + "'");
                type = this.processor.getTypeFactory().buildBooleanType();
            }
            opExp.setSource(leftExp);
            opExp.setName(opName);
            opExp.setReferredOperation(type.lookupOperation(opName, new ArrayList()));
            opExp.setType(type);
            leftExp.setAppliedProperty(opExp);
            return opExp;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    @Override
    public Object visit(AndExpAS host, Object data) {
        try {
            String opName = "and";
            Environment cfr_ignored_0 = (Environment)((Map)data).get("env");
            ILog log = (ILog)((Map)data).get("log");
            OperationCallExp$Class opExp = new OperationCallExp$Class();
            OclExpression leftExp = (OclExpression)host.getLeftOperand().accept(this, data);
            Classifier leftType = leftExp.getType();
            OclExpression rightExp = (OclExpression)host.getRightOperand().accept(this, data);
            Classifier rightType = rightExp.getType();
            if (!(leftType instanceof BooleanType)) {
                ErrorManager.reportError(log, this.symbol, "SA: The 'and' method is not defined for the type '" + leftType + "'");
            } else if (!(rightType instanceof BooleanType)) {
                ErrorManager.reportError(log, this.symbol, "SA: The 'and' method is not defined for the argument type '" + rightType + "'");
            }
            opExp.setSource(leftExp);
            opExp.setName(opName);
            ArrayList<Classifier> argumentTypes = new ArrayList<Classifier>();
            ArrayList<OclExpression> arguments = new ArrayList<OclExpression>();
            arguments.add(rightExp);
            argumentTypes.add(rightType);
            opExp.setReferredOperation(leftType.lookupOperation(opName, argumentTypes));
            opExp.setType(rightType);
            opExp.setArguments(arguments);
            leftExp.setAppliedProperty(opExp);
            return opExp;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    @Override
    public Object visit(OrExpAS host, Object data) {
        try {
            String opName = "or";
            Environment cfr_ignored_0 = (Environment)((Map)data).get("env");
            ILog log = (ILog)((Map)data).get("log");
            OperationCallExp$Class opExp = new OperationCallExp$Class();
            OclExpression leftExp = (OclExpression)host.getLeftOperand().accept(this, data);
            Classifier leftType = leftExp.getType();
            OclExpression rightExp = (OclExpression)host.getRightOperand().accept(this, data);
            Classifier rightType = rightExp.getType();
            if (!(leftType instanceof BooleanType)) {
                ErrorManager.reportError(log, this.symbol, "SA: The 'or' method is not defined for the type '" + leftType + "'");
            } else if (!(rightType instanceof BooleanType)) {
                ErrorManager.reportError(log, this.symbol, "SA: The 'or' method is not defined for the argument type '" + rightType + "'");
            }
            opExp.setSource(leftExp);
            opExp.setName(opName);
            ArrayList<Classifier> argumentTypes = new ArrayList<Classifier>();
            ArrayList<OclExpression> arguments = new ArrayList<OclExpression>();
            arguments.add(rightExp);
            argumentTypes.add(rightType);
            opExp.setReferredOperation(leftType.lookupOperation(opName, argumentTypes));
            opExp.setType(rightType);
            opExp.setArguments(arguments);
            leftExp.setAppliedProperty(opExp);
            return opExp;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    @Override
    public Object visit(XorExpAS host, Object data) {
        try {
            String opName = "xor";
            Environment cfr_ignored_0 = (Environment)((Map)data).get("env");
            ILog log = (ILog)((Map)data).get("log");
            OperationCallExp$Class opExp = new OperationCallExp$Class();
            OclExpression leftExp = (OclExpression)host.getLeftOperand().accept(this, data);
            Classifier leftType = leftExp.getType();
            OclExpression rightExp = (OclExpression)host.getRightOperand().accept(this, data);
            Classifier rightType = rightExp.getType();
            if (!(leftType instanceof BooleanType)) {
                ErrorManager.reportError(log, this.symbol, "SA: The 'xor' method is not defined for the type '" + leftType + "'");
            } else if (!(rightType instanceof BooleanType)) {
                ErrorManager.reportError(log, this.symbol, "SA: The 'xor' method is not defined for the argument type '" + rightType + "'");
            }
            opExp.setSource(leftExp);
            opExp.setName(opName);
            ArrayList<Classifier> argumentTypes = new ArrayList<Classifier>();
            ArrayList<OclExpression> arguments = new ArrayList<OclExpression>();
            arguments.add(rightExp);
            argumentTypes.add(rightType);
            opExp.setReferredOperation(leftType.lookupOperation(opName, argumentTypes));
            opExp.setType(rightType);
            opExp.setArguments(arguments);
            leftExp.setAppliedProperty(opExp);
            return opExp;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    @Override
    public Object visit(ImpliesExpAS host, Object data) {
        try {
            String opName = "implies";
            Environment cfr_ignored_0 = (Environment)((Map)data).get("env");
            ILog log = (ILog)((Map)data).get("log");
            OperationCallExp$Class opExp = new OperationCallExp$Class();
            OclExpression leftExp = (OclExpression)host.getLeftOperand().accept(this, data);
            Classifier leftType = leftExp.getType();
            OclExpression rightExp = (OclExpression)host.getRightOperand().accept(this, data);
            Classifier rightType = rightExp.getType();
            if (!(leftType instanceof BooleanType)) {
                ErrorManager.reportError(log, this.symbol, "SA: The 'implies' method is not defined for the type '" + leftType + "'");
            } else if (!(rightType instanceof BooleanType)) {
                ErrorManager.reportError(log, this.symbol, "SA: The 'implies' method is not defined for the argument type '" + rightType + "'");
            }
            opExp.setSource(leftExp);
            opExp.setName(opName);
            ArrayList<Classifier> argumentTypes = new ArrayList<Classifier>();
            ArrayList<OclExpression> arguments = new ArrayList<OclExpression>();
            arguments.add(rightExp);
            argumentTypes.add(rightType);
            opExp.setReferredOperation(leftType.lookupOperation(opName, argumentTypes));
            opExp.setType(rightType);
            opExp.setArguments(arguments);
            leftExp.setAppliedProperty(opExp);
            return opExp;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    @Override
    public Object visit(IfExpAS host, Object data) {
        try {
            OclExpression elseExp;
            Classifier elseType;
            OclExpression thenExp;
            Classifier thenType;
            Environment cfr_ignored_0 = (Environment)((Map)data).get("env");
            ILog log = (ILog)((Map)data).get("log");
            IfExp$Class result = new IfExp$Class();
            Classifier type = null;
            OclExpression condExp = (OclExpression)host.getCondition().accept(this, data);
            Classifier condType = condExp.getType();
            if (!(condType instanceof BooleanType)) {
                ErrorManager.reportError(log, this.symbol, "SA: The condition of 'if' must be boolean");
                type = this.processor.getTypeFactory().buildBooleanType();
            }
            if ((type = this.checkTypes(thenType = (thenExp = (OclExpression)host.getThenExpression().accept(this, data)).getType(), elseType = (elseExp = (OclExpression)host.getElseExpression().accept(this, data)).getType())) == null) {
                ErrorManager.reportError(log, this.symbol, "SA: Different types for branches - if " + condType + " then " + thenType + " else " + elseType + " endif");
            }
            result.setCondition(condExp);
            result.setThenExpression(thenExp);
            result.setElseExpression(elseExp);
            result.setType(type);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object visit(LetExpAS host, Object data) {
        try {
            LetExp$Class result;
            Environment env = (Environment)((Map)data).get("env");
            ILog log = (ILog)((Map)data).get("log");
            LetExp$Class lastLetExp = result = new LetExp$Class();
            Iterator i = host.getVariables().iterator();
            Vector<LetExp$Class> letExps = new Vector<LetExp$Class>();
            letExps.add(lastLetExp);
            while (i.hasNext()) {
                VariableDeclarationAS varDeclAS = (VariableDeclarationAS)i.next();
                ((Map)data).put("env", env);
                VariableDeclaration semVarDecl = (VariableDeclaration)varDeclAS.accept(this, data);
                if (semVarDecl == null) {
                    ErrorManager.reportError(log, this.symbol, "SA: Problem analysing expression - " + varDeclAS);
                    return null;
                }
                env = env.addVariableDeclaration(varDeclAS.getName(), semVarDecl.getType(), new Boolean(false));
                lastLetExp.setVariable(semVarDecl);
                lastLetExp.setIsMarkedPre(host.getIsMarkedPre());
                if (!i.hasNext()) continue;
                LetExp$Class letExp$Class = new LetExp$Class();
                lastLetExp.setIn(letExp$Class);
                lastLetExp = letExp$Class;
                letExps.add(lastLetExp);
            }
            HashMap<String, Object> newData = new HashMap<String, Object>();
            newData.put("log", log);
            newData.put("env", env);
            OclExpression cfr_ignored_0 = (OclExpression)host.getIn().accept(this, newData);
            lastLetExp.setIn((OclExpression)host.getIn().accept(this, newData));
            Classifier inType = lastLetExp.getIn().getType();
            for (LetExp letExp : letExps) {
                letExp.setType(inType);
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    @Override
    public Object visit(OclMessageExpAS host, Object data) {
        return null;
    }

    @Override
    public Object visit(OclMessageArgAS host, Object data) {
        return null;
    }

    @Override
    public Object visit(CollectionTypeAS host, Object data) {
        try {
            TypeLiteralExp tle = (TypeLiteralExp)host.getElementType().accept(this, data);
            Classifier subType = tle.getLiteralType();
            CollectionType litType = this.processor.getTypeFactory().buildCollectionType(subType);
            TypeType type = this.processor.getTypeFactory().buildTypeType(litType);
            TypeLiteralExp$Class result = new TypeLiteralExp$Class("Set", Boolean.FALSE, litType);
            result.setType(type);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    @Override
    public Object visit(BagTypeAS host, Object data) {
        try {
            TypeLiteralExp tle = (TypeLiteralExp)host.getElementType().accept(this, data);
            Classifier subType = tle.getLiteralType();
            BagType litType = this.processor.getTypeFactory().buildBagType(subType);
            TypeType type = this.processor.getTypeFactory().buildTypeType(litType);
            TypeLiteralExp$Class result = new TypeLiteralExp$Class("Set", Boolean.FALSE, litType);
            result.setType(type);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    @Override
    public Object visit(SetTypeAS host, Object data) {
        try {
            TypeLiteralExp tle = (TypeLiteralExp)host.getElementType().accept(this, data);
            Classifier subType = tle.getLiteralType();
            SetType litType = this.processor.getTypeFactory().buildSetType(subType);
            TypeType type = this.processor.getTypeFactory().buildTypeType(litType);
            TypeLiteralExp$Class result = new TypeLiteralExp$Class("Set", Boolean.FALSE, litType);
            result.setType(type);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    @Override
    public Object visit(OrderedSetTypeAS host, Object data) {
        try {
            TypeLiteralExp tle = (TypeLiteralExp)host.getElementType().accept(this, data);
            Classifier subType = tle.getLiteralType();
            OrderedSetType litType = this.processor.getTypeFactory().buildOrderedSetType(subType);
            TypeType type = this.processor.getTypeFactory().buildTypeType(litType);
            TypeLiteralExp$Class result = new TypeLiteralExp$Class("Set", Boolean.FALSE, litType);
            result.setType(type);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    @Override
    public Object visit(SequenceTypeAS host, Object data) {
        try {
            TypeLiteralExp tle = (TypeLiteralExp)host.getElementType().accept(this, data);
            Classifier subType = tle.getLiteralType();
            SequenceType litType = this.processor.getTypeFactory().buildSequenceType(subType);
            TypeType type = this.processor.getTypeFactory().buildTypeType(litType);
            TypeLiteralExp$Class result = new TypeLiteralExp$Class("Set", Boolean.FALSE, litType);
            result.setType(type);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    @Override
    public Object visit(TupleTypeAS host, Object data) {
        try {
            TupleType litType = this.processor.getTypeFactory().buildTupleType(new String[0], new Classifier[0]);
            for (VariableDeclarationAS varDeclAS : host.getVariableDeclarationList()) {
                VariableDeclaration$Class varDecl = new VariableDeclaration$Class();
                varDecl.setName(varDeclAS.getName());
                TypeLiteralExp tle = (TypeLiteralExp)varDeclAS.getType().accept(this, data);
                Classifier varType = tle.getLiteralType();
                if (varType == null) {
                    varType = this.processor.getTypeFactory().buildOclAnyType();
                }
                varDecl.setType(varType);
                litType.getPartType().add(varDecl);
            }
            TypeType type = this.processor.getTypeFactory().buildTypeType(litType);
            TypeLiteralExp$Class result = new TypeLiteralExp$Class("Tuple", Boolean.FALSE, litType);
            result.setType(type);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    @Override
    public Object visit(ClassifierAS host, Object data) {
        try {
            Environment env = (Environment)((Map)data).get("env");
            ILog log = (ILog)((Map)data).get("log");
            List pathName = host.getPathName();
            ModelElement element = env.lookupPathName(pathName);
            if (element instanceof Classifier && element != null) {
                Classifier litType = (Classifier)element;
                TypeType type = this.processor.getTypeFactory().buildTypeType(litType);
                TypeLiteralExp$Class result = new TypeLiteralExp$Class(litType.toString(), Boolean.FALSE, litType);
                result.setType(type);
                return result;
            }
            String typeStr = "";
            int i = 0;
            while (i < pathName.size()) {
                if (i != 0) {
                    typeStr = String.valueOf(typeStr) + "::";
                }
                typeStr = String.valueOf(typeStr) + pathName.get(i);
                ++i;
            }
            ErrorManager.reportError(log, this.symbol, "SA: Unknown classifier '" + typeStr + "'.");
            return new TypeLiteralExp$Class("VoidType", Boolean.FALSE, this.processor.getTypeFactory().buildVoidType());
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    @Override
    public Object visit(OclMessageKindAS host, Object data) {
        return null;
    }

    public Classifier checkTypes(Classifier t1, Classifier t2) {
        try {
            Classifier type = null;
            if (t1.conformsTo(t2).booleanValue()) {
                type = t2;
            } else if (t2.conformsTo(t1).booleanValue()) {
                type = t1;
            }
            return type;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }
}

