/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.semantics.bridge;

import java.util.List;
import java.util.Vector;
import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.semantics.SemanticsVisitor;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.bridge.Environment;
import org.oslo.ocl20.semantics.bridge.ModelElement;
import org.oslo.ocl20.semantics.bridge.Namespace;
import org.oslo.ocl20.semantics.bridge.Operation;
import org.oslo.ocl20.semantics.bridge.Property;
import org.oslo.ocl20.semantics.bridge.Signal;
import org.oslo.ocl20.semantics.model.types.CollectionType;
import org.oslo.ocl20.semantics.model.types.OclAnyType;
import org.oslo.ocl20.semantics.model.types.TypeFactory;
import org.oslo.ocl20.standard.lib.OclType;

public class ClassifierImpl
implements Classifier {
    protected OclProcessor processor;
    protected List properties = new Vector();
    protected List operations = new Vector();
    protected String name = null;
    Namespace namespace;

    public ClassifierImpl(OclProcessor proc) {
        this.processor = proc;
    }

    @Override
    public List getProperties() {
        return this.properties;
    }

    public void setProperties(List properties) {
        this.properties = properties;
    }

    @Override
    public void addProperty(Property p) {
        this.properties.add(p);
    }

    @Override
    public Property localLookupProperty(String name) {
        for (Property p : this.getProperties()) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    @Override
    public Property lookupProperty(String name) {
        Property pr = this.localLookupProperty(name);
        if (pr != null) {
            return pr;
        }
        for (Classifier c : this.getAllSuperTypes()) {
            Property p = c.localLookupProperty(name);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    @Override
    public List getAllSuperTypes() {
        Vector<Classifier> result = new Vector<Classifier>();
        List x = this.getSuperTypes();
        result.addAll(x);
        for (Classifier c : x) {
            for (Classifier st : c.getAllSuperTypes()) {
                if (result.contains(st)) continue;
                result.add(st);
            }
        }
        return result;
    }

    public List getSuperTypes() {
        return new Vector();
    }

    @Override
    public void createOperations(TypeFactory tf) {
    }

    @Override
    public List getOperations() {
        return this.operations;
    }

    @Override
    public void setOperations(List operations) {
        this.operations = operations;
    }

    @Override
    public void addOperation(Operation op) {
        this.operations.add(op);
    }

    @Override
    public Operation lookupOperation(String name, List types) {
        Operation op = this.lookupCachedOp(name, types);
        return op;
    }

    protected Operation lookupCachedOp(String name, List types) {
        for (Operation op : this.getOperations()) {
            String opName = op.getName();
            if (!opName.equals(name) || !this.typesConform(op.getParameterTypes(), types)) continue;
            return op;
        }
        for (Classifier c : this.getSuperTypes()) {
            Operation p = c.lookupOperation(name, types);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    protected boolean typesConform(List paramTypes, List argTypes) {
        if (paramTypes == null) {
            paramTypes = new Vector();
        }
        if (argTypes == null) {
            argTypes = new Vector();
        }
        if (paramTypes.size() != argTypes.size()) {
            return false;
        }
        int i = 0;
        while (i < paramTypes.size()) {
            Classifier paramType = (Classifier)paramTypes.get(i);
            Classifier argType = (Classifier)argTypes.get(i);
            if (argType == null) {
                return false;
            }
            if (argType.conformsTo(paramType) == Boolean.FALSE) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public Boolean conformsTo(Classifier c) {
        if (this.equals(c)) {
            return Boolean.TRUE;
        }
        if (c.getClass() == OclAnyType.class && !(this instanceof CollectionType)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Signal lookupSignal(String name, List types) {
        return null;
    }

    @Override
    public String getFullName(String sep) {
        if (this.getNamespace() == null) {
            return this.getName();
        }
        return String.valueOf(this.getNamespace().getFullName(sep)) + sep + this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(Namespace namespace) {
        this.namespace = namespace;
    }

    @Override
    public Environment getEnvironmentWithoutParents() {
        Environment env = this.processor.getBridgeFactory().buildEnvironment();
        env.addNamespace(this);
        env.setParent(null);
        return env;
    }

    @Override
    public Environment getEnvironmentWithParents() {
        if (this.getNamespace() == null) {
            return null;
        }
        Environment result = this.getEnvironmentWithoutParents();
        result.setParent(this.getNamespace().getEnvironmentWithParents());
        return result;
    }

    @Override
    public ModelElement lookupOwnedElement(String name) {
        return null;
    }

    @Override
    public Object accept(SemanticsVisitor v, Object obj) {
        return v.visit(this, obj);
    }

    @Override
    public Object clone() {
        return null;
    }

    @Override
    public Object getDelegate() {
        return Class.class;
    }

    @Override
    public Class getImplClass() {
        return OclType.class;
    }
}

