/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.semantics.bridge;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.semantics.SemanticsVisitor;
import org.oslo.ocl20.semantics.bridge.BridgeFactory;
import org.oslo.ocl20.semantics.bridge.BridgeFactoryImpl;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.bridge.Environment;
import org.oslo.ocl20.semantics.bridge.ModelElement;
import org.oslo.ocl20.semantics.bridge.NamedElement;
import org.oslo.ocl20.semantics.bridge.NamedElementImpl;
import org.oslo.ocl20.semantics.bridge.Namespace;
import org.oslo.ocl20.semantics.bridge.Operation;
import org.oslo.ocl20.semantics.bridge.Property;
import org.oslo.ocl20.semantics.model.expressions.VariableDeclaration;
import org.oslo.ocl20.semantics.model.expressions.VariableDeclaration$Class;

public class EnvironmentImpl
implements Environment {
    protected Map namedElements = new HashMap();
    protected Environment parent = null;
    protected List namespaces = new Vector();
    protected BridgeFactory bridgeFactory = null;

    public EnvironmentImpl(BridgeFactory bf) {
        this.bridgeFactory = bf;
    }

    public OclProcessor getProcessor() {
        return ((BridgeFactoryImpl)this.bridgeFactory).getProcessor();
    }

    public Environment getEMPTY_ENV() {
        return new EnvironmentImpl(this.bridgeFactory);
    }

    @Override
    public Set getNamedElements() {
        return new LinkedHashSet(this.namedElements.values());
    }

    @Override
    public void setNamedElements(Set namedElements) {
        this.namedElements = new HashMap();
        for (NamedElement ne : namedElements) {
            this.namedElements.put(ne.getName(), ne);
        }
    }

    @Override
    public Environment getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Environment parent) {
        this.parent = parent;
    }

    @Override
    public NamedElement lookupLocal(String name) {
        NamedElement nel = (NamedElement)this.namedElements.get(name);
        if (nel == null) {
            Iterator i = this.namespaces.iterator();
            while (i.hasNext() && nel == null) {
                Namespace ns = (Namespace)i.next();
                ModelElement me = ns.lookupOwnedElement(name);
                if (me == null || (nel = this.bridgeFactory.buildNamedElement(name, me, Boolean.FALSE)) == null) continue;
                this.namedElements.put(name, nel);
            }
        }
        return nel;
    }

    @Override
    public ModelElement lookup(String name) {
        NamedElement ne = this.lookupLocal(name);
        if (ne != null) {
            return ne.getReferredElement();
        }
        if (this.getParent() != null) {
            return this.getParent().lookup(name);
        }
        return null;
    }

    @Override
    public ModelElement lookupPathName(List names) {
        if (names.size() == 1) {
            return this.lookup((String)names.get(0));
        }
        NamedElement nel = this.lookupLocal((String)names.get(0));
        if (nel != null && nel.getReferredElement() instanceof Namespace) {
            return this.nestedEnvironment().addNamespace((Namespace)nel.getReferredElement()).lookupPathName(names.subList(1, names.size()));
        }
        if (this.getParent() != null) {
            return this.getParent().lookupPathName(names);
        }
        return null;
    }

    @Override
    public Operation lookupPathName(List names, List arguments) {
        if (names.size() == 2) {
            Classifier cl = (Classifier)this.lookup((String)names.get(0));
            String op_name = (String)names.get(1);
            return cl.lookupOperation(op_name, arguments);
        }
        ModelElement firstNamespace = this.lookupLocal((String)names.get(0)).getReferredElement();
        if (firstNamespace instanceof Namespace) {
            return this.nestedEnvironment().addNamespace((Namespace)firstNamespace).lookupPathName(names.subList(1, names.size()), arguments);
        }
        return this.getParent().lookupPathName(names, arguments);
    }

    @Override
    public Environment addElement(String name, ModelElement elem, Boolean imp) {
        if (name == null) {
            return this;
        }
        if (this.namedElements.get(name) != null) {
            return this;
        }
        EnvironmentImpl result = (EnvironmentImpl)this.clone();
        result.namedElements.put(name, new NamedElementImpl(name, elem, imp));
        return result;
    }

    @Override
    public Environment addVariableDeclaration(String name, Classifier type, Boolean imp) {
        if (name == null) {
            return this;
        }
        if (type == null) {
            return this;
        }
        if (this.namedElements.get(name) != null) {
            return this;
        }
        VariableDeclaration$Class vd = new VariableDeclaration$Class(name);
        vd.setType(type);
        EnvironmentImpl result = (EnvironmentImpl)this.clone();
        result.namedElements.put(name, new NamedElementImpl(name, vd, imp));
        return result;
    }

    @Override
    public Environment addEnvironment(Environment env) {
        for (String s : ((EnvironmentImpl)env).namedElements.keySet()) {
            if (!this.namedElements.containsKey(s)) continue;
            throw new RuntimeException("In Environment.addEnvironment: Name already exists in environemnt - " + s);
        }
        EnvironmentImpl result = (EnvironmentImpl)this.clone();
        result.namespaces.addAll(((EnvironmentImpl)env).namespaces);
        result.namedElements.putAll(((EnvironmentImpl)env).namedElements);
        return result;
    }

    @Override
    public Environment addNamespace(Namespace ns) {
        EnvironmentImpl result = (EnvironmentImpl)this.clone();
        result.namespaces.add(ns);
        return result.addElement(ns.getName(), ns, Boolean.FALSE);
    }

    @Override
    public Environment nestedEnvironment() {
        EnvironmentImpl result = new EnvironmentImpl(this.bridgeFactory);
        result.setParent(this);
        return result;
    }

    @Override
    public Property lookupImplicitProperty(String name) {
        NamedElement entry = this.lookupImplicitSourceForProperty(name);
        if (entry != null) {
            ModelElement source = entry.getReferredElement();
            if (source != null && source instanceof VariableDeclaration) {
                source = ((VariableDeclaration)source).getType();
            }
            if (source != null && source instanceof Classifier) {
                Property result = ((Classifier)source).lookupProperty(name);
                return result;
            }
        }
        return null;
    }

    @Override
    public NamedElement lookupImplicitSourceForProperty(String name) {
        NamedElement foundElement = null;
        for (NamedElement entry : this.getNamedElements()) {
            Property foundProperty;
            Classifier type;
            if (entry == null || entry.getMayBeImplicit() == null || !entry.getMayBeImplicit().booleanValue() || (type = entry.getType()) == null || (foundProperty = type.lookupProperty(name)) == null) continue;
            foundElement = entry;
        }
        if (foundElement == null) {
            Environment parent = this.getParent();
            if (parent != null) {
                return parent.lookupImplicitSourceForProperty(name);
            }
            return null;
        }
        return foundElement;
    }

    @Override
    public NamedElement lookupImplicitSourceForOperation(String name, List types) {
        NamedElement foundElement = null;
        for (NamedElement entry : this.getNamedElements()) {
            Operation foundOperation;
            if (!entry.getMayBeImplicit().booleanValue() || (foundOperation = entry.getType().lookupOperation(name, types)) == null) continue;
            foundElement = entry;
        }
        if (foundElement == null) {
            Environment parent = this.getParent();
            if (parent != null) {
                return parent.lookupImplicitSourceForOperation(name, types);
            }
            return null;
        }
        return foundElement;
    }

    @Override
    public Operation lookupImplicitOperation(String name, List params) {
        NamedElement ne = this.lookupImplicitSourceForOperation(name, params);
        if (ne == null) {
            this.bridgeFactory.buildClassifier(this);
        } else {
            ModelElement source = ne.getReferredElement();
            if (source instanceof VariableDeclaration) {
                source = ((VariableDeclaration)source).getType();
            }
            if (source instanceof Classifier) {
                Operation result = ((Classifier)source).lookupOperation(name, params);
                return result;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        String s = "Environment {\n";
        s = String.valueOf(s) + " namedElements : \n";
        Iterator i = this.namedElements.entrySet().iterator();
        while (i.hasNext()) {
            s = String.valueOf(s) + "  " + i.next() + "\n";
        }
        s = String.valueOf(s) + " namespaces : \n";
        i = this.namespaces.iterator();
        while (i.hasNext()) {
            s = String.valueOf(s) + "  " + i.next() + "\n";
        }
        s = String.valueOf(s) + "  parent : " + this.parent + "\n";
        s = String.valueOf(s) + "}";
        return s;
    }

    @Override
    public Object clone() {
        EnvironmentImpl copy = new EnvironmentImpl(this.bridgeFactory);
        copy.namedElements = new HashMap(this.namedElements);
        copy.namespaces = new Vector(this.namespaces);
        copy.parent = this.parent;
        return copy;
    }

    @Override
    public Object accept(SemanticsVisitor v, Object obj) {
        return v.visit(this, obj);
    }
}

