/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.standard.lib;

import java.util.Arrays;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.standard.lib.OclAny;
import org.oslo.ocl20.standard.lib.OclBoolean;
import org.oslo.ocl20.standard.lib.OclType;
import org.oslo.ocl20.standard.lib.StdLibAdapter;

public abstract class OclAnyImpl
implements OclAny {
    StdLibAdapter adapter;

    protected OclAnyImpl(StdLibAdapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public OclBoolean equalTo(OclAny object2) {
        return this.adapter.Boolean(this.equals(object2));
    }

    @Override
    public OclBoolean notEqualTo(OclAny object2) {
        return this.equalTo(object2).not();
    }

    public OclBoolean oclIsNew() {
        return this.adapter.Boolean(false);
    }

    @Override
    public OclAny oclAsType(OclType type) {
        return this;
    }

    @Override
    public OclBoolean oclIsTypeOf(OclType type) {
        Class c1 = (Class)((Classifier)type.asJavaObject()).getDelegate();
        Class<?> c2 = this.asJavaObject().getClass();
        boolean b1 = false;
        boolean b2 = false;
        if (c1.isInterface()) {
            b1 = Arrays.asList(c2.getInterfaces()).contains(c1);
            b2 = c1.isAssignableFrom(c2);
        } else {
            b1 = c1.isAssignableFrom(c2);
            b2 = c2.isAssignableFrom(c1);
        }
        return this.adapter.Boolean(b1 && b2);
    }

    @Override
    public OclBoolean oclIsKindOf(OclType type) {
        Classifier cls = (Classifier)type.asJavaObject();
        boolean b = ((Class)cls.getDelegate()).isAssignableFrom(this.asJavaObject().getClass());
        return this.adapter.Boolean(b);
    }

    public OclBoolean oclIsInState(Object state) {
        return this.adapter.Boolean(false);
    }

    @Override
    public OclBoolean oclIsUndefined() {
        return this.adapter.Boolean(false);
    }

    String toString(Class[] x) {
        String str = "(";
        int i = 0;
        while (i < x.length) {
            str = String.valueOf(str) + x[i].getName();
            if (i + 1 < x.length) {
                str = String.valueOf(str) + "' ";
            }
            ++i;
        }
        str = String.valueOf(str) + ")";
        return str;
    }

    @Override
    public abstract Object clone();

    public abstract boolean equals(Object var1);

    public int hashCode() {
        return 0;
    }
}

