/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.standard.lib;

import org.oslo.ocl20.semantics.model.types.BooleanType;
import org.oslo.ocl20.standard.lib.OclAnyImpl;
import org.oslo.ocl20.standard.lib.OclBoolean;
import org.oslo.ocl20.standard.lib.OclType;
import org.oslo.ocl20.standard.lib.OclUndefined;
import org.oslo.ocl20.standard.lib.OclVisitor;
import org.oslo.ocl20.standard.lib.StdLibAdapter;

public class OclBooleanImpl
extends OclAnyImpl
implements OclBoolean {
    static OclBoolean TRUE;
    static OclBoolean FALSE;

    protected OclBooleanImpl(StdLibAdapter adapter) {
        super(adapter);
    }

    @Override
    public OclType oclType() {
        BooleanType type = this.adapter.getProcessor().getTypeFactory().buildBooleanType();
        return this.adapter.Type(type);
    }

    @Override
    public Object asJavaObject() {
        if (this == TRUE) {
            return Boolean.TRUE;
        }
        if (this == FALSE) {
            return Boolean.FALSE;
        }
        return null;
    }

    public OclBoolean equalTo(OclBoolean b2) {
        if (b2 instanceof OclUndefined) {
            return b2;
        }
        return this.adapter.Boolean(this.equals(b2));
    }

    @Override
    public OclBoolean or(OclBoolean b2) {
        if (this == TRUE) {
            return TRUE;
        }
        if (b2 == TRUE) {
            return TRUE;
        }
        if (this == FALSE && b2 == FALSE) {
            return FALSE;
        }
        if (b2 instanceof OclUndefined) {
            return b2;
        }
        return this.adapter.Undefined();
    }

    @Override
    public OclBoolean xor(OclBoolean b2) {
        if (b2 instanceof OclUndefined) {
            return b2;
        }
        if (this == b2) {
            return FALSE;
        }
        return TRUE;
    }

    @Override
    public OclBoolean and(OclBoolean b2) {
        if (this == FALSE) {
            return FALSE;
        }
        if (b2 == FALSE) {
            return FALSE;
        }
        if (this == TRUE && b2 == TRUE) {
            return TRUE;
        }
        if (b2 instanceof OclUndefined) {
            return b2;
        }
        return this.adapter.Undefined();
    }

    @Override
    public OclBoolean not() {
        if (this == TRUE) {
            return FALSE;
        }
        if (this == FALSE) {
            return TRUE;
        }
        return this.adapter.Undefined();
    }

    @Override
    public OclBoolean implies(OclBoolean b2) {
        if (this == FALSE) {
            return TRUE;
        }
        if (b2 == TRUE) {
            return TRUE;
        }
        if (this == TRUE) {
            return b2;
        }
        return this.adapter.Undefined();
    }

    public Object accept(OclVisitor v, Object obj) {
        return v.visit(this, obj);
    }

    public String toString() {
        if (this == TRUE) {
            return "true";
        }
        if (this == FALSE) {
            return "false";
        }
        return this.adapter.Undefined().toString();
    }

    @Override
    public boolean equals(Object b) {
        if (!(b instanceof OclBoolean)) {
            return false;
        }
        if (b instanceof OclUndefined) {
            return (Boolean)((OclBoolean)b).asJavaObject();
        }
        return (Boolean)this.asJavaObject() == (Boolean)((OclBoolean)b).asJavaObject();
    }

    @Override
    public int hashCode() {
        return this == FALSE ? 0 : 1;
    }

    @Override
    public Object clone() {
        return this;
    }
}

