/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.standard.lib;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.model.types.CollectionType;
import org.oslo.ocl20.semantics.model.types.TupleType;
import org.oslo.ocl20.standard.lib.OclAny;
import org.oslo.ocl20.standard.lib.OclAnyImpl;
import org.oslo.ocl20.standard.lib.OclBag;
import org.oslo.ocl20.standard.lib.OclBoolean;
import org.oslo.ocl20.standard.lib.OclCollection;
import org.oslo.ocl20.standard.lib.OclInteger;
import org.oslo.ocl20.standard.lib.OclOrderedSet;
import org.oslo.ocl20.standard.lib.OclSequence;
import org.oslo.ocl20.standard.lib.OclSet;
import org.oslo.ocl20.standard.lib.OclTuple;
import org.oslo.ocl20.standard.lib.StdLibAdapter;

public abstract class OclCollectionImpl
extends OclAnyImpl
implements OclCollection {
    Classifier _elementType;

    protected OclCollectionImpl(Classifier eT, StdLibAdapter adapter) {
        super(adapter);
        this._elementType = eT;
    }

    public Classifier getElementType() {
        return this._elementType;
    }

    public Classifier getBaseElementType() {
        Classifier x = this.getElementType();
        if (x instanceof CollectionType) {
            return ((CollectionType)x).getBaseElementType();
        }
        return x;
    }

    abstract Collection implementation();

    @Override
    public Object getImplementation() {
        return this.implementation();
    }

    @Override
    public OclInteger size() {
        int size = this.implementation().size();
        return this.adapter.Integer(size);
    }

    @Override
    public OclBoolean includes(Object object) {
        Iterator i = this.implementation().iterator();
        boolean found = false;
        while (i.hasNext()) {
            if (!object.equals(i.next())) continue;
            found = true;
            break;
        }
        return this.adapter.Boolean(found);
    }

    @Override
    public OclBoolean excludes(Object object) {
        return this.includes(object).not();
    }

    @Override
    public OclInteger count(OclAny object) {
        int count = 0;
        Iterator i = this.implementation().iterator();
        while (i.hasNext()) {
            if (!object.equals(i.next())) continue;
            ++count;
        }
        return this.adapter.Integer(count);
    }

    @Override
    public OclBoolean includesAll(OclCollection col) {
        for (OclAny o : (Collection)col.getImplementation()) {
            if (((Boolean)this.includes(o).asJavaObject()).booleanValue()) continue;
            return this.adapter.Boolean(false);
        }
        return this.adapter.Boolean(true);
    }

    @Override
    public OclBoolean excludesAll(OclCollection col) {
        for (OclAny o : (Collection)col.getImplementation()) {
            if (!((Boolean)this.includes(o).asJavaObject()).booleanValue()) continue;
            return this.adapter.Boolean(false);
        }
        return this.adapter.Boolean(true);
    }

    @Override
    public OclBoolean isEmpty() {
        return this.adapter.Boolean(this.implementation().isEmpty());
    }

    @Override
    public OclBoolean notEmpty() {
        return this.isEmpty().not();
    }

    @Override
    public Object sum() {
        if (this.implementation().isEmpty()) {
            return this.adapter.Integer(0);
        }
        Iterator i = this.implementation().iterator();
        Object first = i.next();
        Method addMethod = this.getAddMethod(first);
        if (addMethod != null) {
            Object acc = null;
            try {
                Method m = first.getClass().getMethod("clone", new Class[0]);
                acc = m.invoke(first, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (acc != null) {
                try {
                    while (i.hasNext()) {
                        OclAny next = (OclAny)i.next();
                        acc = addMethod.invoke(acc, next);
                    }
                    return acc;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.adapter.Undefined();
    }

    private Method getAddMethod(Object o) {
        Method[] meths = o.getClass().getMethods();
        int i = 0;
        while (i < meths.length) {
            Class<?> x;
            if (meths[i].getName().equals("add") && meths[i].getParameterTypes().length == 1 && (x = meths[i].getParameterTypes()[0]).isAssignableFrom(o.getClass())) {
                return meths[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public OclSet product(OclCollection col2) {
        Iterator i1 = this.implementation().iterator();
        Collection c2 = (Collection)col2.getImplementation();
        LinkedHashSet<OclTuple> result = new LinkedHashSet<OclTuple>();
        while (i1.hasNext()) {
            OclAny o1 = (OclAny)i1.next();
            for (OclAny o2 : c2) {
                String[] names = new String[]{"first", "second"};
                Classifier[] types = new Classifier[]{this.getElementType(), this.getElementType()};
                TupleType eT = this.adapter.getProcessor().getTypeFactory().buildTupleType(names, types);
                result.add(this.adapter.Tuple(eT, new OclAny[]{o1, o2}));
            }
        }
        return this.adapter.Set(this.getElementType(), result);
    }

    @Override
    public OclSequence asSequence() {
        return this.adapter.Sequence(this.getElementType(), this.implementation());
    }

    @Override
    public OclSet asSet() {
        return this.adapter.Set(this.getElementType(), this.implementation());
    }

    @Override
    public OclBag asBag() {
        return this.adapter.Bag(this.getElementType(), this.implementation());
    }

    @Override
    public OclOrderedSet asOrderedSet() {
        return this.adapter.OrderedSet(this.getElementType(), this.implementation());
    }

    @Override
    public abstract Object clone();
}

