/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.standard.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.model.types.OrderedSetType;
import org.oslo.ocl20.standard.lib.OclAny;
import org.oslo.ocl20.standard.lib.OclBag;
import org.oslo.ocl20.standard.lib.OclBagImpl;
import org.oslo.ocl20.standard.lib.OclBoolean;
import org.oslo.ocl20.standard.lib.OclCollection;
import org.oslo.ocl20.standard.lib.OclCollectionImpl;
import org.oslo.ocl20.standard.lib.OclInteger;
import org.oslo.ocl20.standard.lib.OclOrderedSet;
import org.oslo.ocl20.standard.lib.OclSequence;
import org.oslo.ocl20.standard.lib.OclSet;
import org.oslo.ocl20.standard.lib.OclType;
import org.oslo.ocl20.standard.lib.OclUndefined;
import org.oslo.ocl20.standard.lib.StdLibAdapter;

public class OclOrderedSetImpl
extends OclCollectionImpl
implements OclOrderedSet {
    List _implementation = new Vector();

    protected OclOrderedSetImpl(Classifier eT, Object[] array, StdLibAdapter adapter) {
        super(eT, adapter);
        int i = 0;
        while (i < array.length) {
            if (array[i] != null && !((Boolean)this.includes(array[i]).asJavaObject()).booleanValue()) {
                this._implementation.add(array[i]);
            }
            ++i;
        }
    }

    @Override
    public OclType oclType() {
        OrderedSetType type = this.adapter.getProcessor().getTypeFactory().buildOrderedSetType(super.getElementType());
        return this.adapter.Type(type);
    }

    @Override
    protected Collection implementation() {
        return this._implementation;
    }

    protected List orderedset_impl() {
        return this._implementation;
    }

    @Override
    public OclBoolean equalTo(OclOrderedSet set2) {
        if (((Boolean)this.size().notEqualTo(set2.size()).asJavaObject()).booleanValue()) {
            return this.adapter.Boolean(false);
        }
        Collection b = this.implementation();
        b.iterator();
        List t = this.orderedset_impl();
        List s = (List)set2.getImplementation();
        int i = 0;
        while (i < t.size()) {
            if (!t.get(i).equals(s.get(i))) {
                return this.adapter.Boolean(false);
            }
            ++i;
        }
        return this.adapter.Boolean(true);
    }

    @Override
    public OclBoolean notEqualTo(OclOrderedSet set2) {
        return this.equalTo(set2).not();
    }

    @Override
    public OclBoolean equalTo(OclSet set2) {
        return this.asSet().equalTo(set2);
    }

    @Override
    public OclBoolean notEqualTo(OclSet set2) {
        if (set2 instanceof OclOrderedSet) {
            return this.notEqualTo((OclOrderedSet)set2);
        }
        return this.adapter.Boolean(true);
    }

    @Override
    public OclSet union(OclOrderedSet set2) {
        OclOrderedSet s = this.union(set2.asBag()).asOrderedSet();
        return s;
    }

    @Override
    public OclSet union(OclSet set2) {
        OclSet s = this.union(set2.asBag()).asSet();
        return s;
    }

    @Override
    public OclBag union(OclBag bag) {
        OclBagImpl b = (OclBagImpl)this.adapter.Bag(this.getElementType(), this.orderedset_impl());
        b.implementation().addAll(((OclBagImpl)bag).implementation());
        return b;
    }

    @Override
    public OclSet intersection(OclSet set2) {
        OclSet s = this.adapter.Set(this.getElementType());
        List s1 = (List)this.asJavaObject();
        Set s2 = (Set)set2.asJavaObject();
        for (OclAny o : s1) {
            if (!((Boolean)set2.includes(o).asJavaObject()).booleanValue()) continue;
            s = s.including(o);
        }
        for (OclAny o : s2) {
            if (!((Boolean)this.includes(o).asJavaObject()).booleanValue()) continue;
            s = s.including(o);
        }
        return s;
    }

    @Override
    public OclSet intersection(OclBag bag) {
        return this.intersection(bag.asSet());
    }

    @Override
    public OclSet intersection(OclOrderedSet set2) {
        return this.intersection(set2.asSet()).asOrderedSet();
    }

    @Override
    public OclSet subtract(OclSet set2) {
        OclSet s = this.adapter.Set(this.getElementType());
        List set = (List)this.asJavaObject();
        Set s2 = (Set)set2.asJavaObject();
        for (OclAny o : set) {
            if (s2.contains(o)) continue;
            s = s.including(o);
        }
        return s;
    }

    @Override
    public OclSet symmetricDifference(OclSet set2) {
        OclSet s = this.adapter.Set(this.getElementType());
        List s1 = (List)this.asJavaObject();
        Set s2 = (Set)set2.asJavaObject();
        for (OclAny o : s1) {
            if (s2.contains(o)) continue;
            s = s.including(o);
        }
        for (OclAny o : s2) {
            if (s1.contains(o)) continue;
            s = s.including(o);
        }
        return s;
    }

    @Override
    public OclOrderedSet append(OclAny object) {
        OclOrderedSetImpl seq = (OclOrderedSetImpl)this.clone();
        if (object instanceof OclUndefined) {
            return seq;
        }
        if (!((Boolean)this.includes(object).asJavaObject()).booleanValue()) {
            seq._implementation.add(object);
        }
        return seq;
    }

    @Override
    public OclOrderedSet prepend(OclAny object) {
        OclOrderedSetImpl seq = (OclOrderedSetImpl)this.clone();
        if (object instanceof OclUndefined) {
            return seq;
        }
        if (!((Boolean)this.includes(object).asJavaObject()).booleanValue()) {
            seq._implementation.add(0, object);
        }
        return seq;
    }

    @Override
    public OclSet including(OclAny object) {
        return this.append(object);
    }

    @Override
    public OclSet excluding(OclAny object) {
        OclOrderedSetImpl seq = (OclOrderedSetImpl)this.clone();
        ArrayList<OclAny> col = new ArrayList<OclAny>();
        col.add(object);
        seq._implementation.removeAll(col);
        return seq;
    }

    @Override
    public OclOrderedSet insertAt(OclInteger index, OclAny object) {
        OclOrderedSetImpl seq = (OclOrderedSetImpl)this.clone();
        if (object instanceof OclUndefined) {
            return seq;
        }
        int i = (Integer)index.asJavaObject();
        if (!((Boolean)this.includes(object).asJavaObject()).booleanValue()) {
            seq._implementation.add(i, object);
        }
        return seq;
    }

    @Override
    public OclOrderedSet subOrderedSet(OclInteger lower, OclInteger upper) {
        if ((Integer)lower.asJavaObject() < 1) {
            return null;
        }
        if ((Integer)upper.asJavaObject() > (Integer)this.size().asJavaObject()) {
            return null;
        }
        int l = (Integer)lower.asJavaObject() - 1;
        int u = (Integer)upper.asJavaObject() - 1 + 1;
        return this.adapter.OrderedSet(this.getElementType(), this.orderedset_impl().subList(l, u));
    }

    @Override
    public OclAny at(OclInteger i) {
        return (OclAny)this.orderedset_impl().get((Integer)i.asJavaObject() - 1);
    }

    public OclInteger indexOf(OclAny object) {
        Iterator i = this._implementation.iterator();
        int j = 1;
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj.equals(object)) {
                return this.adapter.Integer(j);
            }
            ++j;
        }
        return this.adapter.Integer(0);
    }

    @Override
    public OclAny first() {
        if (this.orderedset_impl().size() < 1) {
            return this.adapter.Undefined();
        }
        return (OclAny)this.orderedset_impl().get(0);
    }

    @Override
    public OclAny last() {
        if (this.orderedset_impl().size() < 1) {
            return this.adapter.Undefined();
        }
        return (OclAny)this.orderedset_impl().get(this.orderedset_impl().size() - 1);
    }

    @Override
    public OclSet flatten() {
        OclOrderedSet flat = (OclOrderedSet)this.clone();
        ((Collection)flat.getImplementation()).clear();
        for (Object elem : this._implementation) {
            if (elem instanceof OclCollection) {
                Iterator j = null;
                if (elem instanceof OclBag) {
                    j = ((Collection)((OclBag)elem).flatten().getImplementation()).iterator();
                } else if (elem instanceof OclOrderedSet) {
                    j = ((Collection)((OclOrderedSet)elem).flatten().getImplementation()).iterator();
                } else if (elem instanceof OclSet) {
                    j = ((Collection)((OclSet)elem).flatten().getImplementation()).iterator();
                } else if (elem instanceof OclSequence) {
                    j = ((Collection)((OclSequence)elem).flatten().getImplementation()).iterator();
                }
                while (j.hasNext()) {
                    OclAny x = (OclAny)j.next();
                    if (x == null || !((Boolean)flat.excludes(x).asJavaObject()).booleanValue()) continue;
                    flat = (OclOrderedSet)flat.including(x);
                }
                continue;
            }
            ((Collection)flat.getImplementation()).add(elem);
        }
        return flat;
    }

    public String toString() {
        String str = "OrderedSet { ";
        Iterator i = this._implementation.iterator();
        while (i.hasNext()) {
            str = String.valueOf(str) + i.next();
            if (!i.hasNext()) continue;
            str = String.valueOf(str) + ", ";
        }
        return String.valueOf(str) + " }";
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof OclSet ? (Boolean)this.equalTo((OclOrderedSet)o).asJavaObject() : false;
    }

    @Override
    public Object clone() {
        return this.adapter.OrderedSet(this.getElementType(), this._implementation);
    }

    @Override
    public Object asJavaObject() {
        Vector jObj = new Vector();
        for (Object o : this._implementation) {
            if (o instanceof OclAny) {
                o = ((OclAny)o).asJavaObject();
            }
            jObj.add(o);
        }
        return Collections.unmodifiableList(jObj);
    }
}

