/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.standard.lib;

import org.oslo.ocl20.semantics.model.types.RealType;
import org.oslo.ocl20.standard.lib.OclAnyImpl;
import org.oslo.ocl20.standard.lib.OclBoolean;
import org.oslo.ocl20.standard.lib.OclInteger;
import org.oslo.ocl20.standard.lib.OclReal;
import org.oslo.ocl20.standard.lib.OclType;
import org.oslo.ocl20.standard.lib.OclUndefined;
import org.oslo.ocl20.standard.lib.OclVisitor;
import org.oslo.ocl20.standard.lib.StdLibAdapter;

public class OclRealImpl
extends OclAnyImpl
implements OclReal {
    double _implementation;

    protected OclRealImpl(double r, StdLibAdapter adapter) {
        super(adapter);
        this._implementation = r;
    }

    @Override
    public OclType oclType() {
        RealType type = this.adapter.getProcessor().getTypeFactory().buildRealType();
        return this.adapter.Type(type);
    }

    public double implementation() {
        return this._implementation;
    }

    public OclBoolean equalTo(OclReal r2) {
        return this.adapter.Boolean(this.implementation() == ((OclRealImpl)r2).implementation());
    }

    public OclBoolean notEqualTo(OclReal r2) {
        return this.adapter.Boolean(this.implementation() != ((OclRealImpl)r2).implementation());
    }

    @Override
    public Object asJavaObject() {
        return new Double(this.implementation());
    }

    @Override
    public OclReal add(OclReal r2) {
        if (!(r2 instanceof OclUndefined)) {
            return this.adapter.Real(this.implementation() + ((OclRealImpl)r2).implementation());
        }
        return null;
    }

    @Override
    public OclReal subtract(OclReal r2) {
        if (!(r2 instanceof OclUndefined)) {
            return this.adapter.Real(this.implementation() - ((OclRealImpl)r2).implementation());
        }
        return null;
    }

    @Override
    public OclReal multiply(OclReal r2) {
        return this.adapter.Real(this.implementation() * ((OclRealImpl)r2).implementation());
    }

    @Override
    public OclReal negate() {
        return this.adapter.Real(this.implementation() * -1.0);
    }

    @Override
    public OclReal divide(OclReal r2) {
        if (((Number)r2.asJavaObject()).doubleValue() == 0.0) {
            return this.adapter.Undefined();
        }
        return this.adapter.Real(this.implementation() / ((OclRealImpl)r2).implementation());
    }

    @Override
    public OclReal abs() {
        return this.adapter.Real(Math.abs(this.implementation()));
    }

    @Override
    public OclInteger floor() {
        return this.adapter.Integer((int)Math.floor(this.implementation()));
    }

    @Override
    public OclInteger round() {
        return this.adapter.Integer((int)Math.round(this.implementation()));
    }

    @Override
    public OclReal max(OclReal r2) {
        return this.adapter.Real(Math.max(this.implementation(), ((OclRealImpl)r2).implementation()));
    }

    @Override
    public OclReal min(OclReal r2) {
        return this.adapter.Real(Math.min(this.implementation(), ((OclRealImpl)r2).implementation()));
    }

    @Override
    public OclBoolean lessThan(OclReal r2) {
        return this.adapter.Boolean(this.implementation() < ((OclRealImpl)r2).implementation());
    }

    @Override
    public OclBoolean greaterThan(OclReal r2) {
        return this.adapter.Boolean(this.implementation() > ((OclRealImpl)r2).implementation());
    }

    @Override
    public OclBoolean lessThanOrEqualTo(OclReal r2) {
        return this.adapter.Boolean(this.implementation() <= ((OclRealImpl)r2).implementation());
    }

    @Override
    public OclBoolean greaterThanOrEqualTo(OclReal r2) {
        return this.adapter.Boolean(this.implementation() >= ((OclRealImpl)r2).implementation());
    }

    public Object accept(OclVisitor v, Object obj) {
        return v.visit(this, obj);
    }

    public String toString() {
        return String.valueOf(this.implementation());
    }

    @Override
    public boolean equals(Object r) {
        if (r instanceof OclRealImpl) {
            return (Boolean)this.equalTo((OclRealImpl)r).asJavaObject();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (int)this.implementation();
    }

    @Override
    public Object clone() {
        return new OclRealImpl(this.implementation(), this.adapter);
    }
}

