/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.standard.lib;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.model.types.SetType;
import org.oslo.ocl20.standard.lib.OclAny;
import org.oslo.ocl20.standard.lib.OclBag;
import org.oslo.ocl20.standard.lib.OclBagImpl;
import org.oslo.ocl20.standard.lib.OclBoolean;
import org.oslo.ocl20.standard.lib.OclCollectionImpl;
import org.oslo.ocl20.standard.lib.OclInteger;
import org.oslo.ocl20.standard.lib.OclOrderedSet;
import org.oslo.ocl20.standard.lib.OclSequence;
import org.oslo.ocl20.standard.lib.OclSet;
import org.oslo.ocl20.standard.lib.OclType;
import org.oslo.ocl20.standard.lib.OclUndefined;
import org.oslo.ocl20.standard.lib.OclVisitor;
import org.oslo.ocl20.standard.lib.StdLibAdapter;

public class OclSetImpl
extends OclCollectionImpl
implements OclSet {
    Set _implementation = new LinkedHashSet();

    protected OclSetImpl(Classifier eT, Object[] array, StdLibAdapter adapter) {
        super(eT, adapter);
        int i = 0;
        while (i < array.length) {
            if (array[i] != null && !((Boolean)this.includes(array[i]).asJavaObject()).booleanValue()) {
                this._implementation.add(array[i]);
            }
            ++i;
        }
    }

    @Override
    public OclType oclType() {
        SetType type = this.adapter.getProcessor().getTypeFactory().buildSetType(super.getElementType());
        return this.adapter.Type(type);
    }

    @Override
    protected Collection implementation() {
        return this._implementation;
    }

    protected Set set_impl() {
        return this._implementation;
    }

    @Override
    public OclBoolean equalTo(OclSet set2) {
        if (!this.size().equals(set2.size())) {
            return this.adapter.Boolean(false);
        }
        Collection b = this.implementation();
        for (OclAny ob : b) {
            if (((Boolean)this.count(ob).equalTo(set2.count(ob)).asJavaObject()).booleanValue()) continue;
            return this.adapter.Boolean(false);
        }
        return this.adapter.Boolean(true);
    }

    @Override
    public OclBoolean notEqualTo(OclSet set2) {
        return this.equalTo(set2).not();
    }

    @Override
    public OclSet union(OclSet set2) {
        OclSet s = this.union(set2.asBag()).asSet();
        return s;
    }

    @Override
    public OclBag union(OclBag bag) {
        OclBagImpl b = (OclBagImpl)this.adapter.Bag(this.getElementType(), this.set_impl());
        b.implementation().addAll(((OclBagImpl)bag).implementation());
        return b;
    }

    @Override
    public OclSet union(OclOrderedSet set2) {
        OclSet s = this.union(set2.asBag()).asSet();
        return s;
    }

    @Override
    public OclSet intersection(OclSet set2) {
        OclSet s = this.adapter.Set(this.getElementType());
        Set s1 = (Set)this.getImplementation();
        Set s2 = (Set)set2.getImplementation();
        for (OclAny o : s1) {
            if (!((Boolean)set2.includes(o).asJavaObject()).booleanValue()) continue;
            s = s.including(o);
        }
        for (OclAny o : s2) {
            if (!((Boolean)this.includes(o).asJavaObject()).booleanValue()) continue;
            s = s.including(o);
        }
        return s;
    }

    @Override
    public OclSet intersection(OclBag bag) {
        return this.intersection(bag.asSet());
    }

    @Override
    public OclSet intersection(OclOrderedSet set2) {
        return this.intersection(set2.asSet());
    }

    @Override
    public OclSet subtract(OclSet set2) {
        OclSet s = this.adapter.Set(this.getElementType());
        Set s1 = (Set)this.getImplementation();
        Set s2 = (Set)set2.getImplementation();
        for (OclAny o : s1) {
            if (s2.contains(o)) continue;
            s = s.including(o);
        }
        return s;
    }

    @Override
    public OclSet including(OclAny object) {
        OclSetImpl s = (OclSetImpl)this.adapter.Set(this.getElementType(), this.set_impl());
        if (object instanceof OclUndefined) {
            return s;
        }
        if (!((Boolean)this.includes(object).asJavaObject()).booleanValue()) {
            s.set_impl().add(object);
        }
        return s;
    }

    @Override
    public OclSet excluding(OclAny object) {
        OclSetImpl s = (OclSetImpl)this.adapter.Set(this.getElementType(), this.set_impl());
        s.set_impl().remove(object);
        return s;
    }

    @Override
    public OclSet symmetricDifference(OclSet set2) {
        OclSet s = this.adapter.Set(this.getElementType());
        Set s1 = (Set)this.getImplementation();
        Set s2 = (Set)set2.getImplementation();
        for (OclAny o : s1) {
            if (s2.contains(o)) continue;
            s = s.including(o);
        }
        for (OclAny o : s2) {
            if (s1.contains(o)) continue;
            s = s.including(o);
        }
        return s;
    }

    @Override
    public OclInteger count(OclAny object) {
        return super.count(object);
    }

    @Override
    public OclSet flatten() {
        OclSet flat = (OclSetImpl)this.adapter.Set(this.getElementType());
        for (OclAny elem : this._implementation) {
            flat = elem instanceof OclBag ? flat.union((OclBag)elem).asSet() : (elem instanceof OclSet ? flat.union((OclSet)elem).asSet() : (elem instanceof OclSequence ? flat.union(((OclSequence)elem).asSet()).asSet() : flat.including(elem)));
        }
        return flat;
    }

    public String toString() {
        String str = "Set { ";
        Iterator i = this._implementation.iterator();
        while (i.hasNext()) {
            str = String.valueOf(str) + i.next();
            if (!i.hasNext()) continue;
            str = String.valueOf(str) + ", ";
        }
        return String.valueOf(str) + " }";
    }

    @Override
    public Object clone() {
        return this.adapter.Set(this.getElementType(), this.set_impl());
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof OclSet ? (Boolean)this.equalTo((OclSet)o).asJavaObject() : false;
    }

    public Object accept(OclVisitor v, Object obj) {
        return v.visit(this, obj);
    }

    @Override
    public Object asJavaObject() {
        LinkedHashSet jObj = new LinkedHashSet();
        for (Object o : this._implementation) {
            if (o instanceof OclAny) {
                o = ((OclAny)o).asJavaObject();
            }
            jObj.add(o);
        }
        return Collections.unmodifiableSet(jObj);
    }
}

