/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.standard.lib;

import org.oslo.ocl20.semantics.model.types.StringType;
import org.oslo.ocl20.standard.lib.OclAnyImpl;
import org.oslo.ocl20.standard.lib.OclBoolean;
import org.oslo.ocl20.standard.lib.OclInteger;
import org.oslo.ocl20.standard.lib.OclReal;
import org.oslo.ocl20.standard.lib.OclString;
import org.oslo.ocl20.standard.lib.OclType;
import org.oslo.ocl20.standard.lib.OclVisitor;
import org.oslo.ocl20.standard.lib.StdLibAdapter;

public class OclStringImpl
extends OclAnyImpl
implements OclString {
    String _implementation;

    public OclStringImpl(String s, StdLibAdapter adapter) {
        super(adapter);
        this._implementation = s;
    }

    @Override
    public OclType oclType() {
        StringType type = this.adapter.getProcessor().getTypeFactory().buildStringType();
        return this.adapter.Type(type);
    }

    public String implementation() {
        return this._implementation;
    }

    @Override
    public Object asJavaObject() {
        return this.implementation();
    }

    public OclBoolean equalTo(OclString string2) {
        return this.adapter.Boolean(this.implementation().equals(((OclStringImpl)string2).implementation()));
    }

    @Override
    public OclInteger size() {
        return this.adapter.Integer(this.implementation().length());
    }

    @Override
    public OclString concat(OclString string2) {
        return this.adapter.String(String.valueOf(this.implementation()) + ((OclStringImpl)string2).implementation());
    }

    @Override
    public OclString substring(OclInteger lower, OclInteger upper) {
        return this.adapter.String(this.implementation().substring((Integer)lower.asJavaObject() - 1, (Integer)upper.asJavaObject() - 1 + 1));
    }

    @Override
    public OclInteger toInteger() {
        return this.adapter.Integer(Integer.parseInt(this.implementation()));
    }

    @Override
    public OclReal toReal() {
        return this.adapter.Real(Double.parseDouble(this.implementation()));
    }

    public Object accept(OclVisitor v, Object obj) {
        return v.visit(this, obj);
    }

    public String toString() {
        return "'" + this._implementation + "'";
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof OclString ? (Boolean)this.equalTo((OclString)o).asJavaObject() : false;
    }

    @Override
    public int hashCode() {
        return this.implementation().hashCode();
    }

    @Override
    public Object clone() {
        return this.adapter.String(this._implementation);
    }
}

