/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.standard.lib;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.model.types.TupleType;
import org.oslo.ocl20.standard.lib.OclAny;
import org.oslo.ocl20.standard.lib.OclAnyImpl;
import org.oslo.ocl20.standard.lib.OclString;
import org.oslo.ocl20.standard.lib.OclTuple;
import org.oslo.ocl20.standard.lib.OclType;
import org.oslo.ocl20.standard.lib.OclVisitor;
import org.oslo.ocl20.standard.lib.StdLibAdapter;

public class OclTupleImpl
extends OclAnyImpl
implements OclTuple {
    private Map _implementation;
    Map _elementTypes;
    String[] _keys;
    Classifier[] _types;
    TupleType type;

    protected Map implementation() {
        return this._implementation;
    }

    protected OclTupleImpl(Map m, StdLibAdapter adapter) {
        super(adapter);
        this._implementation = m;
        this._keys = m.keySet().toArray(new String[0]);
        Vector<Classifier> types = new Vector<Classifier>();
        for (Object o : m.values()) {
            OclAny oa = adapter.OclAny(o);
            Classifier c = (Classifier)oa.oclType().asJavaObject();
            types.add(c);
        }
        this._types = types.toArray(new Classifier[0]);
        this.type = adapter.getProcessor().getTypeFactory().buildTupleType(this._keys, this._types);
    }

    protected OclTupleImpl(TupleType tT, OclAny[] arr, StdLibAdapter adapter) {
        super(adapter);
        this.type = tT;
        this._implementation = new HashMap();
        this._types = tT.getTypes().toArray(new Classifier[0]);
        this._keys = tT.getNames().toArray(new String[0]);
        int i = 0;
        while (i < this._keys.length) {
            this._implementation.put(this._keys[i], arr[i]);
            ++i;
        }
    }

    @Override
    public Object asJavaObject() {
        return this.implementation();
    }

    @Override
    public OclType oclType() {
        return this.adapter.Type(this.type);
    }

    @Override
    public OclAny property(OclString s) {
        String key = (String)s.asJavaObject();
        OclAny o = (OclAny)this._implementation.get(key);
        if (o == null) {
            return this.adapter.Undefined();
        }
        return o;
    }

    public OclAny property(OclString s, Object[] pobjs) {
        return this.adapter.Undefined();
    }

    @Override
    public void setProperty(OclString name, Object value) {
        String key = (String)name.asJavaObject();
        this._implementation.put(key, value);
    }

    public String toString() {
        String str = "Tuple { ";
        Iterator i = this._implementation.keySet().iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            str = String.valueOf(str) + s + " = " + this._implementation.get(s);
            if (!i.hasNext()) continue;
            str = String.valueOf(str) + ", ";
        }
        return String.valueOf(str) + " }";
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof OclTupleImpl) {
            OclTupleImpl tuple = (OclTupleImpl)o;
            return this._implementation.equals(tuple._implementation);
        }
        return false;
    }

    @Override
    public Object clone() {
        return new OclTupleImpl(this.type, this._implementation.values().toArray(new OclAny[0]), this.adapter);
    }

    public Object accept(OclVisitor v, Object obj) {
        return v.visit(this, obj);
    }
}

