/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.standard.lib;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.model.types.BagType;
import org.oslo.ocl20.semantics.model.types.BooleanType;
import org.oslo.ocl20.semantics.model.types.CollectionType;
import org.oslo.ocl20.semantics.model.types.IntegerType;
import org.oslo.ocl20.semantics.model.types.OclAnyType;
import org.oslo.ocl20.semantics.model.types.OrderedSetType;
import org.oslo.ocl20.semantics.model.types.RealType;
import org.oslo.ocl20.semantics.model.types.SequenceType;
import org.oslo.ocl20.semantics.model.types.SetType;
import org.oslo.ocl20.semantics.model.types.StringType;
import org.oslo.ocl20.semantics.model.types.TupleType;
import org.oslo.ocl20.semantics.model.types.VoidType;
import org.oslo.ocl20.standard.lib.OclAny;
import org.oslo.ocl20.standard.lib.OclAnyModelElement;
import org.oslo.ocl20.standard.lib.OclAnyModelElementImpl;
import org.oslo.ocl20.standard.lib.OclBag;
import org.oslo.ocl20.standard.lib.OclBagImpl;
import org.oslo.ocl20.standard.lib.OclBoolean;
import org.oslo.ocl20.standard.lib.OclBooleanImpl;
import org.oslo.ocl20.standard.lib.OclCollection;
import org.oslo.ocl20.standard.lib.OclEnumeration;
import org.oslo.ocl20.standard.lib.OclEnumerationImpl;
import org.oslo.ocl20.standard.lib.OclInteger;
import org.oslo.ocl20.standard.lib.OclIntegerImpl;
import org.oslo.ocl20.standard.lib.OclOrderedSet;
import org.oslo.ocl20.standard.lib.OclOrderedSetImpl;
import org.oslo.ocl20.standard.lib.OclReal;
import org.oslo.ocl20.standard.lib.OclRealImpl;
import org.oslo.ocl20.standard.lib.OclSequence;
import org.oslo.ocl20.standard.lib.OclSequenceImpl;
import org.oslo.ocl20.standard.lib.OclSet;
import org.oslo.ocl20.standard.lib.OclSetImpl;
import org.oslo.ocl20.standard.lib.OclString;
import org.oslo.ocl20.standard.lib.OclStringImpl;
import org.oslo.ocl20.standard.lib.OclTuple;
import org.oslo.ocl20.standard.lib.OclTupleImpl;
import org.oslo.ocl20.standard.lib.OclType;
import org.oslo.ocl20.standard.lib.OclTypeImpl;
import org.oslo.ocl20.standard.lib.OclUndefined;
import org.oslo.ocl20.standard.lib.OclUndefinedImpl;
import org.oslo.ocl20.standard.lib.StdLibAdapter;

public class StdLibAdapterImpl
implements StdLibAdapter {
    private OclProcessor processor;

    @Override
    public OclProcessor getProcessor() {
        return this.processor;
    }

    public StdLibAdapterImpl(OclProcessor proc) {
        this.processor = proc;
        OclUndefinedImpl.UNDEFINED = new OclUndefinedImpl("Default", null, this);
        OclBooleanImpl.FALSE = new OclBooleanImpl(this);
        OclBooleanImpl.TRUE = new OclBooleanImpl(this);
    }

    @Override
    public OclAny OclAny(Object obj) {
        if (obj == null) {
            return this.Undefined();
        }
        if (obj instanceof OclAny) {
            return (OclAny)obj;
        }
        if (obj instanceof OclCollection) {
            return (OclCollection)obj;
        }
        if (obj instanceof Boolean) {
            return this.Boolean((Boolean)obj);
        }
        if (obj instanceof String) {
            return this.String((String)obj);
        }
        if (obj instanceof Double) {
            return this.Real((Double)obj);
        }
        if (obj instanceof Float) {
            return this.Real(new Double(((Float)obj).doubleValue()));
        }
        if (obj instanceof Integer) {
            return this.Integer((Integer)obj);
        }
        if (obj instanceof Collection) {
            return this.Collection((Collection)obj);
        }
        if (obj instanceof Map) {
            return this.Tuple((Map)obj);
        }
        if (obj instanceof Object) {
            return this.OclAnyModelElement(null, obj);
        }
        return this.Undefined();
    }

    @Override
    public OclAny OclAny(Classifier type, Object obj) {
        if (type == null) {
            return this.Undefined();
        }
        if (type instanceof VoidType) {
            return this.Undefined();
        }
        if (type instanceof BooleanType) {
            return this.Boolean((Boolean)obj);
        }
        if (type instanceof StringType) {
            return this.String((String)obj);
        }
        if (type instanceof IntegerType) {
            return this.Integer((Integer)obj);
        }
        if (type instanceof RealType) {
            return this.Real((Double)obj);
        }
        if (type instanceof TupleType) {
            return this.Tuple((TupleType)type, (Map)obj);
        }
        if (type instanceof CollectionType) {
            return this.Collection((Collection)obj);
        }
        return this.OclAnyModelElement(type, obj);
    }

    @Override
    public OclType Type(Classifier cls) {
        return new OclTypeImpl(cls, this);
    }

    @Override
    public OclAnyModelElement OclAnyModelElement(Classifier type, Object obj) {
        return new OclAnyModelElementImpl(obj, this);
    }

    @Override
    public OclEnumeration Enumeration(Classifier type, Object obj) {
        return new OclEnumerationImpl(type, obj, this);
    }

    @Override
    public OclUndefined Undefined() {
        return OclUndefinedImpl.UNDEFINED;
    }

    @Override
    public OclBoolean Boolean(boolean b) {
        if (b) {
            return OclBooleanImpl.TRUE;
        }
        return OclBooleanImpl.FALSE;
    }

    @Override
    public OclBoolean Boolean(Boolean b) {
        if (b != null) {
            return this.Boolean((boolean)b);
        }
        return this.Undefined();
    }

    @Override
    public OclBoolean Boolean(String b) {
        return this.Boolean((boolean)Boolean.valueOf(b));
    }

    @Override
    public OclReal Real(double r) {
        return new OclRealImpl(r, this);
    }

    @Override
    public OclReal Real(Double r) {
        return new OclRealImpl(r, this);
    }

    @Override
    public OclReal Real(String r) {
        return new OclRealImpl(Double.valueOf(r), this);
    }

    @Override
    public OclReal Real(float r) {
        return new OclRealImpl(r, this);
    }

    @Override
    public OclInteger Integer(int i) {
        return new OclIntegerImpl(i, (StdLibAdapter)this);
    }

    @Override
    public OclInteger Integer(Integer i) {
        return new OclIntegerImpl(i, (StdLibAdapter)this);
    }

    @Override
    public OclInteger Integer(String i) {
        return new OclIntegerImpl(Integer.valueOf(i), (StdLibAdapter)this);
    }

    @Override
    public OclString String(String s) {
        return new OclStringImpl(s, this);
    }

    @Override
    public OclTuple Tuple(TupleType eT, Map m) {
        return this.Tuple(eT, m.values().toArray(new OclAny[0]));
    }

    public OclTuple Tuple(Map m) {
        return new OclTupleImpl(m, this);
    }

    @Override
    public OclTuple Tuple(TupleType eT, OclAny[] arr) {
        return new OclTupleImpl(eT, arr, this);
    }

    @Override
    public OclCollection Collection(Collection obj) {
        OclAnyType oat = this.processor.getTypeFactory().buildOclAnyType();
        if (obj == null) {
            return this.Undefined();
        }
        if (obj instanceof List) {
            return this.Sequence((Classifier)oat, (List)obj);
        }
        if (obj instanceof Set) {
            return this.Set((Classifier)oat, (Set)obj);
        }
        if (obj instanceof Collection) {
            return this.Bag((Classifier)oat, obj);
        }
        return this.Undefined();
    }

    @Override
    public OclCollection Collection(Classifier eT) {
        if (eT instanceof OrderedSetType) {
            return this.OrderedSet(eT);
        }
        if (eT instanceof SetType) {
            return this.Set(eT);
        }
        if (eT instanceof SequenceType) {
            return this.Sequence(eT);
        }
        if (eT instanceof BagType) {
            return this.Bag(eT);
        }
        return this.Undefined();
    }

    @Override
    public OclSet Set(Classifier eT) {
        return this.Set(eT, new OclAny[0]);
    }

    @Override
    public OclSet Set(Classifier eT, Collection impl) {
        if (impl != null) {
            return this.Set(eT, this.convert(eT, impl.toArray()));
        }
        return this.Set(eT);
    }

    @Override
    public OclSet Set(Classifier eT, Object[] array) {
        return new OclSetImpl(eT, this.convert(eT, array), this);
    }

    @Override
    public OclOrderedSet OrderedSet(Classifier eT) {
        return this.OrderedSet(eT, new OclAny[0]);
    }

    @Override
    public OclOrderedSet OrderedSet(Classifier eT, Collection impl) {
        return this.OrderedSet(eT, this.convert(eT, impl.toArray()));
    }

    @Override
    public OclOrderedSet OrderedSet(Classifier eT, Object[] array) {
        return new OclOrderedSetImpl(eT, this.convert(eT, array), this);
    }

    @Override
    public OclSequence Sequence(Classifier eT) {
        return this.Sequence(eT, new OclAny[0]);
    }

    @Override
    public OclSequence Sequence(Classifier eT, Collection impl) {
        return this.Sequence(eT, this.convert(eT, impl.toArray()));
    }

    @Override
    public OclSequence Sequence(Classifier eT, Object[] array) {
        return new OclSequenceImpl(eT, this.convert(eT, array), this);
    }

    @Override
    public OclBag Bag(Classifier eT) {
        return this.Bag(eT, new OclAny[0]);
    }

    @Override
    public OclBag Bag(Classifier eT, Collection impl) {
        return this.Bag(eT, this.convert(eT, impl.toArray()));
    }

    @Override
    public OclBag Bag(Classifier eT, Object[] array) {
        return new OclBagImpl(eT, this.convert(eT, array), this);
    }

    protected OclAny[] convert(Classifier eT, Object[] array) {
        if (array instanceof OclAny[]) {
            return (OclAny[])array;
        }
        OclAny[] oclArray = new OclAny[array.length];
        int i = 0;
        while (i < array.length) {
            oclArray[i] = this.OclAny(array[i]);
            ++i;
        }
        return oclArray;
    }
}

