/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.standard.types;

import java.util.Collection;
import java.util.List;
import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.semantics.SemanticsVisitor;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.bridge.Operation;
import org.oslo.ocl20.semantics.model.types.BagType;
import org.oslo.ocl20.semantics.model.types.CollectionType;
import org.oslo.ocl20.semantics.model.types.OrderedSetType;
import org.oslo.ocl20.semantics.model.types.SequenceType;
import org.oslo.ocl20.semantics.model.types.SetType;
import org.oslo.ocl20.semantics.model.types.TypeFactory;
import org.oslo.ocl20.semantics.model.types.VoidType;
import org.oslo.ocl20.standard.lib.OclBag;
import org.oslo.ocl20.standard.types.CollectionTypeImpl;
import org.oslo.ocl20.standard.types.TypeConformance;

public class BagTypeImpl
extends CollectionTypeImpl
implements BagType {
    public BagTypeImpl(Classifier elementType, OclProcessor proc) {
        super(elementType, proc);
        this.setName("Bag");
    }

    @Override
    public void createOperations(TypeFactory tf) {
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildBooleanType(), "=", new Classifier[]{this}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildBooleanType(), "<>", new Classifier[]{this}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(this, "union", new Classifier[]{this}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(this, "union", new Classifier[]{tf.buildSetType(this.getElementType())}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(this, "union", new Classifier[]{tf.buildOrderedSetType(this.getElementType())}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(this, "intersection", new Classifier[]{this}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildSetType(this.getElementType()), "intersection", new Classifier[]{tf.buildSetType(this.getElementType())}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildOrderedSetType(this.getElementType()), "intersection", new Classifier[]{tf.buildOrderedSetType(this.getElementType())}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(this, "including", new Classifier[]{this.getElementType()}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(this, "excluding", new Classifier[]{this.getElementType()}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildIntegerType(), "count", new Classifier[]{this.getElementType()}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildBagType(tf.getFlatType(this)), "flatten", new Classifier[0]));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(this, "asBag", new Classifier[0]));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildSequenceType(this.getElementType()), "asSequence", new Classifier[0]));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildSetType(this.getElementType()), "asSet", new Classifier[0]));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildOrderedSetType(this.getElementType()), "asOrderedSet", new Classifier[0]));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(this, "select", new Classifier[]{tf.buildBooleanType()}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(this, "select", new Classifier[]{this.getElementType(), tf.buildBooleanType()}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(this, "reject", new Classifier[]{tf.buildBooleanType()}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(this, "reject", new Classifier[]{this.getElementType(), tf.buildBooleanType()}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildSequenceType(this.getElementType()), "sortedBy", new Classifier[]{tf.buildClassifier()}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildSequenceType(this.getElementType()), "sortedBy", new Classifier[]{this.getElementType(), tf.buildClassifier()}));
        super.createOperations(tf);
    }

    @Override
    public Operation lookupOperation(String name, List types) {
        Operation op = super.lookupOperation(name, types);
        if (op == null) {
            if (name.equals("collect")) {
                Classifier bodyType = (Classifier)types.get(types.size() - 1);
                Classifier baseType = this.baseElementType(bodyType);
                BagType bagT = this.processor.getTypeFactory().buildBagType(baseType);
                return this.processor.getBridgeFactory().buildOperation(bagT, "collect", null);
            }
            if (name.equals("collectNested")) {
                BagType bagT = this.processor.getTypeFactory().buildBagType((Classifier)types.get(types.size() - 1));
                return this.processor.getBridgeFactory().buildOperation(bagT, "collectNested", null);
            }
        }
        return op;
    }

    @Override
    public Boolean conformsTo(Classifier t2) {
        if (t2 instanceof VoidType) {
            return Boolean.TRUE;
        }
        if (t2 instanceof BagType) {
            return this.getElementType().conformsTo(((BagType)t2).getElementType());
        }
        if (t2 instanceof CollectionType && !(t2 instanceof SetType) && !(t2 instanceof OrderedSetType) && !(t2 instanceof SequenceType)) {
            return this.getElementType().conformsTo(((CollectionType)t2).getElementType());
        }
        return TypeConformance.isAssignableTo(this, t2) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object accept(SemanticsVisitor v, Object obj) {
        return v.visit(this, obj);
    }

    @Override
    public String toString() {
        return "Bag(" + this.getElementType() + ")";
    }

    @Override
    public Object getDelegate() {
        return Collection.class;
    }

    @Override
    public Class getImplClass() {
        return OclBag.class;
    }
}

