/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.standard.types;

import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.semantics.SemanticsVisitor;
import org.oslo.ocl20.semantics.bridge.BridgeFactory;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.model.types.BooleanType;
import org.oslo.ocl20.semantics.model.types.TypeFactory;
import org.oslo.ocl20.standard.lib.OclBoolean;
import org.oslo.ocl20.standard.types.PrimitiveImpl;
import org.oslo.ocl20.standard.types.TypeConformance;

public class BooleanTypeImpl
extends PrimitiveImpl
implements BooleanType {
    public BooleanTypeImpl(OclProcessor proc) {
        super(proc);
        this.setName("Boolean");
    }

    @Override
    public void createOperations(TypeFactory tf) {
        BridgeFactory bf = this.processor.getBridgeFactory();
        this.getOperations().add(bf.buildOperation(tf.buildBooleanType(), "or", new Classifier[]{tf.buildBooleanType()}));
        this.getOperations().add(bf.buildOperation(tf.buildBooleanType(), "xor", new Classifier[]{tf.buildBooleanType()}));
        this.getOperations().add(bf.buildOperation(tf.buildBooleanType(), "and", new Classifier[]{tf.buildBooleanType()}));
        this.getOperations().add(bf.buildOperation(tf.buildBooleanType(), "not", new Classifier[0]));
        this.getOperations().add(bf.buildOperation(tf.buildBooleanType(), "implies", new Classifier[]{tf.buildBooleanType()}));
        super.createOperations(tf);
    }

    @Override
    public Boolean conformsTo(Classifier t2) {
        return TypeConformance.isAssignableTo(this, t2) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object accept(SemanticsVisitor v, Object obj) {
        return v.visit(this, obj);
    }

    @Override
    public String toString() {
        return "Boolean";
    }

    @Override
    public Object getDelegate() {
        return Boolean.class;
    }

    @Override
    public Class getImplClass() {
        return OclBoolean.class;
    }
}

