/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.standard.types;

import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.semantics.SemanticsVisitor;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.bridge.Operation;
import org.oslo.ocl20.semantics.model.types.BagType;
import org.oslo.ocl20.semantics.model.types.CollectionType;
import org.oslo.ocl20.semantics.model.types.OrderedSetType;
import org.oslo.ocl20.semantics.model.types.SequenceType;
import org.oslo.ocl20.semantics.model.types.SetType;
import org.oslo.ocl20.semantics.model.types.TupleType;
import org.oslo.ocl20.semantics.model.types.TypeFactory;
import org.oslo.ocl20.semantics.model.types.VoidType;
import org.oslo.ocl20.standard.lib.OclCollection;
import org.oslo.ocl20.standard.types.OclAnyTypeImpl;
import org.oslo.ocl20.standard.types.TypeConformance;

public class CollectionTypeImpl
extends OclAnyTypeImpl
implements CollectionType {
    Classifier _elementType = null;

    public CollectionTypeImpl(Classifier elementType, OclProcessor proc) {
        super(proc);
        this.setElementType(elementType);
        this.setName("Collection");
    }

    @Override
    public void createOperations(TypeFactory tf) {
        CollectionType colT = this.getClass() == CollectionTypeImpl.class ? this : tf.buildCollectionType(this.getElementType());
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildIntegerType(), "size", new Classifier[0]));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildBooleanType(), "includes", new Classifier[]{this.getElementType()}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildBooleanType(), "excludes", new Classifier[]{this.getElementType()}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildIntegerType(), "count", new Classifier[]{this.getElementType()}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildBooleanType(), "includesAll", new Classifier[]{colT}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildBooleanType(), "excludesAll", new Classifier[]{colT}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildBooleanType(), "isEmpty", new Classifier[0]));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildBooleanType(), "notEmpty", new Classifier[0]));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(this.getElementType(), "sum", new Classifier[0]));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildBooleanType(), "exists", new Classifier[]{tf.buildBooleanType()}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildBooleanType(), "exists", new Classifier[]{this.getElementType(), tf.buildBooleanType()}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildBooleanType(), "exists", new Classifier[]{this.getElementType(), this.getElementType(), tf.buildBooleanType()}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildBooleanType(), "forAll", new Classifier[]{tf.buildBooleanType()}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildBooleanType(), "forAll", new Classifier[]{this.getElementType(), tf.buildBooleanType()}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildBooleanType(), "forAll", new Classifier[]{this.getElementType(), this.getElementType(), tf.buildBooleanType()}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildBooleanType(), "isUnique", new Classifier[]{tf.buildClassifier()}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildBooleanType(), "isUnique", new Classifier[]{this.getElementType(), tf.buildClassifier()}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildBooleanType(), "isUnique", new Classifier[]{this.getElementType(), this.getElementType(), tf.buildClassifier()}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(this.getElementType(), "any", new Classifier[]{tf.buildBooleanType()}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(this.getElementType(), "any", new Classifier[]{this.getElementType(), tf.buildBooleanType()}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(this.getElementType(), "any", new Classifier[]{this.getElementType(), this.getElementType(), tf.buildBooleanType()}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildBooleanType(), "one", new Classifier[]{tf.buildBooleanType()}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildBooleanType(), "one", new Classifier[]{this.getElementType(), tf.buildBooleanType()}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildBooleanType(), "one", new Classifier[]{this.getElementType(), this.getElementType(), tf.buildBooleanType()}));
        super.createOperations(tf);
    }

    public List getCollectionTypeOperations() {
        CollectionType colT = this.getClass() == CollectionTypeImpl.class ? this : this.processor.getTypeFactory().buildCollectionType(this.getElementType());
        Vector<Operation> oper = new Vector<Operation>();
        oper.add(this.processor.getBridgeFactory().buildOperation(this.processor.getTypeFactory().buildIntegerType(), "size", new Classifier[0]));
        oper.add(this.processor.getBridgeFactory().buildOperation(this.processor.getTypeFactory().buildBooleanType(), "includes", new Classifier[]{this.getElementType()}));
        oper.add(this.processor.getBridgeFactory().buildOperation(this.processor.getTypeFactory().buildBooleanType(), "excludes", new Classifier[]{this.getElementType()}));
        oper.add(this.processor.getBridgeFactory().buildOperation(this.processor.getTypeFactory().buildIntegerType(), "count", new Classifier[]{this.getElementType()}));
        oper.add(this.processor.getBridgeFactory().buildOperation(this.processor.getTypeFactory().buildBooleanType(), "includesAll", new Classifier[]{colT}));
        oper.add(this.processor.getBridgeFactory().buildOperation(this.processor.getTypeFactory().buildBooleanType(), "excludesAll", new Classifier[]{colT}));
        oper.add(this.processor.getBridgeFactory().buildOperation(this.processor.getTypeFactory().buildBooleanType(), "isEmpty", new Classifier[0]));
        oper.add(this.processor.getBridgeFactory().buildOperation(this.processor.getTypeFactory().buildBooleanType(), "notEmpty", new Classifier[0]));
        oper.add(this.processor.getBridgeFactory().buildOperation(this.getElementType(), "sum", new Classifier[0]));
        oper.add(this.processor.getBridgeFactory().buildOperation(this.processor.getTypeFactory().buildBooleanType(), "exists", new Classifier[]{this.processor.getTypeFactory().buildBooleanType()}));
        oper.add(this.processor.getBridgeFactory().buildOperation(this.processor.getTypeFactory().buildBooleanType(), "exists", new Classifier[]{this.getElementType(), this.processor.getTypeFactory().buildBooleanType()}));
        oper.add(this.processor.getBridgeFactory().buildOperation(this.processor.getTypeFactory().buildBooleanType(), "exists", new Classifier[]{this.getElementType(), this.getElementType(), this.processor.getTypeFactory().buildBooleanType()}));
        oper.add(this.processor.getBridgeFactory().buildOperation(this.processor.getTypeFactory().buildBooleanType(), "forAll", new Classifier[]{this.processor.getTypeFactory().buildBooleanType()}));
        oper.add(this.processor.getBridgeFactory().buildOperation(this.processor.getTypeFactory().buildBooleanType(), "forAll", new Classifier[]{this.getElementType(), this.processor.getTypeFactory().buildBooleanType()}));
        oper.add(this.processor.getBridgeFactory().buildOperation(this.processor.getTypeFactory().buildBooleanType(), "forAll", new Classifier[]{this.getElementType(), this.getElementType(), this.processor.getTypeFactory().buildBooleanType()}));
        oper.add(this.processor.getBridgeFactory().buildOperation(this.processor.getTypeFactory().buildBooleanType(), "isUnique", new Classifier[]{this.processor.getTypeFactory().buildClassifier()}));
        oper.add(this.processor.getBridgeFactory().buildOperation(this.processor.getTypeFactory().buildBooleanType(), "isUnique", new Classifier[]{this.getElementType(), this.processor.getTypeFactory().buildClassifier()}));
        oper.add(this.processor.getBridgeFactory().buildOperation(this.processor.getTypeFactory().buildBooleanType(), "isUnique", new Classifier[]{this.getElementType(), this.getElementType(), this.processor.getTypeFactory().buildClassifier()}));
        oper.add(this.processor.getBridgeFactory().buildOperation(this.getElementType(), "any", new Classifier[]{this.processor.getTypeFactory().buildBooleanType()}));
        oper.add(this.processor.getBridgeFactory().buildOperation(this.getElementType(), "any", new Classifier[]{this.getElementType(), this.processor.getTypeFactory().buildBooleanType()}));
        oper.add(this.processor.getBridgeFactory().buildOperation(this.getElementType(), "any", new Classifier[]{this.getElementType(), this.getElementType(), this.processor.getTypeFactory().buildBooleanType()}));
        oper.add(this.processor.getBridgeFactory().buildOperation(this.processor.getTypeFactory().buildBooleanType(), "one", new Classifier[]{this.processor.getTypeFactory().buildBooleanType()}));
        oper.add(this.processor.getBridgeFactory().buildOperation(this.processor.getTypeFactory().buildBooleanType(), "one", new Classifier[]{this.getElementType(), this.processor.getTypeFactory().buildBooleanType()}));
        oper.add(this.processor.getBridgeFactory().buildOperation(this.processor.getTypeFactory().buildBooleanType(), "one", new Classifier[]{this.getElementType(), this.getElementType(), this.processor.getTypeFactory().buildBooleanType()}));
        return oper;
    }

    @Override
    public Classifier getElementType() {
        return this._elementType;
    }

    @Override
    public void setElementType(Classifier elementType) {
        this._elementType = elementType;
    }

    @Override
    public Classifier getBaseElementType() {
        Classifier x = this.getElementType();
        if (x instanceof CollectionType) {
            return ((CollectionType)x).getBaseElementType();
        }
        return x;
    }

    @Override
    public Boolean conformsTo(Classifier t2) {
        if (t2 instanceof VoidType) {
            return Boolean.TRUE;
        }
        if (!(!(t2 instanceof CollectionType) || t2 instanceof SetType || t2 instanceof OrderedSetType || t2 instanceof SequenceType || t2 instanceof BagType)) {
            return this.getElementType().conformsTo(((CollectionType)t2).getElementType());
        }
        return TypeConformance.isAssignableTo(this, t2) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Operation lookupOperation(String name, List types) {
        Operation op = super.lookupOperation(name, types);
        if (op == null && name.equals("product")) {
            Classifier t = this.getElementType();
            Classifier t2 = (Classifier)types.get(types.size() - 1);
            TupleType tt = this.processor.getTypeFactory().buildTupleType(new String[]{"first", "second"}, new Classifier[]{t, t2});
            return this.processor.getBridgeFactory().buildOperation(tt, "product", null);
        }
        return op;
    }

    @Override
    public Object accept(SemanticsVisitor v, Object obj) {
        return v.visit(this, obj);
    }

    @Override
    public String toString() {
        return "Collection(" + this.getElementType() + ")";
    }

    @Override
    public Object getDelegate() {
        return Collection.class;
    }

    @Override
    public Class getImplClass() {
        return OclCollection.class;
    }

    Classifier baseElementType(Classifier t) {
        if (t instanceof CollectionType) {
            return this.baseElementType(((CollectionType)t).getElementType());
        }
        return t;
    }
}

