/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.standard.types;

import java.util.List;
import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.semantics.SemanticsVisitor;
import org.oslo.ocl20.semantics.bridge.BridgeFactory;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.bridge.DataTypeImpl;
import org.oslo.ocl20.semantics.bridge.Operation;
import org.oslo.ocl20.semantics.model.types.OclAnyType;
import org.oslo.ocl20.semantics.model.types.SetType;
import org.oslo.ocl20.semantics.model.types.TypeFactory;
import org.oslo.ocl20.semantics.model.types.TypeType;
import org.oslo.ocl20.standard.lib.OclAny;
import org.oslo.ocl20.standard.types.TypeConformance;

public class OclAnyTypeImpl
extends DataTypeImpl
implements OclAnyType {
    public OclAnyTypeImpl(OclProcessor proc) {
        super(proc);
        this.setName("OclAny");
    }

    @Override
    public void createOperations(TypeFactory tf) {
        BridgeFactory bf = this.processor.getBridgeFactory();
        this.getOperations().add(bf.buildOperation(tf.buildBooleanType(), "=", new Classifier[]{tf.buildOclAnyType()}));
        this.getOperations().add(bf.buildOperation(tf.buildBooleanType(), "<>", new Classifier[]{tf.buildOclAnyType()}));
        this.getOperations().add(bf.buildOperation(tf.buildBooleanType(), "oclIsNew", new Classifier[0]));
        this.getOperations().add(bf.buildOperation(tf.buildBooleanType(), "oclIsUndefined", new Classifier[0]));
        this.getOperations().add(bf.buildOperation(tf.buildBooleanType(), "oclIsTypeOf", new Classifier[]{tf.buildClassifier()}));
        this.getOperations().add(bf.buildOperation(tf.buildBooleanType(), "oclIsKindOf", new Classifier[]{tf.buildClassifier()}));
    }

    @Override
    public Operation lookupOperation(String name, List types) {
        Operation op = super.lookupOperation(name, types);
        if (op == null) {
            if (name.equals("oclAsType")) {
                TypeType tt = (TypeType)types.get(0);
                return this.processor.getBridgeFactory().buildOperation(tt.getClassifier(), "oclAsType", new Classifier[]{tt.getClassifier()});
            }
            if (name.equals("allInstances")) {
                SetType setT = this.processor.getTypeFactory().buildSetType(this);
                return this.processor.getBridgeFactory().buildOperation(setT, "allInstances", null);
            }
        }
        return op;
    }

    @Override
    public Boolean conformsTo(Classifier t2) {
        return TypeConformance.isAssignableTo(this, t2) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object accept(SemanticsVisitor v, Object obj) {
        return v.visit(this, obj);
    }

    @Override
    public String toString() {
        return "OclAny";
    }

    @Override
    public Object getDelegate() {
        return Object.class;
    }

    @Override
    public Class getImplClass() {
        return OclAny.class;
    }
}

