/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.standard.types;

import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.semantics.SemanticsVisitor;
import org.oslo.ocl20.semantics.bridge.BridgeFactory;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.model.types.StringType;
import org.oslo.ocl20.semantics.model.types.TypeFactory;
import org.oslo.ocl20.standard.lib.OclString;
import org.oslo.ocl20.standard.types.PrimitiveImpl;
import org.oslo.ocl20.standard.types.TypeConformance;

public class StringTypeImpl
extends PrimitiveImpl
implements StringType {
    public StringTypeImpl(OclProcessor proc) {
        super(proc);
        this.setName("String");
    }

    @Override
    public void createOperations(TypeFactory tf) {
        BridgeFactory bf = this.processor.getBridgeFactory();
        this.getOperations().add(bf.buildOperation(tf.buildIntegerType(), "size", new Classifier[0]));
        this.getOperations().add(bf.buildOperation(tf.buildStringType(), "concat", new Classifier[]{tf.buildStringType()}));
        this.getOperations().add(bf.buildOperation(tf.buildStringType(), "substring", new Classifier[]{tf.buildIntegerType(), tf.buildIntegerType()}));
        this.getOperations().add(bf.buildOperation(tf.buildIntegerType(), "toInteger", new Classifier[0]));
        this.getOperations().add(bf.buildOperation(tf.buildRealType(), "toReal", new Classifier[0]));
        super.createOperations(tf);
    }

    @Override
    public Boolean conformsTo(Classifier t2) {
        return TypeConformance.isAssignableTo(this, t2) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object accept(SemanticsVisitor v, Object obj) {
        return v.visit(this, obj);
    }

    @Override
    public String toString() {
        return "String";
    }

    @Override
    public Object getDelegate() {
        return String.class;
    }

    @Override
    public Class getImplClass() {
        return OclString.class;
    }
}

