/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.standard.types;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.semantics.SemanticsVisitor;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.bridge.DataTypeImpl;
import org.oslo.ocl20.semantics.bridge.Property;
import org.oslo.ocl20.semantics.model.expressions.VariableDeclaration;
import org.oslo.ocl20.semantics.model.types.TupleType;
import org.oslo.ocl20.semantics.model.types.TypeFactory;
import org.oslo.ocl20.semantics.model.types.VoidType;
import org.oslo.ocl20.standard.lib.OclTuple;
import org.oslo.ocl20.standard.types.TypeConformance;

public class TupleTypeImpl
extends DataTypeImpl
implements TupleType {
    protected List partType = new Vector();

    public TupleTypeImpl(OclProcessor proc) {
        super(proc);
        this.setName("TupleType");
    }

    @Override
    public void createOperations(TypeFactory tf) {
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildBooleanType(), "=", new Classifier[]{this}));
        this.getOperations().add(this.processor.getBridgeFactory().buildOperation(tf.buildBooleanType(), "<>", new Classifier[]{this}));
    }

    @Override
    public List getPartType() {
        return this.partType;
    }

    @Override
    public void setPartType(List partType) {
        this.partType = partType;
    }

    @Override
    public List getNames() {
        Vector<String> v = new Vector<String>();
        for (VariableDeclaration vd : this.getPartType()) {
            v.add(vd.getName());
        }
        return v;
    }

    @Override
    public List getTypes() {
        Vector<Classifier> v = new Vector<Classifier>();
        for (VariableDeclaration vd : this.getPartType()) {
            v.add(vd.getType());
        }
        return v;
    }

    @Override
    public TupleType project(Set nameSet) {
        List names = this.getNames();
        List types = this.getTypes();
        for (VariableDeclaration p : this.getPartType()) {
            if (nameSet.contains(p.getName())) continue;
            types.remove(names.indexOf(p.getName()));
            names.remove(p.getName());
        }
        return this.processor.getTypeFactory().buildTupleType(names.toArray(new String[0]), types.toArray(new Classifier[0]));
    }

    @Override
    public TupleType join(TupleType t2) {
        Vector names = new Vector(this.getNames());
        Vector types = new Vector(this.getTypes());
        names.addAll(t2.getNames());
        types.addAll(t2.getTypes());
        return this.processor.getTypeFactory().buildTupleType(names.toArray(new String[0]), types.toArray(new Classifier[0]));
    }

    @Override
    public Property lookupProperty(String name) {
        for (VariableDeclaration p : this.getPartType()) {
            if (!p.getName().equals(name)) continue;
            return new PropertyPartImpl(p);
        }
        return null;
    }

    @Override
    public Boolean conformsTo(Classifier t2) {
        if (t2 instanceof VoidType) {
            return Boolean.TRUE;
        }
        if (t2 instanceof TupleType) {
            List l1 = this.getPartType();
            List l2 = ((TupleType)t2).getPartType();
            if (l1.size() != l2.size()) {
                return Boolean.FALSE;
            }
            for (VariableDeclaration var1 : l1) {
                Classifier t21;
                VariableDeclaration var2 = this.getVar(var1.getName(), l2);
                if (var2 == null) {
                    return Boolean.FALSE;
                }
                Classifier t11 = var1.getType();
                Boolean conforms = t11.conformsTo(t21 = var2.getType());
                if (conforms.booleanValue()) continue;
                return Boolean.TRUE;
            }
            return Boolean.TRUE;
        }
        return TypeConformance.isAssignableTo(this, t2) ? Boolean.TRUE : Boolean.FALSE;
    }

    VariableDeclaration getVar(String name, List list) {
        VariableDeclaration res = null;
        for (VariableDeclaration var : list) {
            if (!var.getName().equals(name)) continue;
            return var;
        }
        return res;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public Object accept(SemanticsVisitor v, Object obj) {
        return v.visit(this, obj);
    }

    @Override
    public String toString() {
        String str = "Tuple(";
        Iterator i = this.getPartType().iterator();
        while (i.hasNext()) {
            VariableDeclaration pt = (VariableDeclaration)i.next();
            str = String.valueOf(str) + pt.getName() + ":" + pt.getType();
            if (!i.hasNext()) continue;
            str = String.valueOf(str) + ", ";
        }
        return String.valueOf(str) + ")";
    }

    @Override
    public Object getDelegate() {
        return Map.class;
    }

    @Override
    public Class getImplClass() {
        return OclTuple.class;
    }

    class PropertyPartImpl
    implements Property {
        VariableDeclaration part;

        PropertyPartImpl(VariableDeclaration part) {
            this.part = part;
        }

        @Override
        public Classifier getType() {
            return this.part.getType();
        }

        @Override
        public void setType(Classifier type) {
        }

        @Override
        public Object clone() {
            return null;
        }

        @Override
        public Object accept(SemanticsVisitor v, Object obj) {
            return v.visit(this, obj);
        }

        @Override
        public String getName() {
            return this.part.getName();
        }

        @Override
        public void setName(String name) {
        }

        @Override
        public Object getDelegate() {
            return this.part;
        }
    }
}

