/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.standard.types;

import java.util.Iterator;
import java.util.List;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.bridge.Primitive;
import org.oslo.ocl20.semantics.model.expressions.VariableDeclaration;
import org.oslo.ocl20.semantics.model.types.BagType;
import org.oslo.ocl20.semantics.model.types.CollectionType;
import org.oslo.ocl20.semantics.model.types.OrderedSetType;
import org.oslo.ocl20.semantics.model.types.SequenceType;
import org.oslo.ocl20.semantics.model.types.SetType;
import org.oslo.ocl20.semantics.model.types.TupleType;
import org.oslo.ocl20.semantics.model.types.VoidType;

public class TypeConformance {
    public static Class getInterface(Object t) {
        if (t == null) {
            return null;
        }
        Class<?> c = t.getClass();
        if (!c.isInterface()) {
            int pos;
            String clsName = c.getName();
            String interfName = "";
            if (clsName.endsWith("$Class")) {
                pos = clsName.lastIndexOf(36);
                interfName = clsName.substring(0, pos);
            } else if (clsName.endsWith("Impl")) {
                pos = clsName.lastIndexOf(73);
                interfName = clsName.substring(0, pos);
            }
            pos = interfName.lastIndexOf(46);
            if (pos != 1) {
                interfName = interfName.substring(pos + 1, interfName.length());
            }
            Class<?>[] interfs = c.getInterfaces();
            int i = 0;
            while (i < interfs.length) {
                String name = interfs[i].getName();
                if (name.endsWith(interfName)) {
                    return interfs[i];
                }
                ++i;
            }
        }
        return c;
    }

    public static boolean isAssignableTo(Object t1, Object t2) {
        Class i1 = TypeConformance.getInterface(t1);
        Class i2 = TypeConformance.getInterface(t2);
        if (i2 == null) {
            return true;
        }
        return i2.isAssignableFrom(i1);
    }

    public static boolean conformsTo(Classifier t1, Classifier t2) {
        if (t1 instanceof VoidType) {
            return true;
        }
        if (t1 instanceof Primitive) {
            return TypeConformance.isAssignableTo(t1, t2);
        }
        if (t1 instanceof TupleType) {
            if (t2 instanceof VoidType) {
                return true;
            }
            if (t2 instanceof TupleType) {
                List l1 = ((TupleType)t1).getPartType();
                List l2 = ((TupleType)t2).getPartType();
                if (l1.size() != l2.size()) {
                    return false;
                }
                Iterator i1 = l1.iterator();
                Iterator i2 = l2.iterator();
                while (i1.hasNext()) {
                    Classifier t21;
                    String name2;
                    VariableDeclaration var1 = (VariableDeclaration)i1.next();
                    VariableDeclaration var2 = (VariableDeclaration)i2.next();
                    String name1 = var1.getName();
                    if (!name1.equals(name2 = var2.getName())) {
                        return false;
                    }
                    Classifier t11 = var1.getType();
                    boolean conforms = TypeConformance.conformsTo(t11, t21 = var2.getType());
                    if (conforms) continue;
                    return false;
                }
                return true;
            }
            return TypeConformance.isAssignableTo(t1, t2);
        }
        if (t1 instanceof BagType) {
            if (t2 instanceof VoidType) {
                return true;
            }
            if (t2 instanceof BagType) {
                return TypeConformance.conformsTo(((BagType)t1).getElementType(), ((BagType)t2).getElementType());
            }
            if (t2 instanceof CollectionType && !(t2 instanceof SetType) && !(t2 instanceof OrderedSetType) && !(t2 instanceof SequenceType)) {
                return TypeConformance.conformsTo(((BagType)t1).getElementType(), ((CollectionType)t2).getElementType());
            }
            return TypeConformance.isAssignableTo(t1, t2);
        }
        if (t1 instanceof SetType) {
            if (t2 instanceof VoidType) {
                return true;
            }
            if (t2 instanceof SetType) {
                return TypeConformance.conformsTo(((SetType)t1).getElementType(), ((SetType)t2).getElementType());
            }
            if (t2 instanceof CollectionType && !(t2 instanceof BagType) && !(t2 instanceof OrderedSetType) && !(t2 instanceof SequenceType)) {
                return TypeConformance.conformsTo(((SetType)t1).getElementType(), ((CollectionType)t2).getElementType());
            }
            return TypeConformance.isAssignableTo(t1, t2);
        }
        if (t1 instanceof OrderedSetType) {
            if (t2 instanceof VoidType) {
                return true;
            }
            if (t2 instanceof OrderedSetType) {
                return TypeConformance.conformsTo(((OrderedSetType)t1).getElementType(), ((OrderedSetType)t2).getElementType());
            }
            if (t2 instanceof CollectionType && !(t2 instanceof SetType) && !(t2 instanceof BagType) && !(t2 instanceof SequenceType)) {
                return TypeConformance.conformsTo(((OrderedSetType)t1).getElementType(), ((CollectionType)t2).getElementType());
            }
            return TypeConformance.isAssignableTo(t1, t2);
        }
        if (t1 instanceof SequenceType) {
            if (t2 instanceof VoidType) {
                return true;
            }
            if (t2 instanceof SequenceType) {
                return TypeConformance.conformsTo(((SequenceType)t1).getElementType(), ((SequenceType)t2).getElementType());
            }
            if (t2 instanceof CollectionType && !(t2 instanceof SetType) && !(t2 instanceof OrderedSetType) && !(t2 instanceof BagType)) {
                return TypeConformance.conformsTo(((SequenceType)t1).getElementType(), ((CollectionType)t2).getElementType());
            }
            return TypeConformance.isAssignableTo(t1, t2);
        }
        if (t1 instanceof CollectionType) {
            if (t2 instanceof VoidType) {
                return true;
            }
            if (!(!(t2 instanceof CollectionType) || t2 instanceof SetType || t2 instanceof OrderedSetType || t2 instanceof SequenceType || t2 instanceof BagType)) {
                return TypeConformance.conformsTo(((CollectionType)t1).getElementType(), ((CollectionType)t2).getElementType());
            }
            return TypeConformance.isAssignableTo(t1, t2);
        }
        return TypeConformance.isAssignableTo(t1, t2);
    }

    public static boolean identical(Classifier t1, Classifier t2) {
        String name1 = t1.getClass().toString();
        String name2 = t2.getClass().toString();
        return name1.equals(name2);
    }
}

