/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.syntax.parser;

import java.util.List;
import java.util.Vector;
import org.oslo.ocl20.syntax.ast.astFactory;
import org.oslo.ocl20.syntax.ast.contexts.ClassifierContextDeclAS;
import org.oslo.ocl20.syntax.ast.contexts.ConstraintAS;
import org.oslo.ocl20.syntax.ast.contexts.ConstraintKindAS;
import org.oslo.ocl20.syntax.ast.contexts.OperationAS;
import org.oslo.ocl20.syntax.ast.contexts.OperationContextDeclAS;
import org.oslo.ocl20.syntax.ast.contexts.PackageDeclarationAS;
import org.oslo.ocl20.syntax.ast.contexts.PropertyContextDeclAS;
import org.oslo.ocl20.syntax.ast.contexts.VariableDeclarationAS;
import org.oslo.ocl20.syntax.ast.expressions.AndExpAS;
import org.oslo.ocl20.syntax.ast.expressions.ArrowSelectionExpAS;
import org.oslo.ocl20.syntax.ast.expressions.AssociationCallExpAS;
import org.oslo.ocl20.syntax.ast.expressions.BooleanLiteralExpAS;
import org.oslo.ocl20.syntax.ast.expressions.CallExpAS;
import org.oslo.ocl20.syntax.ast.expressions.CollectionItemAS;
import org.oslo.ocl20.syntax.ast.expressions.CollectionKindAS;
import org.oslo.ocl20.syntax.ast.expressions.CollectionLiteralExpAS;
import org.oslo.ocl20.syntax.ast.expressions.CollectionRangeAS;
import org.oslo.ocl20.syntax.ast.expressions.DotSelectionExpAS;
import org.oslo.ocl20.syntax.ast.expressions.EnumLiteralExpAS;
import org.oslo.ocl20.syntax.ast.expressions.IfExpAS;
import org.oslo.ocl20.syntax.ast.expressions.ImpliesExpAS;
import org.oslo.ocl20.syntax.ast.expressions.IntegerLiteralExpAS;
import org.oslo.ocl20.syntax.ast.expressions.IterateExpAS;
import org.oslo.ocl20.syntax.ast.expressions.IteratorExpAS;
import org.oslo.ocl20.syntax.ast.expressions.LetExpAS;
import org.oslo.ocl20.syntax.ast.expressions.LoopExpAS;
import org.oslo.ocl20.syntax.ast.expressions.NotExpAS;
import org.oslo.ocl20.syntax.ast.expressions.OclExpressionAS;
import org.oslo.ocl20.syntax.ast.expressions.OclMessageArgAS;
import org.oslo.ocl20.syntax.ast.expressions.OclMessageExpAS;
import org.oslo.ocl20.syntax.ast.expressions.OclMessageKindAS;
import org.oslo.ocl20.syntax.ast.expressions.OperationCallExpAS;
import org.oslo.ocl20.syntax.ast.expressions.OrExpAS;
import org.oslo.ocl20.syntax.ast.expressions.PathNameExpAS;
import org.oslo.ocl20.syntax.ast.expressions.RealLiteralExpAS;
import org.oslo.ocl20.syntax.ast.expressions.StringLiteralExpAS;
import org.oslo.ocl20.syntax.ast.expressions.TupleLiteralExpAS;
import org.oslo.ocl20.syntax.ast.expressions.XorExpAS;
import org.oslo.ocl20.syntax.ast.types.ClassifierAS;
import org.oslo.ocl20.syntax.ast.types.CollectionTypeAS;
import org.oslo.ocl20.syntax.ast.types.TupleTypeAS;
import org.oslo.ocl20.syntax.ast.types.TypeAS;
import uk.ac.kent.cs.kmf.util.ILog;

public class ASTBuilder {
    protected ILog log;
    protected astFactory factory;

    public ASTBuilder(ILog log) {
        this.factory = new astFactory(this.log);
        this.log = log;
    }

    public PackageDeclarationAS buildPackageDeclaration(List path, List contextDecls) {
        PackageDeclarationAS result = this.factory.contexts.createPackageDeclarationAS();
        result.setPathName(path);
        result.setContextDecls(contextDecls);
        return result;
    }

    public PropertyContextDeclAS buildPropertyContextDeclaration(List path, String name, TypeAS type, List constraints) {
        PropertyContextDeclAS res = this.factory.contexts.createPropertyContextDeclAS();
        res.setPathName(path);
        res.setName(name);
        res.setType(type);
        res.setConstraints(constraints);
        return res;
    }

    public ClassifierContextDeclAS buildClassifierContextDeclaration(TypeAS t, List constraints) {
        ClassifierContextDeclAS res = this.factory.contexts.createClassifierContextDeclAS();
        res.setType(t);
        res.setConstraints(constraints);
        return res;
    }

    public ClassifierContextDeclAS buildClassifierContextDeclaration(List path, List constraints) {
        ClassifierContextDeclAS res = this.factory.contexts.createClassifierContextDeclAS();
        res.setPathName(path);
        res.setConstraints(constraints);
        return res;
    }

    public OperationContextDeclAS buildOperationContextDeclaration(OperationAS oper, List constraints) {
        OperationContextDeclAS result = this.factory.contexts.createOperationContextDeclAS();
        result.setOperation(oper);
        result.setConstraints(constraints);
        return result;
    }

    public OperationAS buildOperation(List path, String name, List params, TypeAS type) {
        OperationAS oper = this.factory.contexts.createOperationAS();
        oper.setPathName(path);
        oper.setName(name);
        oper.setParameters(params);
        oper.setType(type);
        return oper;
    }

    public ConstraintAS buildConstraint(ConstraintKindAS kind, String name, OclExpressionAS body, Object varOrOper) {
        ConstraintAS cons = this.factory.contexts.createConstraintAS();
        cons.setKind(kind);
        cons.setName(name);
        cons.setBodyExpression(body);
        if (varOrOper instanceof VariableDeclarationAS) {
            cons.setDefVariable((VariableDeclarationAS)varOrOper);
        } else if (varOrOper instanceof OperationAS) {
            cons.setDefOperation((OperationAS)varOrOper);
        }
        return cons;
    }

    public VariableDeclarationAS buildVariableDeclaration(String name, TypeAS type, OclExpressionAS init) {
        VariableDeclarationAS var = this.factory.contexts.createVariableDeclarationAS();
        var.setName(name);
        var.setType(type);
        var.setInitExp(init);
        return var;
    }

    public ClassifierAS buildPathNameType(List path) {
        ClassifierAS type = this.factory.types.createClassifierAS();
        type.setPathName(path);
        return type;
    }

    public CollectionTypeAS buildCollectionType(CollectionKindAS kind, TypeAS elementType) {
        CollectionTypeAS type = null;
        if (kind == CollectionKindAS.BAG) {
            type = this.factory.types.createBagTypeAS();
            type.setElementType(elementType);
        } else if (kind == CollectionKindAS.COLLECTION) {
            type = this.factory.types.createCollectionTypeAS();
            type.setElementType(elementType);
        } else if (kind == CollectionKindAS.SEQUENCE) {
            type = this.factory.types.createSequenceTypeAS();
            type.setElementType(elementType);
        } else if (kind == CollectionKindAS.SET) {
            type = this.factory.types.createSetTypeAS();
            type.setElementType(elementType);
        } else if (kind == CollectionKindAS.ORDERED_SET) {
            type = this.factory.types.createOrderedSetTypeAS();
            type.setElementType(elementType);
        } else {
            type = null;
        }
        return type;
    }

    public TupleTypeAS buildTupleType(List varList) {
        TupleTypeAS type = this.factory.types.createTupleTypeAS();
        type.setVariableDeclarationList(varList);
        return type;
    }

    public PathNameExpAS buildPathNameExp(List path, Boolean isMarkedPre) {
        PathNameExpAS res = this.factory.expressions.createPathNameExpAS();
        res.setPathName(path);
        res.setIsMarkedPre(isMarkedPre);
        return res;
    }

    public DotSelectionExpAS buildDotSelectionExp(OclExpressionAS exp, String name, Boolean isMarkedPre) {
        DotSelectionExpAS res = this.factory.expressions.createDotSelectionExpAS();
        res.setSource(exp);
        res.setName(name);
        res.setIsMarkedPre(isMarkedPre);
        exp.setParent(res);
        return res;
    }

    public ArrowSelectionExpAS buildArrowSelectionExp(OclExpressionAS exp, String name) {
        ArrowSelectionExpAS res = this.factory.expressions.createArrowSelectionExpAS();
        res.setSource(exp);
        res.setName(name);
        exp.setParent(res);
        return res;
    }

    public OclExpressionAS buildOperationCallExp(String name, OclExpressionAS left, OclExpressionAS right) {
        DotSelectionExpAS source = this.factory.expressions.createDotSelectionExpAS();
        source.setSource(left);
        source.setName(name);
        OperationCallExpAS res = this.factory.expressions.createOperationCallExpAS();
        res.setSource(source);
        res.setArguments(new Vector());
        if (right != null) {
            res.getArguments().add(right);
        }
        left.setParent(res);
        return res;
    }

    public CallExpAS buildOperationCallExp(OclExpressionAS exp, List arguments) {
        OperationCallExpAS res = this.factory.expressions.createOperationCallExpAS();
        res.setSource(exp);
        res.setArguments(arguments);
        exp.setParent(res);
        return res;
    }

    public LoopExpAS buildIteratorCallExp(OclExpressionAS srcArrowExp1, List varList, OclExpressionAS exp2) {
        IteratorExpAS res = this.factory.expressions.createIteratorExpAS();
        res.setSource(srcArrowExp1);
        res.setIterator(varList);
        res.setBody(exp2);
        srcArrowExp1.setParent(res);
        return res;
    }

    public CallExpAS buildAssociationCallExp(OclExpressionAS exp, List arguments, Boolean isMarkedPre) {
        AssociationCallExpAS res = this.factory.expressions.createAssociationCallExpAS();
        res.setSource(exp);
        res.setArguments(arguments);
        res.setIsMarkedPre(isMarkedPre);
        exp.setParent(res);
        return res;
    }

    public OclExpressionAS buildIterateExp(OclExpressionAS source, VariableDeclarationAS iterator, VariableDeclarationAS result, OclExpressionAS body) {
        IterateExpAS res = this.factory.expressions.createIterateExpAS();
        res.setSource(source);
        res.setName("iterate");
        Vector<VariableDeclarationAS> x = new Vector<VariableDeclarationAS>();
        x.add(iterator);
        res.setIterator(x);
        res.setResult(result);
        res.setBody(body);
        source.setParent(res);
        return res;
    }

    public OclExpressionAS buildNotExp(OclExpressionAS left) {
        NotExpAS res = this.factory.expressions.createNotExpAS();
        res.setLeftOperand(left);
        left.setParent(res);
        return res;
    }

    public OclExpressionAS buildOrExp(OclExpressionAS left, OclExpressionAS right) {
        OrExpAS res = this.factory.expressions.createOrExpAS();
        res.setLeftOperand(left);
        res.setRightOperand(right);
        left.setParent(res);
        return res;
    }

    public OclExpressionAS buildAndExp(OclExpressionAS left, OclExpressionAS right) {
        AndExpAS res = this.factory.expressions.createAndExpAS();
        res.setLeftOperand(left);
        res.setRightOperand(right);
        left.setParent(res);
        return res;
    }

    public OclExpressionAS buildXorExp(OclExpressionAS left, OclExpressionAS right) {
        XorExpAS res = this.factory.expressions.createXorExpAS();
        res.setLeftOperand(left);
        res.setRightOperand(right);
        left.setParent(res);
        return res;
    }

    public OclExpressionAS buildImpliesExp(OclExpressionAS left, OclExpressionAS right) {
        ImpliesExpAS res = this.factory.expressions.createImpliesExpAS();
        res.setLeftOperand(left);
        res.setRightOperand(right);
        left.setParent(res);
        return res;
    }

    public OclExpressionAS buildOclMessageExp(OclMessageKindAS kind, OclExpressionAS target, String name, List arguments) {
        OclMessageExpAS res = this.factory.expressions.createOclMessageExpAS();
        res.setKind(kind);
        res.setName(name);
        res.setTarget(target);
        res.setArguments(arguments);
        target.setParent(res);
        return res;
    }

    public OclMessageArgAS buildOclMessageArg(OclExpressionAS exp, TypeAS type) {
        OclMessageArgAS arg = this.factory.expressions.createOclMessageArgAS();
        arg.setExpression(exp);
        arg.setType(type);
        return arg;
    }

    public IfExpAS buildIfExp(OclExpressionAS condition, OclExpressionAS thenExp, OclExpressionAS elseExp) {
        IfExpAS res = this.factory.expressions.createIfExpAS();
        res.setCondition(condition);
        res.setThenExpression(thenExp);
        res.setElseExpression(elseExp);
        return res;
    }

    public LetExpAS buildLetExp(List variables, OclExpressionAS exp) {
        LetExpAS res = this.factory.expressions.createLetExpAS();
        res.setVariables(variables);
        res.setIn(exp);
        return res;
    }

    public EnumLiteralExpAS buildEnumLiteralExp(List path) {
        EnumLiteralExpAS exp = this.factory.expressions.createEnumLiteralExpAS();
        exp.setPathName(path);
        return exp;
    }

    public CollectionLiteralExpAS buildCollectionLiteralExp(CollectionKindAS kind, List parts) {
        CollectionLiteralExpAS exp = this.factory.expressions.createCollectionLiteralExpAS();
        exp.setKind(kind);
        exp.setCollectionParts(parts);
        return exp;
    }

    public CollectionItemAS buildCollectionItem(OclExpressionAS exp) {
        CollectionItemAS item = this.factory.expressions.createCollectionItemAS();
        item.setItem(exp);
        return item;
    }

    public CollectionRangeAS buildCollectionRange(OclExpressionAS first, OclExpressionAS last) {
        CollectionRangeAS exp = this.factory.expressions.createCollectionRangeAS();
        exp.setFirst(first);
        exp.setLast(last);
        return exp;
    }

    public BooleanLiteralExpAS buildBooleanLiteralExp(String value) {
        BooleanLiteralExpAS exp = this.factory.expressions.createBooleanLiteralExpAS();
        if (value != null && !value.equals("undefined")) {
            exp.setValue(Boolean.valueOf(value));
        } else {
            exp.setValue(null);
        }
        return exp;
    }

    public IntegerLiteralExpAS buildIntegerLiteralExp(String value) {
        IntegerLiteralExpAS exp = this.factory.expressions.createIntegerLiteralExpAS();
        exp.setValue(Integer.valueOf(value));
        return exp;
    }

    public RealLiteralExpAS buildRealLiteralExp(String value) {
        RealLiteralExpAS exp = this.factory.expressions.createRealLiteralExpAS();
        exp.setValue(Double.valueOf(value));
        return exp;
    }

    public StringLiteralExpAS buildStringLiteralExp(String value) {
        StringLiteralExpAS exp = this.factory.expressions.createStringLiteralExpAS();
        exp.setValue(value.substring(1, value.length() - 1));
        return exp;
    }

    public TupleLiteralExpAS buildTupleLiteralExp(List seq) {
        TupleLiteralExpAS exp = this.factory.expressions.createTupleLiteralExpAS();
        exp.setTupleParts(seq);
        return exp;
    }
}

