/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.synthesis;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.semantics.model.contexts.Constraint;
import org.oslo.ocl20.semantics.model.contexts.ContextDeclaration;
import org.oslo.ocl20.semantics.model.expressions.OclExpression;
import org.oslo.ocl20.standard.lib.OclAny;
import org.oslo.ocl20.synthesis.OclCodeGenerator;
import org.oslo.ocl20.synthesis.OclCodeGeneratorVisitorImpl;
import uk.ac.kent.cs.kmf.util.OutputStreamLog;

public class OclCodeGeneratorImpl
implements OclCodeGenerator {
    OclProcessor processor;
    OclCodeGeneratorVisitorImpl generator;

    public OclCodeGeneratorImpl(OclProcessor p, OclCodeGeneratorVisitorImpl g) {
        this.processor = p;
        this.generator = g;
    }

    @Override
    public OclAny generate(OclExpression exp, String indent, OclProcessor processor) {
        StringWriter buffer = new StringWriter();
        PrintWriter output = new PrintWriter(buffer);
        this.generator.output = output;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("output", output);
        data.put("indent", indent);
        data.put("log", new OutputStreamLog((OutputStream)System.out));
        OclAny result = (OclAny)exp.accept(this.generator, data);
        return result;
    }

    @Override
    public OclAny generate(Constraint con, String indent, OclProcessor processor) {
        return this.generate(con.getBodyExpression(), indent, processor);
    }

    @Override
    public List generate(ContextDeclaration con, String indent, OclProcessor processor) {
        Vector<OclAny> result = new Vector<OclAny>();
        Iterator i = con.getConstraint().iterator();
        while (i.hasNext()) {
            result.add(this.generate((Constraint)i.next(), indent, processor));
        }
        return result;
    }
}

