/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.synthesis;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.generation.lib.Impl;
import org.oslo.ocl20.generation.lib.OclAnyModelElementImpl;
import org.oslo.ocl20.generation.lib.OclTupleImpl;
import org.oslo.ocl20.generation.lib.StdLibGenerationAdapterImpl;
import org.oslo.ocl20.semantics.SemanticsVisitor;
import org.oslo.ocl20.semantics.SemanticsVisitor$Class;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.bridge.DataType;
import org.oslo.ocl20.semantics.bridge.EnumLiteral;
import org.oslo.ocl20.semantics.bridge.EnumerationType;
import org.oslo.ocl20.semantics.bridge.OclModelElementType;
import org.oslo.ocl20.semantics.bridge.Operation;
import org.oslo.ocl20.semantics.bridge.Primitive;
import org.oslo.ocl20.semantics.bridge.Property;
import org.oslo.ocl20.semantics.model.contexts.DefinedOperation;
import org.oslo.ocl20.semantics.model.contexts.DefinedProperty;
import org.oslo.ocl20.semantics.model.expressions.BooleanLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.BooleanLiteralExp$Class;
import org.oslo.ocl20.semantics.model.expressions.CollectionItem;
import org.oslo.ocl20.semantics.model.expressions.CollectionKind;
import org.oslo.ocl20.semantics.model.expressions.CollectionKind$Class;
import org.oslo.ocl20.semantics.model.expressions.CollectionLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.CollectionLiteralExp$Class;
import org.oslo.ocl20.semantics.model.expressions.CollectionLiteralPart;
import org.oslo.ocl20.semantics.model.expressions.CollectionRange;
import org.oslo.ocl20.semantics.model.expressions.EnumLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.IfExp;
import org.oslo.ocl20.semantics.model.expressions.IfExp$Class;
import org.oslo.ocl20.semantics.model.expressions.IntegerLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.IntegerLiteralExp$Class;
import org.oslo.ocl20.semantics.model.expressions.IterateExp;
import org.oslo.ocl20.semantics.model.expressions.IterateExp$Class;
import org.oslo.ocl20.semantics.model.expressions.IteratorExp;
import org.oslo.ocl20.semantics.model.expressions.IteratorExp$Class;
import org.oslo.ocl20.semantics.model.expressions.LetExp;
import org.oslo.ocl20.semantics.model.expressions.LetExp$Class;
import org.oslo.ocl20.semantics.model.expressions.OclExpression;
import org.oslo.ocl20.semantics.model.expressions.OperationCallExp;
import org.oslo.ocl20.semantics.model.expressions.OperationCallExp$Class;
import org.oslo.ocl20.semantics.model.expressions.PropertyCallExp;
import org.oslo.ocl20.semantics.model.expressions.PropertyCallExp$Class;
import org.oslo.ocl20.semantics.model.expressions.RealLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.StringLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.TupleLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.TupleLiteralExp$Class;
import org.oslo.ocl20.semantics.model.expressions.TypeLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.UndefinedLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.VariableDeclaration;
import org.oslo.ocl20.semantics.model.expressions.VariableDeclaration$Class;
import org.oslo.ocl20.semantics.model.expressions.VariableExp;
import org.oslo.ocl20.semantics.model.expressions.VariableExp$Class;
import org.oslo.ocl20.semantics.model.types.BagType;
import org.oslo.ocl20.semantics.model.types.BooleanType;
import org.oslo.ocl20.semantics.model.types.CollectionType;
import org.oslo.ocl20.semantics.model.types.IntegerType;
import org.oslo.ocl20.semantics.model.types.OclAnyType;
import org.oslo.ocl20.semantics.model.types.OclMessageType;
import org.oslo.ocl20.semantics.model.types.OrderedSetType;
import org.oslo.ocl20.semantics.model.types.RealType;
import org.oslo.ocl20.semantics.model.types.SequenceType;
import org.oslo.ocl20.semantics.model.types.SetType;
import org.oslo.ocl20.semantics.model.types.StringType;
import org.oslo.ocl20.semantics.model.types.TupleType;
import org.oslo.ocl20.semantics.model.types.VoidType;
import org.oslo.ocl20.standard.lib.OclAny;
import org.oslo.ocl20.standard.lib.OclBag;
import org.oslo.ocl20.standard.lib.OclBoolean;
import org.oslo.ocl20.standard.lib.OclCollection;
import org.oslo.ocl20.standard.lib.OclInteger;
import org.oslo.ocl20.standard.lib.OclOrderedSet;
import org.oslo.ocl20.standard.lib.OclReal;
import org.oslo.ocl20.standard.lib.OclSequence;
import org.oslo.ocl20.standard.lib.OclSet;
import org.oslo.ocl20.standard.lib.OclString;
import org.oslo.ocl20.standard.lib.OclTuple;
import org.oslo.ocl20.standard.lib.OclType;
import org.oslo.ocl20.standard.types.BagTypeImpl;
import org.oslo.ocl20.standard.types.BooleanTypeImpl;
import org.oslo.ocl20.standard.types.CollectionTypeImpl;
import org.oslo.ocl20.standard.types.IntegerTypeImpl;
import org.oslo.ocl20.standard.types.OclAnyTypeImpl;
import org.oslo.ocl20.standard.types.OrderedSetTypeImpl;
import org.oslo.ocl20.standard.types.RealTypeImpl;
import org.oslo.ocl20.standard.types.SequenceTypeImpl;
import org.oslo.ocl20.standard.types.SetTypeImpl;
import org.oslo.ocl20.standard.types.StringTypeImpl;
import org.oslo.ocl20.standard.types.VoidTypeImpl;
import org.oslo.ocl20.syntax.parser.ErrorManager;
import org.oslo.ocl20.synthesis.RuntimeEnvironment;
import uk.ac.kent.cs.kmf.util.ILog;

public class OclCodeGeneratorVisitorImpl
extends SemanticsVisitor$Class
implements SemanticsVisitor {
    protected OclProcessor processor = null;
    protected static String tab = "    ";
    protected Object output;
    protected static Set basicOclTypes = new LinkedHashSet();
    protected static Map needsWrapMap;
    protected static Map getJavaTypeMap;
    protected static Map getOclTypeMap;
    protected static Map nameMap;

    static {
        basicOclTypes.add(BooleanType.class);
        basicOclTypes.add(IntegerType.class);
        basicOclTypes.add(RealType.class);
        basicOclTypes.add(StringType.class);
        basicOclTypes.add(CollectionType.class);
        basicOclTypes.add(BagType.class);
        basicOclTypes.add(SetType.class);
        basicOclTypes.add(SequenceType.class);
        basicOclTypes.add(OrderedSetType.class);
        basicOclTypes.add(OclAnyType.class);
        basicOclTypes.add(VoidType.class);
        basicOclTypes.add(BooleanTypeImpl.class);
        basicOclTypes.add(IntegerTypeImpl.class);
        basicOclTypes.add(RealTypeImpl.class);
        basicOclTypes.add(StringTypeImpl.class);
        basicOclTypes.add(CollectionTypeImpl.class);
        basicOclTypes.add(BagTypeImpl.class);
        basicOclTypes.add(SetTypeImpl.class);
        basicOclTypes.add(SequenceTypeImpl.class);
        basicOclTypes.add(OrderedSetTypeImpl.class);
        basicOclTypes.add(OclAnyTypeImpl.class);
        basicOclTypes.add(VoidTypeImpl.class);
        needsWrapMap = new HashMap();
        needsWrapMap.put(OclCollection.class + "-sum", Boolean.TRUE);
        needsWrapMap.put(OclBag.class + "-sum", Boolean.TRUE);
        needsWrapMap.put(OclSet.class + "-sum", Boolean.TRUE);
        needsWrapMap.put(OclSequence.class + "-sum", Boolean.TRUE);
        needsWrapMap.put(OclOrderedSet.class + "-sum", Boolean.TRUE);
        needsWrapMap.put(OclSequence.class + "-at", Boolean.TRUE);
        needsWrapMap.put(OclSequence.class + "-first", Boolean.TRUE);
        needsWrapMap.put(OclSequence.class + "-last", Boolean.TRUE);
        needsWrapMap.put(OclOrderedSet.class + "-at", Boolean.TRUE);
        needsWrapMap.put(OclOrderedSet.class + "-first", Boolean.TRUE);
        needsWrapMap.put(OclOrderedSet.class + "-last", Boolean.TRUE);
        getJavaTypeMap = new HashMap();
        getJavaTypeMap.put("IOclBoolean", Boolean.class);
        getJavaTypeMap.put("IOclInteger", Integer.class);
        getJavaTypeMap.put("IOclReal", Double.class);
        getJavaTypeMap.put("IOclString", String.class);
        getJavaTypeMap.put("IOclBag", Collection.class);
        getJavaTypeMap.put("IOclSet", Collection.class);
        getJavaTypeMap.put("IOclOrderedSet", Collection.class);
        getJavaTypeMap.put("IOclSequence", Collection.class);
        getJavaTypeMap.put("OclBoolean", Boolean.class);
        getJavaTypeMap.put("OclInteger", Integer.class);
        getJavaTypeMap.put("OclReal", Double.class);
        getJavaTypeMap.put("OclString", String.class);
        getJavaTypeMap.put("OclBag", Collection.class);
        getJavaTypeMap.put("OclSet", Collection.class);
        getJavaTypeMap.put("OclOrderedSet", Collection.class);
        getJavaTypeMap.put("OclSequence", Collection.class);
        getJavaTypeMap.put("OclBooleanImpl", Boolean.class);
        getJavaTypeMap.put("OclIntegerImpl", Integer.class);
        getJavaTypeMap.put("OclRealImpl", Double.class);
        getJavaTypeMap.put("OclStringImpl", String.class);
        getJavaTypeMap.put("OclBagImpl", Collection.class);
        getJavaTypeMap.put("OclSetImpl", Collection.class);
        getJavaTypeMap.put("OclOrderedSetImpl", Collection.class);
        getJavaTypeMap.put("OclSequenceImpl", Collection.class);
        getOclTypeMap = new HashMap();
        getOclTypeMap.put("OclBoolean", OclBoolean.class);
        getOclTypeMap.put("OclInteger", OclInteger.class);
        getOclTypeMap.put("OclReal", OclReal.class);
        getOclTypeMap.put("OclString", OclString.class);
        getOclTypeMap.put("OclBag", OclBag.class);
        getOclTypeMap.put("OclSet", OclSet.class);
        getOclTypeMap.put("OclOrderedSet", OclOrderedSet.class);
        getOclTypeMap.put("OclSequence", OclSequence.class);
        nameMap = new HashMap();
        nameMap.put("=", "equalTo");
        nameMap.put("<>", "notEqualTo");
        nameMap.put("+", "add");
        nameMap.put("-", "subtract");
        nameMap.put("*", "multiply");
        nameMap.put("/", "divide");
        nameMap.put("<", "lessThan");
        nameMap.put(">", "greaterThan");
        nameMap.put("<=", "lessThanOrEqualTo");
        nameMap.put(">=", "greaterThanOrEqualTo");
    }

    public OclCodeGeneratorVisitorImpl(Object output, OclProcessor proc) {
        this.output = output;
        this.processor = proc;
    }

    public Object getOutput() {
        return this.output;
    }

    public void setOutput(Object output) {
        this.output = output;
    }

    public void println(String indent, String text) {
        if (this.output instanceof PrintStream) {
            ((PrintStream)this.output).println(String.valueOf(indent) + text);
        } else if (this.output instanceof PrintWriter) {
            ((PrintWriter)this.output).println(String.valueOf(indent) + text);
        } else if (this.output instanceof ILog) {
            ((ILog)this.output).reportMessage(String.valueOf(indent) + text);
        } else if (this.output instanceof StringBuffer) {
            ((StringBuffer)this.output).append(String.valueOf(indent) + text + "\n");
        }
    }

    public static String newTempVar() {
        return StdLibGenerationAdapterImpl.newTempVar();
    }

    protected static boolean isBasicOclType(Classifier sourceType) {
        return basicOclTypes.contains(sourceType.getClass());
    }

    protected static boolean needsOclWrapping(Classifier sourceType, String operName) {
        if (OclCodeGeneratorVisitorImpl.isBasicOclType(sourceType)) {
            return needsWrapMap.get(sourceType.getClass() + "-" + operName) != null;
        }
        return true;
    }

    protected static String getAdapterMethodName(Classifier type) {
        if (type instanceof BooleanType) {
            return "Boolean";
        }
        if (type instanceof IntegerType) {
            return "Integer";
        }
        if (type instanceof RealType) {
            return "Real";
        }
        if (type instanceof StringType) {
            return "String";
        }
        if (type instanceof BagType) {
            return "Bag";
        }
        if (type instanceof OrderedSetType) {
            return "OrderedSet";
        }
        if (type instanceof SetType) {
            return "Set";
        }
        if (type instanceof SequenceType) {
            return "Sequence";
        }
        if (type instanceof VoidType) {
            return "Undefined";
        }
        if (type instanceof TupleType) {
            return "Tuple";
        }
        if (type instanceof OclModelElementType) {
            return "OclAnyModelElement";
        }
        return null;
    }

    protected static Class getJavaType(String name, Object value) {
        Class type = (Class)getJavaTypeMap.get(name);
        if (type == null) {
            return value.getClass();
        }
        return type;
    }

    protected static Class getOclType(String name, Object value) {
        Class type = (Class)getOclTypeMap.get(name);
        if (type == null) {
            return value.getClass();
        }
        return type;
    }

    protected static String getFunctionName(Operation op) {
        if (op == null) {
            return null;
        }
        String name = op.getName();
        Classifier type = op.getReturnType();
        int numParams = 0;
        if (op.getParameterTypes() != null) {
            numParams = op.getParameterTypes().size();
        }
        if (name.equals("abs") && numParams == 0 && type instanceof IntegerType) {
            return "iabs";
        }
        if (name.equals("-") && numParams == 0) {
            return String.valueOf(type instanceof IntegerType ? "i" : "") + "negate";
        }
        String result = (String)nameMap.get(name);
        if (result == null) {
            return name;
        }
        return result;
    }

    protected Object getOclObject(Classifier resultType, String expr) {
        Object[] valArr;
        Class[] typeArr;
        String adapterName = OclCodeGeneratorVisitorImpl.getAdapterMethodName(resultType);
        if (resultType instanceof CollectionType) {
            Classifier elemType = ((CollectionType)resultType).getElementType();
            typeArr = new Class[]{Classifier.class, String.class};
            valArr = new Object[]{elemType, expr};
        } else {
            typeArr = new Class[]{String.class};
            valArr = new Object[]{expr};
        }
        try {
            Method m = this.getMethod(this.processor.getStdLibGenerationAdapter(), adapterName, typeArr);
            return m.invoke((Object)this.processor.getStdLibGenerationAdapter(), valArr);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Method getMethod(Object source, String operName, Class[] types) throws Exception {
        Method method = null;
        try {
            method = source.getClass().getMethod(operName, types);
        }
        catch (Exception exception) {}
        if (method == null) {
            Method[] methods = source.getClass().getMethods();
            int i = 0;
            while (i < methods.length) {
                String methodName = methods[i].getName();
                Class<?>[] argTypes = methods[i].getParameterTypes();
                if (methodName.equals(operName) && types.length == argTypes.length) {
                    boolean found = true;
                    int j = 0;
                    while (j < types.length) {
                        if (!argTypes[j].isAssignableFrom(types[j])) {
                            found = false;
                            break;
                        }
                        ++j;
                    }
                    if (found) {
                        return methods[i];
                    }
                }
                ++i;
            }
        }
        return method;
    }

    protected Method getMethod(String className, String operName, Class[] types) throws Exception {
        return Class.forName(className).getMethod(operName, types);
    }

    @Override
    public Object visit(VariableDeclaration host, Object data) {
        String cfr_ignored_0 = (String)((Map)data).get("indent");
        if (host.getName() == null || host.getName().equals("")) {
            host.setName(OclCodeGeneratorVisitorImpl.newTempVar());
        }
        OclAny result = ((StdLibGenerationAdapterImpl)this.processor.getStdLibGenerationAdapter()).OclAny(host.getType(), host.getName());
        String text = String.valueOf(OclCodeGeneratorVisitorImpl.unBoxedTypeName(host.getType())) + " " + result;
        if (host.getInitExpression() != null) {
            OclAny init = (OclAny)host.getInitExpression().accept(this, data);
            text = String.valueOf(text) + " = " + init;
            ((Impl)((Object)result)).setInitialisation(String.valueOf(((Impl)((Object)result)).getInitialisation()) + ((Impl)((Object)init)).getInitialisation());
        }
        text = String.valueOf(text) + ";\n";
        ((Impl)((Object)result)).setInitialisation(String.valueOf(((Impl)((Object)result)).getInitialisation()) + text);
        return result;
    }

    @Override
    public Object visit(TypeLiteralExp host, Object data) {
        return this.processor.getStdLibGenerationAdapter().Type(host.getLiteralType());
    }

    @Override
    public Object visit(BooleanLiteralExp host, Object data) {
        return this.processor.getStdLibGenerationAdapter().Boolean(host.getBooleanSymbol());
    }

    @Override
    public Object visit(UndefinedLiteralExp host, Object data) {
        return this.processor.getStdLibGenerationAdapter().Undefined();
    }

    @Override
    public Object visit(IntegerLiteralExp host, Object data) {
        return this.processor.getStdLibGenerationAdapter().Integer(host.getIntegerSymbol());
    }

    @Override
    public Object visit(RealLiteralExp host, Object data) {
        return this.processor.getStdLibGenerationAdapter().Real(host.getRealSymbol());
    }

    @Override
    public Object visit(StringLiteralExp host, Object data) {
        return this.processor.getStdLibGenerationAdapter().String("\"" + host.getStringSymbol() + "\"");
    }

    @Override
    public Object visit(EnumerationType host, Object data) {
        return host.getName();
    }

    @Override
    public Object visit(EnumLiteralExp host, Object data) {
        return this.processor.getModelGenerationAdapter().getEnumLiteralReference(host.getReferredEnumLiteral());
    }

    @Override
    public Object visit(CollectionLiteralExp host, Object data) {
        Classifier elemType;
        OclCollection col = null;
        Classifier eT = elemType = ((CollectionType)host.getType()).getElementType();
        CollectionKind kind = host.getKind();
        if (kind == CollectionKind$Class.BAG) {
            col = this.processor.getStdLibGenerationAdapter().Bag(eT);
        } else if (kind == CollectionKind$Class.ORDERED_SET) {
            col = this.processor.getStdLibGenerationAdapter().OrderedSet(eT);
        } else if (kind == CollectionKind$Class.SEQUENCE) {
            col = this.processor.getStdLibGenerationAdapter().Sequence(eT);
        } else if (kind == CollectionKind$Class.SET) {
            col = this.processor.getStdLibGenerationAdapter().Set(eT);
        }
        for (CollectionLiteralPart part : host.getParts()) {
            if (part instanceof CollectionItem) {
                OclExpression expPart;
                if (part == null || (expPart = ((CollectionItem)part).getItem()) == null || expPart.getType() instanceof VoidType) continue;
                OclAny prt = (OclAny)expPart.accept(this, data);
                OclAny p = ((Impl)((Object)prt)).wrappedWithExceptionHandler(eT);
                ((Impl)((Object)col)).setInitialisation(String.valueOf(((Impl)((Object)col)).getInitialisation()) + ((Impl)((Object)p)).getInitialisation());
                ((Impl)((Object)col)).setInitialisation(String.valueOf(((Impl)((Object)col)).getInitialisation()) + "if (" + p + "!=null) " + col + ".add(" + p + ");\n");
                continue;
            }
            OclExpression first = ((CollectionRange)part).getFirst();
            OclExpression last = ((CollectionRange)part).getLast();
            Classifier firstType = first.getType();
            Classifier lastType = last.getType();
            if (!(firstType instanceof IntegerType) || !(lastType instanceof IntegerType)) continue;
            OclAny firstValue = (OclAny)first.accept(this, data);
            OclAny lastValue = (OclAny)last.accept(this, data);
            String iTemp = OclCodeGeneratorVisitorImpl.newTempVar();
            String initStr = "";
            initStr = String.valueOf(initStr) + "for(int " + iTemp + "=" + firstValue + "; " + iTemp + "<=" + lastValue + "; " + iTemp + "++) {\n";
            initStr = String.valueOf(initStr) + "  " + col + ".add(new Integer(" + iTemp + "));\n";
            initStr = String.valueOf(initStr) + "}\n";
            ((Impl)((Object)col)).setInitialisation(String.valueOf(((Impl)((Object)col)).getInitialisation()) + initStr);
        }
        return col;
    }

    @Override
    public Object visit(TupleLiteralExp host, Object data) {
        RuntimeEnvironment cfr_ignored_0 = (RuntimeEnvironment)((Map)data).get("env");
        Vector<String> keys = new Vector<String>();
        Vector<Classifier> types = new Vector<Classifier>();
        Vector<OclAny> values = new Vector<OclAny>();
        String init = "";
        for (VariableDeclaration var : host.getTuplePart()) {
            if (var == null) continue;
            String varName = var.getName();
            OclAny value = null;
            OclExpression initValue = var.getInitExpression();
            if (initValue != null) {
                value = (OclAny)initValue.accept(this, data);
            }
            keys.add(varName);
            types.add(var.getType());
            values.add(value);
        }
        TupleType tt = this.processor.getTypeFactory().buildTupleType(keys.toArray(new String[0]), types.toArray(new Classifier[0]));
        OclTupleImpl result = (OclTupleImpl)this.processor.getStdLibGenerationAdapter().Tuple(tt, values.toArray(new OclAny[0]));
        result.setInitialisation(String.valueOf(init) + result.getInitialisation());
        return result;
    }

    @Override
    public Object visit(OperationCallExp host, Object data) {
        Object source;
        RuntimeEnvironment cfr_ignored_0 = (RuntimeEnvironment)((Map)data).get("env");
        ILog log = (ILog)((Map)data).get("log");
        Vector<Object> args = new Vector<Object>();
        Vector<Classifier> types = new Vector<Classifier>();
        for (OclExpression arg : host.getArguments()) {
            Classifier type = arg.getType();
            Object value = null;
            if (arg != null) {
                value = arg.accept(this, data);
            }
            types.add(type);
            args.add(value);
        }
        Operation op = host.getReferredOperation();
        if (op == null) {
            ErrorManager.reportFatalError(log, null, "no referred Operation in " + host);
            return null;
        }
        if (op instanceof DefinedOperation) {
            source = (OclAny)host.getSource().accept(this, data);
            String pRef = this.processor.getModelGenerationAdapter().getDefinedOperationReference((OclAny)source, (DefinedOperation)op, args);
            OclAny result = null;
            result = ((StdLibGenerationAdapterImpl)this.processor.getStdLibGenerationAdapter()).OclAny(host.getType(), pRef);
            String init = "";
            for (OclAny oclAny : args) {
                init = String.valueOf(init) + ((Impl)((Object)oclAny)).getInitialisation();
            }
            ((Impl)((Object)result)).setInitialisation(String.valueOf(init) + ((Impl)source).getInitialisation() + ((Impl)((Object)result)).getInitialisation());
            return result;
        }
        source = host.getSource().accept(this, data);
        Classifier sourceType = host.getSource().getType();
        String operName = OclCodeGeneratorVisitorImpl.getFunctionName(host.getReferredOperation());
        if (operName.equals("_default") && sourceType instanceof VoidType) {
            types = new Vector();
        }
        Object result = null;
        Operation declaredOp = this.processor.getTypeFactory().buildOclAnyType().lookupOperation(host.getReferredOperation().getName(), types);
        result = sourceType instanceof OclAnyType && !(sourceType instanceof OclModelElementType) ? this.invokeOclLibOperation(sourceType, source, operName, types, args, log) : (sourceType instanceof TupleType ? this.invokeOclLibOperation(sourceType, source, operName, types, args, log) : (declaredOp != null ? this.invokeOclLibOperation(sourceType, source, operName, types, args, log) : (sourceType instanceof VoidType ? this.invokeOclLibOperation(sourceType, source, operName, types, args, log) : (sourceType instanceof EnumerationType ? this.invokeEnumerationOperation(sourceType, source, operName, types, args) : this.invokeModelOperation(host.getType(), source, operName, types, args, log)))));
        if (result == null) {
            return this.processor.getStdLibGenerationAdapter().Undefined();
        }
        return result;
    }

    protected Object invokeModelOperation(Classifier retType, Object source, String operName, List javaTypes, List args, ILog log) {
        String result = null;
        try {
            String argStr = "";
            Iterator i = args.iterator();
            while (i.hasNext()) {
                argStr = String.valueOf(argStr) + i.next();
                if (!i.hasNext()) continue;
                argStr = String.valueOf(argStr) + ", ";
            }
            result = source + "." + operName + "(" + argStr + ")";
        }
        catch (Exception e) {
            e.printStackTrace();
            result = "/* error in 'invokeModelOperation' " + e + " */";
        }
        return this.getOclObject(retType, result);
    }

    protected Object invokeOclLibOperation(Classifier sourceType, Object source, String operName, List oclTypes, List args, ILog log) {
        Object result = null;
        Vector<Class> types = new Vector<Class>();
        for (Classifier c : oclTypes) {
            types.add(c.getImplClass());
        }
        try {
            Method oper = this.getMethod(source, operName, types.toArray(new Class[0]));
            if (source != null) {
                if (oper != null) {
                    result = oper.invoke(source, args.toArray());
                } else {
                    log.reportError("Operation " + operName + types + " not found on object " + source);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    protected Object invokeEnumerationOperation(Classifier sourceType, Object source, String operName, List oclTypes, List args) {
        Object result = null;
        Vector<Class> types = new Vector<Class>();
        for (DataType c : oclTypes) {
            types.add(c.getImplClass());
        }
        try {
            Method oper;
            if (operName.equals("equalTo")) {
                if (sourceType instanceof OclModelElementType) {
                    result = this.processor.getModelGenerationAdapter().OclModelElement_equalTo((OclAny)source, (OclAny)args.get(0));
                } else if (sourceType instanceof EnumerationType) {
                    result = this.processor.getModelGenerationAdapter().EnumLiteral_equalTo(source, args.get(0));
                } else if (source != null) {
                    oper = this.getMethod(source, operName, types.toArray(new Class[0]));
                    result = oper.invoke(source, args.toArray());
                }
            } else if (operName.equals("notEqualTo")) {
                if (sourceType instanceof OclModelElementType) {
                    result = this.processor.getModelGenerationAdapter().OclModelElement_equalTo((OclAny)source, (OclAny)args.get(0)).not();
                } else if (sourceType instanceof EnumerationType) {
                    result = this.processor.getModelGenerationAdapter().EnumLiteral_equalTo(source, args.get(0)).not();
                } else if (source != null) {
                    oper = this.getMethod(source, operName, types.toArray(new Class[0]));
                    result = oper.invoke(source, args.toArray());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    protected Object invokeOclAnyOperation(Classifier sourceType, Object source, String operName, List oclTypes, List args) {
        Object result = null;
        Vector<Class> types = new Vector<Class>();
        for (DataType c : oclTypes) {
            types.add(c.getImplClass());
        }
        try {
            Method oper;
            if (operName.equals("equalTo")) {
                if (source != null) {
                    oper = this.getMethod(source, operName, types.toArray(new Class[0]));
                    result = oper.invoke(source, args.toArray());
                }
            } else if (operName.equals("notEqualTo")) {
                if (sourceType instanceof OclModelElementType) {
                    result = this.processor.getModelGenerationAdapter().OclModelElement_equalTo((OclAny)source, (OclAny)args.get(0)).not();
                } else if (sourceType instanceof EnumerationType) {
                    result = this.processor.getModelGenerationAdapter().EnumLiteral_equalTo((OclAny)source, (OclAny)args.get(0)).not();
                } else if (source != null) {
                    oper = this.getMethod(source, operName, types.toArray(new Class[0]));
                    result = oper.invoke(source, args.toArray());
                }
            } else if (operName.equals("oclIsNew")) {
                if (sourceType instanceof OclModelElementType) {
                    result = this.processor.getModelGenerationAdapter().OclModelElement_oclIsNew((OclAny)source);
                } else if (sourceType instanceof EnumerationType) {
                    result = this.processor.getModelGenerationAdapter().EnumLiteral_oclIsNew(source);
                } else if (source != null) {
                    oper = this.getMethod(source, operName, types.toArray(new Class[0]));
                    result = oper.invoke(source, args.toArray());
                }
            } else if (operName.equals("oclIsUndefined")) {
                oper = this.getMethod(source, operName, types.toArray(new Class[0]));
                result = oper.invoke(source, args.toArray());
            } else if (operName.equals("oclAsType")) {
                if (sourceType instanceof OclModelElementType) {
                    result = this.processor.getModelGenerationAdapter().OclModelElement_oclAsType((OclAny)source, (OclType)args.get(0));
                } else if (sourceType instanceof EnumerationType) {
                    result = this.processor.getModelGenerationAdapter().EnumLiteral_oclAsType(source, (OclType)args.get(0));
                } else if (source != null) {
                    oper = this.getMethod(source, operName, types.toArray(new Class[0]));
                    result = oper.invoke(source, args.toArray());
                }
            } else if (operName.equals("oclIsKindOf")) {
                if (sourceType instanceof OclModelElementType) {
                    result = this.processor.getModelGenerationAdapter().OclModelElement_oclIsKindOf((OclAny)source, (OclType)args.get(0));
                } else if (sourceType instanceof EnumerationType) {
                    result = this.processor.getModelGenerationAdapter().EnumLiteral_oclIsKindOf(source, (OclType)args.get(0));
                } else if (source != null) {
                    oper = this.getMethod(source, operName, types.toArray(new Class[0]));
                    result = oper.invoke(source, args.toArray());
                }
            } else if (operName.equals("allInstances")) {
                if (sourceType instanceof OclModelElementType) {
                    result = this.processor.getStdLibAdapter().Set(sourceType, this.processor.getModelGenerationAdapter().OclModelElement_allInstances((OclAny)source));
                } else if (sourceType instanceof EnumerationType) {
                    result = this.processor.getStdLibAdapter().Set(sourceType, this.processor.getModelGenerationAdapter().EnumLiteral_allInstances(source));
                } else if (source != null) {
                    oper = this.getMethod(source, operName, types.toArray(new Class[0]));
                    result = oper.invoke(source, args.toArray());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public Object visit(PropertyCallExp host, Object data) {
        Property prop = host.getReferredProperty();
        if (prop instanceof EnumLiteral) {
            EnumLiteral eLit = (EnumLiteral)host.getReferredProperty();
            String resultStr = this.processor.getModelGenerationAdapter().getEnumLiteralReference(eLit);
            OclAnyModelElementImpl result = (OclAnyModelElementImpl)((Object)this.processor.getStdLibGenerationAdapter().Enumeration(eLit.getType(), resultStr));
            return result;
        }
        if (prop instanceof DefinedProperty) {
            OclAny source = (OclAny)host.getSource().accept(this, data);
            String pRef = this.processor.getModelGenerationAdapter().getDefinedPropertyReference(source, (DefinedProperty)prop);
            OclAny result = null;
            result = ((StdLibGenerationAdapterImpl)this.processor.getStdLibGenerationAdapter()).OclAny(host.getType(), pRef);
            ((Impl)((Object)result)).setInitialisation(String.valueOf(((Impl)((Object)source)).getInitialisation()) + ((Impl)((Object)result)).getInitialisation());
            return result;
        }
        OclAny source = (OclAny)host.getSource().accept(this, data);
        host.getSource().getType();
        if (source instanceof OclTuple) {
            OclString pname = this.processor.getStdLibGenerationAdapter().String(host.getReferredProperty().getName());
            return ((OclTuple)source).property(pname);
        }
        String operName = this.processor.getModelGenerationAdapter().getGetterName(host.getReferredProperty().getName());
        String resultStr = source.asJavaObject() + "." + operName + "()";
        OclAny result = null;
        result = host.getType() instanceof OclModelElementType ? (OclAnyModelElementImpl)this.processor.getStdLibGenerationAdapter().OclAnyModelElement(host.getType(), resultStr) : (host.getType() instanceof EnumerationType ? (OclAnyModelElementImpl)((Object)this.processor.getStdLibGenerationAdapter().Enumeration(host.getType(), resultStr)) : (OclAny)this.getOclObject(host.getType(), resultStr));
        ((Impl)((Object)result)).setInitialisation(String.valueOf(((Impl)((Object)source)).getInitialisation()) + ((Impl)((Object)result)).getInitialisation());
        return result;
    }

    protected Map computeIteratorAttributes(OclExpression source, VariableDeclaration var, Map data) {
        String cfr_ignored_0 = (String)data.get("indent");
        String name = null;
        String type = null;
        String value = null;
        if (var != null) {
            name = var.getName();
            var.getType();
            Classifier elementType = ((CollectionType)source.getType()).getElementType();
            type = (String)elementType.accept(this, data);
            if (var.getInitExpression() != null) {
                value = (String)var.getInitExpression().accept(this, data);
            }
        } else {
            name = OclCodeGeneratorVisitorImpl.newTempVar();
            type = (String)((CollectionType)source.getType()).getElementType().accept(this, data);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("name", name);
        result.put("type", type);
        result.put("value", value);
        return result;
    }

    CollectionLiteralExp getNewCollLiteral(Classifier cls) {
        if (cls instanceof OrderedSetType) {
            return new CollectionLiteralExp$Class("", Boolean.FALSE, CollectionKind$Class.ORDERED_SET);
        }
        if (cls instanceof SetType) {
            return new CollectionLiteralExp$Class("", Boolean.FALSE, CollectionKind$Class.SET);
        }
        if (cls instanceof BagType) {
            return new CollectionLiteralExp$Class("", Boolean.FALSE, CollectionKind$Class.BAG);
        }
        if (cls instanceof SequenceType) {
            return new CollectionLiteralExp$Class("", Boolean.FALSE, CollectionKind$Class.SEQUENCE);
        }
        return null;
    }

    protected OclAny exists(IteratorExp host, Set itVars, OclExpression body, Map data) {
        VariableDeclaration$Class resVar = new VariableDeclaration$Class("result$" + OclCodeGeneratorVisitorImpl.newTempVar());
        resVar.setType(this.processor.getTypeFactory().buildBooleanType());
        VariableExp$Class resVarExp = new VariableExp$Class();
        resVarExp.setReferredVariable(resVar);
        resVarExp.setType(resVar.getType());
        BooleanLiteralExp$Class initExpr = new BooleanLiteralExp$Class("", Boolean.FALSE, Boolean.TRUE);
        initExpr.setType(this.processor.getTypeFactory().buildBooleanType());
        resVar.setInitExpression(initExpr);
        resVar.setType(initExpr.getType());
        OperationCallExp$Class bodyExpr = new OperationCallExp$Class();
        String opName = "or";
        bodyExpr.setSource(resVarExp);
        bodyExpr.setName(opName);
        bodyExpr.setType(resVarExp.getType());
        List<Object> argumentTypes = Arrays.asList(host.getBody().getType());
        List<Object> arguments = Arrays.asList(host.getBody());
        bodyExpr.setReferredOperation(resVar.getType().lookupOperation(opName, argumentTypes));
        bodyExpr.setArguments(arguments);
        resVarExp.setAppliedProperty(bodyExpr);
        OclAny res = this.iterate(host.getSource(), itVars, (VariableDeclaration)resVar, (OclExpression)bodyExpr, data);
        ((Impl)((Object)res)).setInitialisation(((Impl)((Object)res)).getInitialisation().replaceAll("// iterate", "// exists"));
        return res;
    }

    protected OclAny forAll(IteratorExp host, Set itVars, OclExpression body, Map data) {
        VariableDeclaration$Class resVar = new VariableDeclaration$Class("result$" + OclCodeGeneratorVisitorImpl.newTempVar());
        resVar.setType(this.processor.getTypeFactory().buildBooleanType());
        VariableExp$Class resVarExp = new VariableExp$Class();
        resVarExp.setReferredVariable(resVar);
        resVarExp.setType(resVar.getType());
        BooleanLiteralExp$Class initExpr = new BooleanLiteralExp$Class("", Boolean.FALSE, Boolean.TRUE);
        initExpr.setType(this.processor.getTypeFactory().buildBooleanType());
        resVar.setInitExpression(initExpr);
        resVar.setType(initExpr.getType());
        OperationCallExp$Class bodyExpr = new OperationCallExp$Class();
        String opName = "and";
        bodyExpr.setSource(resVarExp);
        bodyExpr.setName(opName);
        bodyExpr.setType(resVarExp.getType());
        List<Object> argumentTypes = Arrays.asList(host.getBody().getType());
        List<Object> arguments = Arrays.asList(host.getBody());
        bodyExpr.setReferredOperation(resVar.getType().lookupOperation(opName, argumentTypes));
        bodyExpr.setArguments(arguments);
        resVarExp.setAppliedProperty(bodyExpr);
        OclAny res = this.iterate(host.getSource(), itVars, (VariableDeclaration)resVar, (OclExpression)bodyExpr, data);
        ((Impl)((Object)res)).setInitialisation("// forAll\n" + ((Impl)((Object)res)).getInitialisation());
        return res;
    }

    protected OclAny isUnique(IteratorExp host, Set itVars, OclExpression body, Map data) {
        TupleLiteralExp$Class iterTuple = new TupleLiteralExp$Class("", Boolean.FALSE);
        Vector<VariableDeclaration$Class> parts = new Vector<VariableDeclaration$Class>();
        Vector<String> names = new Vector<String>();
        Vector<Classifier> types = new Vector<Classifier>();
        for (VariableDeclaration vd : itVars) {
            VariableExp$Class vexp = new VariableExp$Class(vd.getName(), Boolean.FALSE);
            vexp.setType(vd.getType());
            vexp.setReferredVariable(vd);
            VariableDeclaration$Class part = new VariableDeclaration$Class(vd.getName());
            part.setType(vd.getType());
            part.setInitExpression(vexp);
            parts.add(part);
            names.add(vd.getName());
            types.add(vd.getType());
        }
        iterTuple.setTuplePart(parts);
        iterTuple.setType(this.processor.getTypeFactory().buildTupleType(names.toArray(new String[0]), types.toArray(new Classifier[0])));
        VariableDeclaration$Class part1 = new VariableDeclaration$Class("iter");
        part1.setType(iterTuple.getType());
        part1.setInitExpression(iterTuple);
        VariableDeclaration$Class part2 = new VariableDeclaration$Class("value");
        part2.setType(body.getType());
        part2.setInitExpression(body);
        TupleLiteralExp$Class tupleExp = new TupleLiteralExp$Class("", Boolean.FALSE);
        tupleExp.setType(this.processor.getTypeFactory().buildTupleType(new String[]{"iter", "value"}, new Classifier[]{part1.getType(), part2.getType()}));
        tupleExp.setTuplePart(new Vector());
        tupleExp.getTuplePart().add(part1);
        tupleExp.getTuplePart().add(part2);
        IteratorExp$Class collectExp = new IteratorExp$Class("collect", Boolean.FALSE);
        collectExp.setIterators(itVars);
        collectExp.setBody(tupleExp);
        collectExp.setType(this.processor.getTypeFactory().buildBagType(tupleExp.getType()));
        collectExp.setSource(host.getSource());
        BooleanType boolType = this.processor.getTypeFactory().buildBooleanType();
        OclAnyType oclAnyType = this.processor.getTypeFactory().buildOclAnyType();
        Classifier elementType = ((CollectionType)host.getSource().getType()).getElementType();
        VariableDeclaration$Class xVar = new VariableDeclaration$Class("x_" + OclCodeGeneratorVisitorImpl.newTempVar());
        xVar.setType(tupleExp.getType());
        VariableExp$Class xVarExp = new VariableExp$Class();
        xVarExp.setReferredVariable(xVar);
        xVarExp.setType(xVar.getType());
        VariableDeclaration$Class yVar = new VariableDeclaration$Class("y_" + OclCodeGeneratorVisitorImpl.newTempVar());
        yVar.setType(tupleExp.getType());
        VariableExp$Class yVarExp = new VariableExp$Class();
        yVarExp.setReferredVariable(yVar);
        yVarExp.setType(yVar.getType());
        PropertyCallExp$Class xIterExp = new PropertyCallExp$Class("iter", Boolean.FALSE);
        xIterExp.setSource(xVarExp);
        xIterExp.setType(elementType);
        xIterExp.setReferredProperty(tupleExp.getType().lookupProperty("iter"));
        PropertyCallExp$Class yIterExp = new PropertyCallExp$Class("iter", Boolean.FALSE);
        yIterExp.setSource(yVarExp);
        yIterExp.setType(elementType);
        yIterExp.setReferredProperty(tupleExp.getType().lookupProperty("iter"));
        OperationCallExp$Class compareExp1 = new OperationCallExp$Class("<>", Boolean.FALSE);
        compareExp1.setType(boolType);
        compareExp1.setSource(xIterExp);
        compareExp1.setReferredOperation(xIterExp.getType().lookupOperation("<>", Arrays.asList(oclAnyType)));
        compareExp1.setArguments(Arrays.asList(yIterExp));
        PropertyCallExp$Class xValueExp = new PropertyCallExp$Class("value", Boolean.FALSE);
        xValueExp.setSource(xVarExp);
        xValueExp.setType(body.getType());
        xValueExp.setReferredProperty(tupleExp.getType().lookupProperty("value"));
        PropertyCallExp$Class yValueExp = new PropertyCallExp$Class("value", Boolean.FALSE);
        yValueExp.setSource(yVarExp);
        yValueExp.setType(body.getType());
        yValueExp.setReferredProperty(tupleExp.getType().lookupProperty("value"));
        OperationCallExp$Class compareExp2 = new OperationCallExp$Class("<>", Boolean.FALSE);
        compareExp2.setType(boolType);
        compareExp2.setSource(xValueExp);
        compareExp2.setReferredOperation(xValueExp.getType().lookupOperation("<>", Arrays.asList(yValueExp.getType())));
        compareExp2.setArguments(Arrays.asList(yValueExp));
        OperationCallExp$Class impliesExp = new OperationCallExp$Class("implies", Boolean.FALSE);
        impliesExp.setType(boolType);
        impliesExp.setSource(compareExp1);
        impliesExp.setReferredOperation(boolType.lookupOperation("implies", Arrays.asList(boolType)));
        impliesExp.setArguments(Arrays.asList(compareExp2));
        IteratorExp$Class forAllExp = new IteratorExp$Class("forAll", Boolean.FALSE);
        forAllExp.getIterators().add(xVar);
        forAllExp.getIterators().add(yVar);
        forAllExp.setBody(impliesExp);
        forAllExp.setSource(collectExp);
        forAllExp.setType(this.processor.getTypeFactory().buildBooleanType());
        return (OclAny)forAllExp.accept(this, data);
    }

    protected OclAny any(IteratorExp host, Set itVars, OclExpression body, Map data) {
        CollectionType sourceType = (CollectionType)host.getSource().getType();
        IteratorExp$Class selectExp = new IteratorExp$Class("select", Boolean.FALSE);
        selectExp.setIterators(itVars);
        selectExp.setBody(body);
        selectExp.setType(sourceType);
        selectExp.setSource(host.getSource());
        OperationCallExp$Class seqExp = new OperationCallExp$Class("asSequence", Boolean.FALSE);
        seqExp.setSource(selectExp);
        seqExp.setType(this.processor.getTypeFactory().buildSequenceType(sourceType.getElementType()));
        List<Object> argumentTypes = Arrays.asList(new Object[0]);
        List<Object> arguments = Arrays.asList(new Object[0]);
        seqExp.setReferredOperation(selectExp.getType().lookupOperation("asSequence", argumentTypes));
        seqExp.setArguments(arguments);
        OperationCallExp$Class firstExp = new OperationCallExp$Class("first", Boolean.FALSE);
        firstExp.setSource(seqExp);
        firstExp.setType(sourceType.getElementType());
        argumentTypes = Arrays.asList(new Object[0]);
        arguments = Arrays.asList(new Object[0]);
        firstExp.setReferredOperation(seqExp.getType().lookupOperation("first", argumentTypes));
        firstExp.setArguments(arguments);
        return (OclAny)firstExp.accept(this, data);
    }

    protected OclAny one(IteratorExp host, Set itVars, OclExpression body, Map data) {
        IteratorExp$Class selectExp = new IteratorExp$Class("select", Boolean.FALSE);
        selectExp.setIterators(itVars);
        selectExp.setBody(body);
        selectExp.setType(host.getSource().getType());
        selectExp.setSource(host.getSource());
        OperationCallExp$Class sizeExp = new OperationCallExp$Class("size", Boolean.FALSE);
        sizeExp.setSource(selectExp);
        sizeExp.setType(this.processor.getTypeFactory().buildIntegerType());
        List<Object> argumentTypes = Arrays.asList(new Object[0]);
        List<Object> arguments = Arrays.asList(new Object[0]);
        sizeExp.setReferredOperation(selectExp.getType().lookupOperation("size", argumentTypes));
        sizeExp.setArguments(arguments);
        IntegerLiteralExp$Class oneExp = new IntegerLiteralExp$Class();
        oneExp.setIntegerSymbol(new Integer(1));
        oneExp.setType(this.processor.getTypeFactory().buildIntegerType());
        OperationCallExp$Class equalExp = new OperationCallExp$Class("=", Boolean.FALSE);
        equalExp.setSource(sizeExp);
        equalExp.setType(this.processor.getTypeFactory().buildBooleanType());
        argumentTypes = Arrays.asList(this.processor.getTypeFactory().buildIntegerType());
        arguments = Arrays.asList(oneExp);
        equalExp.setReferredOperation(sizeExp.getType().lookupOperation("=", argumentTypes));
        equalExp.setArguments(arguments);
        return (OclAny)equalExp.accept(this, data);
    }

    protected OclAny collect(IteratorExp host, Set itVars, OclExpression body, Map data) {
        OclCollection col = this.collectNested(host, itVars, body, data);
        if (col instanceof OclOrderedSet) {
            return ((OclOrderedSet)col).flatten();
        }
        if (col instanceof OclSet) {
            return ((OclSet)col).flatten();
        }
        if (col instanceof OclBag) {
            return ((OclBag)col).flatten();
        }
        if (col instanceof OclSequence) {
            return ((OclSequence)col).flatten();
        }
        return null;
    }

    protected Map computeEmptyCollectionAttributes(Classifier sourceType) {
        String resultType = null;
        String resultName = null;
        String resultValue = null;
        if (sourceType instanceof BagType) {
            resultType = "OclBag";
            resultName = OclCodeGeneratorVisitorImpl.newTempVar();
            resultValue = String.valueOf(this.processor.getStdLibAdapterName()) + ".Bag();";
        } else if (sourceType instanceof SetType) {
            resultType = "OclSet";
            resultName = OclCodeGeneratorVisitorImpl.newTempVar();
            resultValue = String.valueOf(this.processor.getStdLibAdapterName()) + ".Set();";
        } else if (sourceType instanceof OrderedSetType) {
            resultType = "OclOrderedSet";
            resultName = OclCodeGeneratorVisitorImpl.newTempVar();
            resultValue = String.valueOf(this.processor.getStdLibAdapterName()) + ".OrderedSet();";
        } else if (sourceType instanceof SequenceType) {
            resultType = "OclSequence";
            resultName = OclCodeGeneratorVisitorImpl.newTempVar();
            resultValue = String.valueOf(this.processor.getStdLibAdapterName()) + ".Sequence();";
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("name", resultName);
        result.put("type", resultType);
        result.put("value", resultValue);
        return result;
    }

    protected OclAny select(IteratorExp host, Set itVars, OclExpression body, Map data) {
        VariableDeclaration var1 = (VariableDeclaration)itVars.iterator().next();
        CollectionType resType = (CollectionType)host.getSource().getType();
        VariableExp$Class var1Exp = new VariableExp$Class();
        var1Exp.setReferredVariable(var1);
        var1Exp.setType(var1.getType());
        VariableDeclaration$Class resVar = new VariableDeclaration$Class("result$" + OclCodeGeneratorVisitorImpl.newTempVar());
        resVar.setType(resType);
        VariableExp$Class resVarExp = new VariableExp$Class();
        resVarExp.setReferredVariable(resVar);
        resVarExp.setType(resType);
        CollectionLiteralExp initExpr = this.getNewCollLiteral(resType);
        initExpr.setType(resType);
        resVar.setInitExpression(initExpr);
        OperationCallExp$Class thenExp = new OperationCallExp$Class("including", Boolean.FALSE);
        thenExp.setSource(resVarExp);
        thenExp.setType(resType);
        List<Object> argumentTypes = Arrays.asList(var1Exp.getType());
        List<Object> arguments = Arrays.asList(var1Exp);
        thenExp.setReferredOperation(resType.lookupOperation("including", argumentTypes));
        thenExp.setArguments(arguments);
        VariableExp$Class elseExp = resVarExp;
        IfExp$Class bodyExpr = new IfExp$Class();
        bodyExpr.setCondition(body);
        bodyExpr.setThenExpression(thenExp);
        bodyExpr.setElseExpression(elseExp);
        bodyExpr.setType(resVar.getType());
        return this.iterate(host.getSource(), var1, (VariableDeclaration)resVar, (OclExpression)bodyExpr, data);
    }

    protected OclAny reject(IteratorExp host, Set itVars, OclExpression body, Map data) {
        ILog log = (ILog)data.get("log");
        OperationCallExp$Class notExp = new OperationCallExp$Class("not", Boolean.FALSE);
        notExp.setType(body.getType());
        notExp.setSource(body);
        Operation op = body.getType().lookupOperation("not", new Vector());
        if (op == null) {
            ErrorManager.reportError(log, null, "operation 'not' not found on type " + body.getType() + " in ->reject.");
        }
        notExp.setReferredOperation(op);
        notExp.setArguments(new Vector());
        IteratorExp$Class selExp = new IteratorExp$Class("select", Boolean.FALSE);
        selExp.setIterators(host.getIterators());
        selExp.setBody(notExp);
        selExp.setSource(host.getSource());
        return this.select(selExp, itVars, notExp, data);
    }

    Classifier baseElementType(Classifier t) {
        if (t instanceof CollectionType) {
            return this.baseElementType(((CollectionType)t).getElementType());
        }
        return t;
    }

    protected OclCollection collectNested(IteratorExp host, Set itVars, OclExpression body, Map data) {
        Classifier hostSourceType = host.getSource().getType();
        Classifier bodyType = body.getType();
        Operation collOp = hostSourceType.lookupOperation("collectNested", Arrays.asList(bodyType));
        CollectionType resType = (CollectionType)collOp.getReturnType();
        VariableDeclaration$Class resVar = new VariableDeclaration$Class("result_" + OclCodeGeneratorVisitorImpl.newTempVar());
        resVar.setType(resType);
        VariableExp$Class resVarExp = new VariableExp$Class();
        resVarExp.setReferredVariable(resVar);
        resVarExp.setType(resType);
        CollectionLiteralExp initExpr = this.getNewCollLiteral(resType);
        initExpr.setType(resType);
        resVar.setInitExpression(initExpr);
        OperationCallExp$Class opExp = new OperationCallExp$Class("including", Boolean.FALSE);
        opExp.setType(resType);
        opExp.setSource(resVarExp);
        opExp.setReferredOperation(resType.lookupOperation("including", Arrays.asList(resType.getElementType())));
        opExp.setArguments(Arrays.asList(body));
        return (OclCollection)this.iterate(host.getSource(), itVars, (VariableDeclaration)resVar, (OclExpression)opExp, data);
    }

    protected OclAny sortedBy(IteratorExp host, Set itVars, OclExpression body, Map data) {
        Classifier elementType = ((CollectionType)host.getSource().getType()).getElementType();
        VariableDeclaration origIter = (VariableDeclaration)itVars.iterator().next();
        String itName = "iterator$";
        VariableDeclaration$Class iterator = new VariableDeclaration$Class(itName);
        iterator.setType(elementType);
        VariableExp$Class iteratorExp = new VariableExp$Class(itName, Boolean.FALSE);
        iteratorExp.setType(iterator.getType());
        iteratorExp.setReferredVariable(iterator);
        String resName = "result$";
        VariableDeclaration$Class result = new VariableDeclaration$Class(resName);
        CollectionLiteralExp$Class initExp = new CollectionLiteralExp$Class();
        CollectionType resultType = null;
        if (host.getSource().getType() instanceof SetType) {
            resultType = this.processor.getTypeFactory().buildOrderedSetType(elementType);
            initExp.setKind(CollectionKind$Class.ORDERED_SET);
        } else {
            resultType = this.processor.getTypeFactory().buildSequenceType(elementType);
            initExp.setKind(CollectionKind$Class.SEQUENCE);
        }
        result.setType(resultType);
        initExp.setType(resultType);
        result.setInitExpression(initExp);
        VariableExp$Class resultExp = new VariableExp$Class(resName, Boolean.FALSE);
        resultExp.setType(result.getType());
        resultExp.setReferredVariable(result);
        OperationCallExp$Class isEmptyExp = new OperationCallExp$Class("isEmpty", Boolean.FALSE);
        isEmptyExp.setType(this.processor.getTypeFactory().buildBooleanType());
        isEmptyExp.setSource(resultExp);
        isEmptyExp.setArguments(new Vector());
        isEmptyExp.setReferredOperation(resultType.lookupOperation("isEmpty", new Vector()));
        OperationCallExp$Class appendExp = new OperationCallExp$Class("append", Boolean.FALSE);
        appendExp.setType(resultType);
        appendExp.setSource(resultExp);
        appendExp.setArguments(Arrays.asList(iteratorExp));
        appendExp.setReferredOperation(resultType.lookupOperation("append", Arrays.asList(iteratorExp.getType())));
        VariableExp$Class itemExp = new VariableExp$Class("item$", Boolean.FALSE);
        LetExp$Class letExp_origIterName = new LetExp$Class("origIterName", Boolean.FALSE);
        LetExp$Class letExp_body_item = new LetExp$Class("body_item", Boolean.FALSE);
        LetExp$Class letExp_origIterName2 = new LetExp$Class("origIterName2", Boolean.FALSE);
        LetExp$Class letExp_body_iterator = new LetExp$Class("body_iterator", Boolean.FALSE);
        VariableDeclaration$Class origIterName = new VariableDeclaration$Class(origIter.getName());
        origIterName.setType(origIter.getType());
        origIterName.setInitExpression(itemExp);
        VariableExp$Class origIterNameExp = new VariableExp$Class(origIter.getName(), Boolean.FALSE);
        origIterNameExp.setType(origIterName.getType());
        origIterNameExp.setReferredVariable(origIterName);
        letExp_origIterName.setVariable(origIterName);
        letExp_origIterName.setType(this.processor.getTypeFactory().buildBooleanType());
        letExp_origIterName.setIn(letExp_body_item);
        VariableDeclaration$Class body_item = new VariableDeclaration$Class("body_item$");
        body_item.setType(body.getType());
        body_item.setInitExpression(body);
        VariableExp$Class body_itemExp = new VariableExp$Class("body_item$", Boolean.FALSE);
        body_itemExp.setType(body_item.getType());
        body_itemExp.setReferredVariable(body_item);
        letExp_body_item.setVariable(body_item);
        letExp_body_item.setType(this.processor.getTypeFactory().buildBooleanType());
        letExp_body_item.setIn(letExp_origIterName2);
        VariableDeclaration$Class origIterName2 = new VariableDeclaration$Class(origIter.getName());
        origIterName2.setType(iterator.getType());
        origIterName2.setInitExpression(iteratorExp);
        VariableExp$Class origIterNameExp2 = new VariableExp$Class(origIter.getName(), Boolean.FALSE);
        origIterNameExp2.setType(origIterName2.getType());
        origIterNameExp2.setReferredVariable(origIterName2);
        letExp_origIterName2.setVariable(origIterName2);
        letExp_origIterName2.setType(this.processor.getTypeFactory().buildBooleanType());
        letExp_origIterName2.setIn(letExp_body_iterator);
        OperationCallExp$Class compExp = new OperationCallExp$Class(">", Boolean.FALSE);
        VariableDeclaration$Class body_iterator = new VariableDeclaration$Class("body_iterator$");
        body_iterator.setType(body.getType());
        body_iterator.setInitExpression(body);
        VariableExp$Class body_iteratorExp = new VariableExp$Class("body_iterator$", Boolean.FALSE);
        body_iteratorExp.setType(body_iterator.getType());
        body_iteratorExp.setReferredVariable(body_iterator);
        letExp_body_iterator.setVariable(body_iterator);
        letExp_body_iterator.setType(this.processor.getTypeFactory().buildBooleanType());
        letExp_body_iterator.setIn(compExp);
        compExp.setType(this.processor.getTypeFactory().buildBooleanType());
        compExp.setSource(body_itemExp);
        compExp.setArguments(Arrays.asList(body_iteratorExp));
        compExp.setReferredOperation(body_item.getType().lookupOperation(">", Arrays.asList(body_iteratorExp.getType())));
        IteratorExp$Class selectExp = new IteratorExp$Class("select", Boolean.FALSE);
        VariableDeclaration$Class item = new VariableDeclaration$Class("item$");
        item.setType(resultType.getElementType());
        itemExp.setType(item.getType());
        itemExp.setReferredVariable(item);
        selectExp.setIterators(new HashSet<Object>(Arrays.asList(item)));
        selectExp.setBody(letExp_origIterName);
        selectExp.setSource(resultExp);
        selectExp.setType(resultExp.getType());
        OperationCallExp$Class indexOfExp = new OperationCallExp$Class("indexOf", Boolean.FALSE);
        indexOfExp.setType(this.processor.getTypeFactory().buildIntegerType());
        indexOfExp.setSource(resultExp);
        indexOfExp.setArguments(Arrays.asList(selectExp));
        indexOfExp.setReferredOperation(resultType.lookupOperation("indexOf", Arrays.asList(resultType.getElementType())));
        LetExp$Class letExp = new LetExp$Class("position$", Boolean.FALSE);
        VariableDeclaration$Class position = new VariableDeclaration$Class("position$");
        position.setType(this.processor.getTypeFactory().buildIntegerType());
        position.setInitExpression(indexOfExp);
        VariableExp$Class positionExp = new VariableExp$Class("position$", Boolean.FALSE);
        positionExp.setType(position.getType());
        positionExp.setReferredVariable(position);
        letExp.setVariable(position);
        letExp.setType(resultType);
        OperationCallExp$Class insertAtExp = new OperationCallExp$Class("insertAt", Boolean.FALSE);
        insertAtExp.setType(resultType);
        insertAtExp.setSource(resultExp);
        insertAtExp.setArguments(Arrays.asList(positionExp, iteratorExp));
        insertAtExp.setReferredOperation(resultType.lookupOperation("insertAt", Arrays.asList(positionExp.getType(), iteratorExp.getType())));
        letExp.setIn(insertAtExp);
        IfExp$Class ifExp = new IfExp$Class();
        ifExp.setType(resultType);
        ifExp.setCondition(isEmptyExp);
        ifExp.setThenExpression(appendExp);
        ifExp.setElseExpression(letExp);
        return this.iterate(host.getSource(), iterator, (VariableDeclaration)result, (OclExpression)ifExp, data);
    }

    @Override
    public Object visit(IteratorExp host, Object data) {
        String cfr_ignored_0 = (String)((Map)data).get("indent");
        String name = host.getName();
        Set iterators = host.getIterators();
        OclExpression body = host.getBody();
        OclAny result = null;
        if (name.equals("exists")) {
            return this.exists(host, iterators, body, (Map)data);
        }
        if (name.equals("forAll")) {
            return this.forAll(host, iterators, body, (Map)data);
        }
        if (name.equals("isUnique")) {
            result = this.isUnique(host, iterators, body, (Map)data);
        } else {
            if (name.equals("any")) {
                return this.any(host, iterators, body, (Map)data);
            }
            if (name.equals("one")) {
                result = this.one(host, iterators, body, (Map)data);
            } else if (name.equals("collect")) {
                result = this.collect(host, iterators, body, (Map)data);
            } else if (name.equals("select")) {
                result = this.select(host, iterators, body, (Map)data);
            } else if (name.equals("reject")) {
                result = this.reject(host, iterators, body, (Map)data);
            } else if (name.equals("collectNested")) {
                result = this.collectNested(host, iterators, body, (Map)data);
            } else if (name.equals("sortedBy")) {
                result = this.sortedBy(host, iterators, body, (Map)data);
            }
        }
        return result;
    }

    public static String unBoxedTypeName(Classifier c) {
        if (c instanceof IntegerType) {
            return "int";
        }
        if (c instanceof RealType) {
            return "double";
        }
        return ((Class)c.getDelegate()).getName();
    }

    public static String unBox(Classifier c, String expr) {
        if (c instanceof VoidType) {
            return expr;
        }
        String unBoxStr = "((" + ((Class)c.getDelegate()).getName() + ")" + expr + ")";
        if (c instanceof IntegerType) {
            return String.valueOf(unBoxStr) + ".intValue()";
        }
        if (c instanceof RealType) {
            return String.valueOf(unBoxStr) + ".doubleValue()";
        }
        return unBoxStr;
    }

    protected OclAny iterate(OclExpression source, Set itVars, VariableDeclaration resultVar, OclExpression body, Map data) {
        if (itVars.size() == 1) {
            return this.iterate(source, (VariableDeclaration)itVars.iterator().next(), resultVar, body, data);
        }
        VariableDeclaration headItVar = (VariableDeclaration)itVars.iterator().next();
        HashSet tailItVars = new HashSet(itVars);
        tailItVars.remove(headItVar);
        VariableDeclaration$Class outerResult = new VariableDeclaration$Class(String.valueOf(resultVar.getName()) + headItVar.getName());
        outerResult.setType(resultVar.getType());
        outerResult.setInitExpression(resultVar.getInitExpression());
        VariableExp$Class inerResultExp = new VariableExp$Class(resultVar.getName(), Boolean.FALSE);
        inerResultExp.setType(resultVar.getType());
        inerResultExp.setReferredVariable(outerResult);
        resultVar.setInitExpression(inerResultExp);
        IterateExp$Class itExp = new IterateExp$Class("iterate", Boolean.FALSE);
        itExp.setSource(source);
        itExp.setIterators(tailItVars);
        itExp.setResult(resultVar);
        itExp.setBody(body);
        return this.iterate(source, headItVar, (VariableDeclaration)outerResult, (OclExpression)itExp, data);
    }

    protected OclAny iterate(OclExpression source, VariableDeclaration iterateVar, VariableDeclaration resultVar, OclExpression body, Map data) {
        StdLibGenerationAdapterImpl adapter = (StdLibGenerationAdapterImpl)this.processor.getStdLibGenerationAdapter();
        Classifier resultType = resultVar.getType();
        String resultTypeName = OclCodeGeneratorVisitorImpl.unBoxedTypeName(resultVar.getType());
        OclAny result = null;
        String resultName = resultVar.getName();
        if (resultVar.getType() instanceof CollectionType) {
            Class cfr_ignored_0 = (Class)((CollectionType)resultVar.getType()).getElementType().getDelegate();
            result = adapter.OclCollection((CollectionType)resultType, resultName);
        } else {
            result = adapter.OclAny(resultType, resultName);
        }
        OclAny resultInit = (OclAny)resultVar.getInitExpression().accept(this, data);
        OclCollection sourceColl = (OclCollection)source.accept(this, data);
        OclAny itVar = (OclAny)iterateVar.accept(this, data);
        Classifier itType = iterateVar.getType();
        String itTypeName = OclCodeGeneratorVisitorImpl.unBoxedTypeName(itType);
        OclAny bodyVal = (OclAny)body.accept(this, data);
        String it = StdLibGenerationAdapterImpl.newTempVar("iter");
        String ex = StdLibGenerationAdapterImpl.newTempVar("ex");
        ((Impl)((Object)result)).setInitialisation(String.valueOf(((Impl)((Object)result)).getInitialisation()) + ((Impl)((Object)sourceColl)).getInitialisation());
        ((Impl)((Object)result)).setInitialisation(String.valueOf(((Impl)((Object)result)).getInitialisation()) + ((Impl)((Object)resultInit)).getInitialisation());
        ((Impl)((Object)result)).setInitialisation(String.valueOf(((Impl)((Object)result)).getInitialisation()) + "// iterate\n");
        ((Impl)((Object)result)).setInitialisation(String.valueOf(((Impl)((Object)result)).getInitialisation()) + resultTypeName + " " + result + "=" + resultInit + ";\n");
        ((Impl)((Object)result)).setInitialisation(String.valueOf(((Impl)((Object)result)).getInitialisation()) + "java.util.Iterator " + it + " = null;");
        ((Impl)((Object)result)).setInitialisation(String.valueOf(((Impl)((Object)result)).getInitialisation()) + "try { " + it + " = " + sourceColl + ".iterator(); } catch (Exception " + ex + "){" + it + " = (new java.util.Vector()).iterator();}");
        ((Impl)((Object)result)).setInitialisation(String.valueOf(((Impl)((Object)result)).getInitialisation()) + "while (" + it + ".hasNext()) {\n");
        ((Impl)((Object)result)).setInitialisation(String.valueOf(((Impl)((Object)result)).getInitialisation()) + "  " + itTypeName + " " + itVar + "=" + OclCodeGeneratorVisitorImpl.unBox(itType, String.valueOf(it) + ".next()") + ";\n");
        ((Impl)((Object)result)).setInitialisation(String.valueOf(((Impl)((Object)result)).getInitialisation()) + "  " + ((Impl)((Object)bodyVal)).getInitialisation());
        ((Impl)((Object)result)).setInitialisation(String.valueOf(((Impl)((Object)result)).getInitialisation()) + "  " + result + "=" + bodyVal + ";\n");
        ((Impl)((Object)result)).setInitialisation(String.valueOf(((Impl)((Object)result)).getInitialisation()) + "}\n");
        return result;
    }

    @Override
    public Object visit(IterateExp host, Object data) {
        String cfr_ignored_0 = (String)((Map)data).get("indent");
        OclExpression source = host.getSource();
        Set itVars = host.getIterators();
        VariableDeclaration var2 = host.getResult();
        OclExpression body = host.getBody();
        return this.iterate(source, itVars, var2, body, (Map)data);
    }

    @Override
    public Object visit(VariableExp host, Object data) {
        if (host.getReferredVariable() != null) {
            String result = host.getReferredVariable().getName();
            Classifier type = host.getType();
            return ((StdLibGenerationAdapterImpl)this.processor.getStdLibGenerationAdapter()).OclAny(type, result);
        }
        return null;
    }

    @Override
    public Object visit(IfExp host, Object data) {
        String cfr_ignored_0 = (String)((Map)data).get("indent");
        OclAny condition = (OclAny)host.getCondition().accept(this, data);
        OclAny thenValue = (OclAny)host.getThenExpression().accept(this, data);
        OclAny elseValue = (OclAny)host.getElseExpression().accept(this, data);
        OclAny result = ((StdLibGenerationAdapterImpl)this.processor.getStdLibGenerationAdapter()).OclAny(host.getType(), OclCodeGeneratorVisitorImpl.newTempVar());
        String resultType = OclCodeGeneratorVisitorImpl.unBoxedTypeName(host.getType());
        String init = ((Impl)((Object)condition)).getInitialisation();
        init = String.valueOf(init) + resultType + " " + result + " = null;\n";
        init = String.valueOf(init) + "if (" + condition + ".booleanValue()) {\n";
        init = String.valueOf(init) + ((Impl)((Object)thenValue)).getInitialisation();
        init = String.valueOf(init) + "  " + result + "=" + thenValue + ";\n";
        init = String.valueOf(init) + "} else {\n";
        init = String.valueOf(init) + ((Impl)((Object)elseValue)).getInitialisation();
        init = String.valueOf(init) + "  " + result + "=" + elseValue + ";\n";
        init = String.valueOf(init) + "}\n";
        ((Impl)((Object)result)).setInitialisation(init);
        return result;
    }

    @Override
    public Object visit(LetExp host, Object data) {
        String cfr_ignored_0 = (String)((Map)data).get("indent");
        VariableDeclaration var = host.getVariable();
        OclAny v = (OclAny)var.accept(this, data);
        OclAny in = (OclAny)host.getIn().accept(this, data);
        ((Impl)((Object)in)).setInitialisation(String.valueOf(((Impl)((Object)v)).getInitialisation()) + ((Impl)((Object)in)).getInitialisation());
        return in;
    }

    @Override
    public Object visit(OclAnyType host, Object data) {
        String cfr_ignored_0 = (String)((Map)data).get("indent");
        return "OclAny";
    }

    @Override
    public Object visit(DataType host, Object data) {
        String cfr_ignored_0 = (String)((Map)data).get("indent");
        return "OclAny";
    }

    @Override
    public Object visit(Primitive host, Object data) {
        RuntimeEnvironment cfr_ignored_0 = (RuntimeEnvironment)((Map)data).get("env");
        String cfr_ignored_1 = (String)((Map)data).get("indent");
        return "OclAny";
    }

    @Override
    public Object visit(BooleanType host, Object data) {
        String cfr_ignored_0 = (String)((Map)data).get("indent");
        return "OclBoolean";
    }

    @Override
    public Object visit(IntegerType host, Object data) {
        String cfr_ignored_0 = (String)((Map)data).get("indent");
        return "OclInteger";
    }

    @Override
    public Object visit(RealType host, Object data) {
        String cfr_ignored_0 = (String)((Map)data).get("indent");
        return "OclReal";
    }

    @Override
    public Object visit(StringType host, Object data) {
        String cfr_ignored_0 = (String)((Map)data).get("indent");
        return "OclString";
    }

    @Override
    public Object visit(TupleType host, Object data) {
        String cfr_ignored_0 = (String)((Map)data).get("indent");
        return "OclTuple";
    }

    @Override
    public Object visit(CollectionType host, Object data) {
        String cfr_ignored_0 = (String)((Map)data).get("indent");
        return "OclCollection";
    }

    @Override
    public Object visit(SequenceType host, Object data) {
        String cfr_ignored_0 = (String)((Map)data).get("indent");
        return "OclSequence";
    }

    @Override
    public Object visit(OrderedSetType host, Object data) {
        String cfr_ignored_0 = (String)((Map)data).get("indent");
        return "OclOrderedSet";
    }

    @Override
    public Object visit(SetType host, Object data) {
        String cfr_ignored_0 = (String)((Map)data).get("indent");
        return "OclSet";
    }

    @Override
    public Object visit(BagType host, Object data) {
        String cfr_ignored_0 = (String)((Map)data).get("indent");
        return "OclBag";
    }

    @Override
    public Object visit(OclModelElementType host, Object data) {
        String cfr_ignored_0 = (String)((Map)data).get("indent");
        return host.getFullName(".");
    }

    @Override
    public Object visit(OclMessageType host, Object data) {
        String cfr_ignored_0 = (String)((Map)data).get("indent");
        return "OclMessageType";
    }

    @Override
    public Object visit(VoidType host, Object data) {
        String cfr_ignored_0 = (String)((Map)data).get("indent");
        return "VoidType";
    }
}

