/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.synthesis;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.semantics.model.contexts.ContextDeclaration;
import org.oslo.ocl20.standard.lib.OclAny;
import org.oslo.ocl20.synthesis.OclEvaluator;
import org.oslo.ocl20.synthesis.OclEvaluatorVisitorImpl;
import org.oslo.ocl20.synthesis.RuntimeEnvironment;
import org.oslo.ocl20.synthesis.RuntimeEnvironmentImpl;
import uk.ac.kent.cs.kmf.util.ILog;
import uk.ac.kent.cs.kmf.util.OutputStreamLog;

public class OclEvaluatorImpl
implements OclEvaluator {
    OclProcessor processor;
    OclEvaluatorVisitorImpl evaluator;
    protected ContextDeclaration decl;
    protected RuntimeEnvironment renv;
    protected ILog log;

    public OclEvaluatorImpl(OclProcessor processor, OclEvaluatorVisitorImpl evaluator) {
        this.processor = processor;
        this.evaluator = evaluator;
    }

    protected Map evaluate() {
        if (this.decl == null) {
            return null;
        }
        if (this.renv == null) {
            this.renv = new RuntimeEnvironmentImpl();
        }
        if (this.log == null) {
            this.log = new OutputStreamLog((OutputStream)System.out);
        }
        HashMap<String, RuntimeEnvironment> data = new HashMap<String, RuntimeEnvironment>();
        data.put("env", this.renv);
        data.put("log", (RuntimeEnvironment)this.log);
        Map result = (Map)this.decl.accept(this.evaluator, data);
        for (Map.Entry entry : result.entrySet()) {
            if (!(entry.getValue() instanceof OclAny)) continue;
            entry.setValue(((OclAny)entry.getValue()).asJavaObject());
        }
        return result;
    }

    @Override
    public Map evaluate(ContextDeclaration decl, RuntimeEnvironment renv) {
        this.decl = decl;
        this.renv = renv;
        this.log = new OutputStreamLog((OutputStream)System.out);
        return this.evaluate();
    }

    public Map evaluate(ContextDeclaration decl) {
        this.decl = decl;
        this.renv = new RuntimeEnvironmentImpl();
        this.renv.setValue("self", null);
        this.log = new OutputStreamLog((OutputStream)System.out);
        return this.evaluate();
    }

    @Override
    public Map evaluate(ContextDeclaration decl, RuntimeEnvironment renv, ILog log) {
        this.decl = decl;
        this.renv = renv;
        this.log = log;
        return this.evaluate();
    }

    @Override
    public OclAny evaluateAsOCL(ContextDeclaration decl, RuntimeEnvironment renv, ILog log) {
        if (decl == null) {
            return null;
        }
        if (renv == null) {
            renv = new RuntimeEnvironmentImpl();
        }
        if (log == null) {
            log = new OutputStreamLog((OutputStream)System.out);
        }
        HashMap<String, RuntimeEnvironment> data = new HashMap<String, RuntimeEnvironment>();
        data.put("env", renv);
        data.put("log", (RuntimeEnvironment)log);
        Map map = (Map)decl.accept(this.evaluator, data);
        OclAny result = null;
        Iterator i = map.entrySet().iterator();
        if (i.hasNext()) {
            Map.Entry me = i.next();
            result = (OclAny)me.getValue();
        }
        return result;
    }
}

