/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.synthesis;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.oslo.ocl20.semantics.SemanticsVisitor;
import org.oslo.ocl20.semantics.SemanticsVisitor$Class;
import org.oslo.ocl20.semantics.bridge.CallAction;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.bridge.DataType;
import org.oslo.ocl20.semantics.bridge.EnumLiteral;
import org.oslo.ocl20.semantics.bridge.EnumerationType;
import org.oslo.ocl20.semantics.bridge.Environment;
import org.oslo.ocl20.semantics.bridge.ModelElement;
import org.oslo.ocl20.semantics.bridge.NamedElement;
import org.oslo.ocl20.semantics.bridge.Namespace;
import org.oslo.ocl20.semantics.bridge.OclModelElementType;
import org.oslo.ocl20.semantics.bridge.Operation;
import org.oslo.ocl20.semantics.bridge.Primitive;
import org.oslo.ocl20.semantics.bridge.Property;
import org.oslo.ocl20.semantics.bridge.SendAction;
import org.oslo.ocl20.semantics.bridge.Signal;
import org.oslo.ocl20.semantics.model.contexts.ClassifierContextDecl;
import org.oslo.ocl20.semantics.model.contexts.Constraint;
import org.oslo.ocl20.semantics.model.contexts.ConstraintKind$Class;
import org.oslo.ocl20.semantics.model.contexts.ContextDeclaration;
import org.oslo.ocl20.semantics.model.contexts.OperationContextDecl;
import org.oslo.ocl20.semantics.model.contexts.PropertyContextDecl;
import org.oslo.ocl20.semantics.model.expressions.BooleanLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.CollectionItem;
import org.oslo.ocl20.semantics.model.expressions.CollectionKind;
import org.oslo.ocl20.semantics.model.expressions.CollectionKind$Class;
import org.oslo.ocl20.semantics.model.expressions.CollectionLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.CollectionLiteralPart;
import org.oslo.ocl20.semantics.model.expressions.CollectionRange;
import org.oslo.ocl20.semantics.model.expressions.EnumLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.IfExp;
import org.oslo.ocl20.semantics.model.expressions.IntegerLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.IterateExp;
import org.oslo.ocl20.semantics.model.expressions.IteratorExp;
import org.oslo.ocl20.semantics.model.expressions.LetExp;
import org.oslo.ocl20.semantics.model.expressions.OclExpression;
import org.oslo.ocl20.semantics.model.expressions.OclMessageArg;
import org.oslo.ocl20.semantics.model.expressions.OclMessageExp;
import org.oslo.ocl20.semantics.model.expressions.OperationCallExp;
import org.oslo.ocl20.semantics.model.expressions.PropertyCallExp;
import org.oslo.ocl20.semantics.model.expressions.RealLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.StringLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.TupleLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.TypeLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.UndefinedLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.UnspecifiedValueExp;
import org.oslo.ocl20.semantics.model.expressions.VariableDeclaration;
import org.oslo.ocl20.semantics.model.expressions.VariableExp;
import org.oslo.ocl20.semantics.model.types.BagType;
import org.oslo.ocl20.semantics.model.types.BooleanType;
import org.oslo.ocl20.semantics.model.types.CollectionType;
import org.oslo.ocl20.semantics.model.types.IntegerType;
import org.oslo.ocl20.semantics.model.types.OclAnyType;
import org.oslo.ocl20.semantics.model.types.OclMessageType;
import org.oslo.ocl20.semantics.model.types.OrderedSetType;
import org.oslo.ocl20.semantics.model.types.RealType;
import org.oslo.ocl20.semantics.model.types.SequenceType;
import org.oslo.ocl20.semantics.model.types.SetType;
import org.oslo.ocl20.semantics.model.types.StringType;
import org.oslo.ocl20.semantics.model.types.TupleType;
import org.oslo.ocl20.semantics.model.types.VoidType;
import org.oslo.ocl20.standard.lib.OclCollection;
import uk.ac.kent.cs.kmf.util.ILog;

public class OclToStringVisitorImpl
extends SemanticsVisitor$Class
implements SemanticsVisitor {
    protected static Map nameMap = new HashMap();

    static {
        nameMap.put("=", "equalTo");
        nameMap.put("<>", "notEqualTo");
        nameMap.put("+", "add");
        nameMap.put("-", "subtract");
        nameMap.put("*", "multiply");
        nameMap.put("/", "divide");
        nameMap.put("<", "lessThan");
        nameMap.put(">", "greaterThan");
        nameMap.put("<=", "lessThanOrEqualTo");
        nameMap.put(">=", "greaterThanOrEqualTo");
    }

    @Override
    public Object visit(VariableDeclaration host, Object data) {
        String x = String.valueOf(host.getName()) + ":" + host.getType().getFullName("::");
        if (host.getInitExpression() != null) {
            x = String.valueOf(x) + " = " + host.getInitExpression().accept(this, data);
        }
        return x;
    }

    @Override
    public Object visit(BooleanLiteralExp host, Object data) {
        return host.getBooleanSymbol().toString();
    }

    @Override
    public Object visit(UndefinedLiteralExp host, Object data) {
        return "undefined";
    }

    @Override
    public Object visit(TypeLiteralExp host, Object data) {
        return host.getLiteralType().getFullName("::");
    }

    @Override
    public Object visit(IntegerLiteralExp host, Object data) {
        return host.getIntegerSymbol().toString();
    }

    @Override
    public Object visit(RealLiteralExp host, Object data) {
        return host.getRealSymbol().toString();
    }

    @Override
    public Object visit(StringLiteralExp host, Object data) {
        return host.getStringSymbol();
    }

    @Override
    public Object visit(EnumLiteralExp host, Object data) {
        return String.valueOf(host.getReferredEnumLiteral().getEnumeration().getFullName("::")) + "::" + host.getReferredEnumLiteral().getName();
    }

    @Override
    public Object visit(CollectionLiteralExp host, Object data) {
        String kind = (String)host.getKind().accept(this, data);
        String result = String.valueOf(kind) + " {";
        Iterator i = host.getParts().iterator();
        while (i.hasNext()) {
            CollectionLiteralPart part = (CollectionLiteralPart)i.next();
            result = String.valueOf(result) + (String)part.accept(this, data);
            if (!i.hasNext()) continue;
            result = String.valueOf(result) + ", ";
        }
        result = String.valueOf(result) + "}";
        return result;
    }

    @Override
    public Object visit(TupleLiteralExp host, Object data) {
        String result = "Tuple {";
        Iterator i = host.getTuplePart().iterator();
        while (i.hasNext()) {
            VariableDeclaration var = (VariableDeclaration)i.next();
            result = String.valueOf(result) + (String)var.accept(this, data);
            if (!i.hasNext()) continue;
            result = String.valueOf(result) + ", ";
        }
        result = String.valueOf(result) + "}";
        return result;
    }

    protected static String getFunctionName(Operation op) {
        String name = op.getName();
        Classifier type = op.getReturnType();
        int numParams = op.getParameterTypes().size();
        if (name.equals("abs") && numParams == 0 && type instanceof IntegerType) {
            return "iabs";
        }
        if (name.equals("-") && numParams == 0) {
            return String.valueOf(type instanceof IntegerType ? "i" : "") + "negate";
        }
        String result = (String)nameMap.get(name);
        if (result == null) {
            return name;
        }
        return result;
    }

    @Override
    public Object visit(OperationCallExp host, Object data) {
        String result = "";
        result = String.valueOf(result) + (String)host.getSource().accept(this, data);
        result = String.valueOf(result) + "." + OclToStringVisitorImpl.getFunctionName(host.getReferredOperation());
        result = String.valueOf(result) + "(";
        Iterator i = host.getArguments().iterator();
        while (i.hasNext()) {
            OclExpression arg = (OclExpression)i.next();
            result = String.valueOf(result) + (String)arg.accept(this, data);
            if (!i.hasNext()) continue;
            result = String.valueOf(result) + ", ";
        }
        result = String.valueOf(result) + ")";
        return result;
    }

    @Override
    public Object visit(PropertyCallExp host, Object data) {
        String result = "";
        Property prop = host.getReferredProperty();
        if (prop instanceof EnumLiteral) {
            result = (String)((EnumLiteral)prop).accept(this, data);
        } else {
            result = String.valueOf(result) + (String)host.getSource().accept(this, data) + ".";
            result = String.valueOf(result) + host.getReferredProperty().getName();
        }
        return result;
    }

    protected Object exists(IteratorExp host, VariableDeclaration var1, VariableDeclaration var2, OclExpression body, Map data) {
        String result = host.getSource().accept(this, data) + "\n";
        result = String.valueOf(result) + "->exists( " + var1.getName() + "|\n";
        result = String.valueOf(result) + "  " + body.accept(this, data);
        result = String.valueOf(result) + ")";
        return result;
    }

    protected Object forAll(IteratorExp host, VariableDeclaration var1, VariableDeclaration var2, OclExpression body, Map data) {
        String result = host.getSource().accept(this, data) + "\n";
        result = String.valueOf(result) + "->forAll( " + var1.getName() + "|\n";
        result = String.valueOf(result) + "  " + body.accept(this, data);
        result = String.valueOf(result) + ")";
        return result;
    }

    protected Object isUnique(IteratorExp host, VariableDeclaration var1, VariableDeclaration var2, OclExpression body, Map data) {
        String result = host.getSource().accept(this, data) + "\n";
        result = String.valueOf(result) + "->isUnique( " + var1.getName() + "|\n";
        result = String.valueOf(result) + "  " + body.accept(this, data);
        result = String.valueOf(result) + ")";
        return result;
    }

    protected Object any(IteratorExp host, VariableDeclaration var1, VariableDeclaration var2, OclExpression body, Map data) {
        String result = host.getSource().accept(this, data) + "\n";
        result = String.valueOf(result) + "->any( " + var1.getName() + "|\n";
        result = String.valueOf(result) + "  " + body.accept(this, data);
        result = String.valueOf(result) + ")";
        return result;
    }

    protected Object one(IteratorExp host, VariableDeclaration var1, VariableDeclaration var2, OclExpression body, Map data) {
        String result = host.getSource().accept(this, data) + "\n";
        result = String.valueOf(result) + "->one( " + var1.getName() + "|\n";
        result = String.valueOf(result) + "  " + body.accept(this, data);
        result = String.valueOf(result) + ")";
        return result;
    }

    protected Object collect(IteratorExp host, VariableDeclaration var1, VariableDeclaration var2, OclExpression body, Map data) {
        String result = "";
        result = String.valueOf(result) + host.getSource().accept(this, data);
        result = String.valueOf(result) + "->collect( " + var1.getName() + "|\n";
        result = String.valueOf(result) + "  " + body.accept(this, data);
        result = String.valueOf(result) + ")";
        return result;
    }

    protected OclCollection initCollection(CollectionType type) {
        return null;
    }

    protected Object select(IteratorExp host, VariableDeclaration var1, VariableDeclaration var2, OclExpression body, Map data) {
        String result = "";
        result = String.valueOf(result) + host.getSource().accept(this, data);
        result = String.valueOf(result) + "->select( " + var1.getName() + "|\n";
        result = String.valueOf(result) + "  " + body.accept(this, data);
        result = String.valueOf(result) + ")";
        return result;
    }

    protected Object reject(IteratorExp host, VariableDeclaration var1, VariableDeclaration var2, OclExpression body, Map data) {
        String result = host.getSource().accept(this, data) + "\n";
        result = String.valueOf(result) + "->reject( " + var1.getName() + "|\n";
        result = String.valueOf(result) + "  " + body.accept(this, data);
        result = String.valueOf(result) + ")";
        return result;
    }

    protected Object collectNested(IteratorExp host, VariableDeclaration var1, VariableDeclaration var2, OclExpression body, Map data) {
        String result = host.getSource().accept(this, data) + "\n";
        result = String.valueOf(result) + "->collectNested( " + var1.getName() + "|\n";
        result = String.valueOf(result) + "  " + body.accept(this, data);
        result = String.valueOf(result) + ")";
        return result;
    }

    protected Object sortedBy(IteratorExp host, VariableDeclaration var1, VariableDeclaration var2, OclExpression body, Map data) {
        String result = host.getSource().accept(this, data) + "\n";
        result = String.valueOf(result) + "->sortedBy( " + var1.getName() + "|\n";
        result = String.valueOf(result) + "  " + body.accept(this, data);
        result = String.valueOf(result) + ")";
        return result;
    }

    Method getGreaterThanMethod(Object o, Object p, ILog log) {
        return null;
    }

    @Override
    public Object visit(IteratorExp host, Object data) {
        String name = host.getName();
        VariableDeclaration var1 = null;
        if (host.getIterators().size() >= 1) {
            var1 = (VariableDeclaration)host.getIterators().toArray()[0];
        }
        VariableDeclaration var2 = null;
        if (host.getIterators().size() >= 2) {
            var2 = (VariableDeclaration)host.getIterators().toArray()[1];
        }
        OclExpression body = host.getBody();
        Object result = null;
        if (name.equals("exists")) {
            result = this.exists(host, var1, var2, body, (Map)data);
        } else if (name.equals("forAll")) {
            result = this.forAll(host, var1, var2, body, (Map)data);
        } else if (name.equals("isUnique")) {
            result = this.isUnique(host, var1, var2, body, (Map)data);
        } else if (name.equals("any")) {
            result = this.any(host, var1, var2, body, (Map)data);
        } else if (name.equals("one")) {
            result = this.one(host, var1, var2, body, (Map)data);
        } else if (name.equals("collect")) {
            result = this.collect(host, var1, var2, body, (Map)data);
        } else if (name.equals("select")) {
            result = this.select(host, var1, var2, body, (Map)data);
        } else if (name.equals("reject")) {
            result = this.reject(host, var1, var2, body, (Map)data);
        } else if (name.equals("collectNested")) {
            result = this.collectNested(host, var1, var2, body, (Map)data);
        } else if (name.equals("sortedBy")) {
            result = this.sortedBy(host, var1, var2, body, (Map)data);
        }
        return result;
    }

    protected Object iterate(OclExpression source, VariableDeclaration var1, VariableDeclaration var2, OclExpression body, Map data) {
        return null;
    }

    @Override
    public Object visit(IterateExp host, Object data) {
        String cfr_ignored_0 = (String)host.getSource().accept(this, data);
        VariableDeclaration var1 = null;
        if (host.getIterators() != null && host.getIterators().size() > 0) {
            var1 = (VariableDeclaration)host.getIterators().toArray()[0];
        }
        VariableDeclaration var2 = host.getResult();
        OclExpression body = host.getBody();
        return this.iterate(host.getSource(), var1, var2, body, (Map)data);
    }

    @Override
    public Object visit(VariableExp host, Object data) {
        String result = host.getReferredVariable().getName();
        return result;
    }

    @Override
    public Object visit(IfExp host, Object data) {
        String result = "if ";
        result = String.valueOf(result) + host.getCondition().accept(this, data) + " then ";
        result = String.valueOf(result) + host.getThenExpression().accept(this, data) + " else ";
        result = String.valueOf(result) + host.getElseExpression().accept(this, data) + " endif ";
        return result;
    }

    @Override
    public Object visit(LetExp host, Object data) {
        Map m = (Map)data;
        String inTag = (String)m.get("in");
        String result = "";
        if (inTag == null) {
            result = String.valueOf(result) + "let ";
        }
        result = String.valueOf(result) + host.getVariable().accept(this, null);
        if (host.getIn() instanceof LetExp) {
            m.put("in", "in");
            result = String.valueOf(result) + ", " + host.getIn().accept(this, m);
        } else {
            m.remove("in");
            result = String.valueOf(result) + " in " + host.getIn().accept(this, data);
        }
        return result;
    }

    @Override
    public Object visit(OclMessageExp host, Object data) {
        return null;
    }

    @Override
    public Object visit(OclMessageArg host, Object data) {
        return null;
    }

    @Override
    public Object visit(UnspecifiedValueExp host, Object data) {
        return null;
    }

    @Override
    public Object visit(OclAnyType host, Object data) {
        return "OclAny";
    }

    @Override
    public Object visit(DataType host, Object data) {
        return "OclAny";
    }

    @Override
    public Object visit(Primitive host, Object data) {
        return "OclAny";
    }

    @Override
    public Object visit(BooleanType host, Object data) {
        return "Boolean";
    }

    @Override
    public Object visit(IntegerType host, Object data) {
        return "Integer";
    }

    @Override
    public Object visit(RealType host, Object data) {
        return "Real";
    }

    @Override
    public Object visit(StringType host, Object data) {
        return "String";
    }

    @Override
    public Object visit(TupleType host, Object data) {
        return "TupleType";
    }

    @Override
    public Object visit(CollectionType host, Object data) {
        return "Collection";
    }

    @Override
    public Object visit(SequenceType host, Object data) {
        return "Sequence";
    }

    @Override
    public Object visit(OrderedSetType host, Object data) {
        return "OrderedSet";
    }

    @Override
    public Object visit(SetType host, Object data) {
        return "Set";
    }

    @Override
    public Object visit(BagType host, Object data) {
        return "Bag";
    }

    @Override
    public Object visit(OclModelElementType host, Object data) {
        return host.getName();
    }

    @Override
    public Object visit(OclMessageType host, Object data) {
        return "OclMessageType";
    }

    @Override
    public Object visit(VoidType host, Object data) {
        return "VoidType";
    }

    @Override
    public Object visit(Property host, Object data) {
        return null;
    }

    @Override
    public Object visit(CollectionKind host, Object data) {
        if (host == CollectionKind$Class.ORDERED_SET) {
            return "OrderedSet";
        }
        if (host == CollectionKind$Class.SET) {
            return "Set";
        }
        if (host == CollectionKind$Class.BAG) {
            return "Bag";
        }
        if (host == CollectionKind$Class.SEQUENCE) {
            return "Sequence";
        }
        return null;
    }

    @Override
    public Object visit(CollectionRange host, Object data) {
        return null;
    }

    @Override
    public Object visit(CollectionLiteralPart host, Object data) {
        return null;
    }

    @Override
    public Object visit(CollectionItem host, Object data) {
        return host.getItem().accept(this, data);
    }

    @Override
    public Object visit(ContextDeclaration host, Object data) {
        return null;
    }

    @Override
    public Object visit(OperationContextDecl host, Object data) {
        return null;
    }

    @Override
    public Object visit(PropertyContextDecl host, Object data) {
        return null;
    }

    @Override
    public Object visit(ClassifierContextDecl host, Object data) {
        Vector<Object> result = new Vector<Object>();
        for (Constraint con : host.getConstraint()) {
            if (con.getKind() != ConstraintKind$Class.INV) continue;
            OclExpression exp = con.getBodyExpression();
            if (exp != null) {
                result.add(exp.accept(this, data));
                continue;
            }
            result.add(" Undefined !!! ");
        }
        return result;
    }

    @Override
    public Object visit(Constraint host, Object data) {
        return host.getBodyExpression().accept(this, data);
    }

    @Override
    public Object visit(SendAction host, Object data) {
        return null;
    }

    @Override
    public Object visit(ModelElement host, Object data) {
        return null;
    }

    @Override
    public Object visit(EnumLiteral host, Object data) {
        return String.valueOf(host.getEnumeration().getFullName("::")) + "::" + host.getName();
    }

    @Override
    public Object visit(CallAction host, Object data) {
        return null;
    }

    @Override
    public Object visit(Signal host, Object data) {
        return null;
    }

    @Override
    public Object visit(Namespace host, Object data) {
        return null;
    }

    @Override
    public Object visit(Environment host, Object data) {
        return null;
    }

    @Override
    public Object visit(Classifier host, Object data) {
        return "Classifier";
    }

    @Override
    public Object visit(EnumerationType host, Object data) {
        return host.getName();
    }

    @Override
    public Object visit(NamedElement host, Object data) {
        return null;
    }

    @Override
    public Object visit(Operation host, Object data) {
        return null;
    }
}

