/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.bridge4emf;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.bridge4emf.Ocl4Emf;
import uk.ac.kent.cs.kmf.util.ILog;
import uk.ac.kent.cs.kmf.util.OutputStreamLog;

public class CodeGenerator {
    OclProcessor processor;
    private String inputFileName;
    public String outputDir;
    private String outputClassName;
    private String pkgName;
    private ILog log;

    public CodeGenerator(OclProcessor proc, String inputFileName, String outputDir, String pkgName, String outputClassName, ILog log) {
        this.processor = proc;
        this.inputFileName = inputFileName;
        this.outputClassName = outputClassName;
        this.outputDir = outputDir;
        this.pkgName = pkgName;
        this.log = log;
    }

    public void generate() {
        try {
            System.out.println("Reading File - " + this.inputFileName);
            FileReader input = new FileReader(this.inputFileName);
            String outputFileName = String.valueOf(this.outputDir) + "/" + this.pkgName.replaceAll("[.]", "/") + "/" + this.outputClassName + ".java";
            PrintWriter output = new PrintWriter((Writer)new FileWriter(outputFileName), true);
            this.processor.generate((Reader)input, output, this.pkgName, this.outputClassName, this.log);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length != 4) {
            System.out.println("Usage: ");
            System.out.println("       - basePackage name ");
            System.out.println("       - package name ");
            System.out.println("       - model name ");
            System.out.println("       - input file name ");
            System.out.println("       - output directory name ");
            System.out.println("       - output package name ");
            System.out.println("       - output class name ");
            return;
        }
        OutputStreamLog log = new OutputStreamLog((OutputStream)System.out);
        Ocl4Emf.InitModel(args[0], args[1], args[3], (ILog)log);
        CodeGenerator codeGen = new CodeGenerator(Ocl4Emf.processor, args[3], args[4], args[5], args[6], (ILog)log);
        codeGen.generate();
    }
}

