/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.bridge4emf;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.bridge4emf.EnumLiteralImpl;
import org.oslo.ocl20.bridge4emf.EnumerationImpl;
import org.oslo.ocl20.bridge4emf.NamespaceImpl;
import org.oslo.ocl20.bridge4emf.OclModelElementTypeImpl;
import org.oslo.ocl20.bridge4emf.OperationImpl;
import org.oslo.ocl20.bridge4emf.PropertyImpl;
import org.oslo.ocl20.semantics.bridge.BridgeFactoryImpl;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.bridge.EnumLiteral;
import org.oslo.ocl20.semantics.bridge.EnumerationType;
import org.oslo.ocl20.semantics.bridge.Environment;
import org.oslo.ocl20.semantics.bridge.ModelElement;
import org.oslo.ocl20.semantics.bridge.Namespace;
import org.oslo.ocl20.semantics.bridge.OclModelElementType;
import org.oslo.ocl20.semantics.bridge.Operation;
import org.oslo.ocl20.semantics.bridge.Property;

public class EmfBridgeFactory
extends BridgeFactoryImpl {
    Map _properties = new HashMap();
    Map _modelElementTypes = new HashMap();

    public EmfBridgeFactory(OclProcessor proc) {
        super(proc);
    }

    public Environment buildEnvironment(EPackage ePkg) {
        NamespaceImpl ns = new NamespaceImpl(ePkg, this.processor);
        Environment env = super.buildEnvironment();
        return env.addNamespace((Namespace)ns);
    }

    public Namespace buildNamespace(EPackage ePkg) {
        return new NamespaceImpl(ePkg, this.processor);
    }

    public Operation buildOperation(Classifier ret, String op_name, Classifier[] params) {
        OperationImpl oper = new OperationImpl(null, this.processor);
        oper.setName(op_name);
        oper.setReturnType(ret);
        if (params != null) {
            int i = 0;
            while (i < params.length) {
                Classifier paramType = params[i];
                oper.getParameterTypes().add(paramType);
                ++i;
            }
        }
        return oper;
    }

    public Property buildProperty(EStructuralFeature sf) {
        Property p = (Property)this._properties.get(sf);
        if (p == null) {
            p = new PropertyImpl(sf, this.processor);
            this._properties.put(sf, p);
        }
        return p;
    }

    public Property buildProperty(Classifier ret, String name) {
        PropertyImpl prop = new PropertyImpl(null, this.processor);
        prop.setName(name);
        prop.setType(ret);
        return prop;
    }

    public Classifier buildClassifier(EClassifier cls) {
        return (Classifier)this.buildModelElement(cls);
    }

    public ModelElement buildModelElement(Object o) {
        if (o instanceof EClass) {
            return this.buildOclModelElementType((EClassifier)((EClass)o));
        }
        if (o instanceof EEnum) {
            return this.buildEnumeration_((EEnum)o);
        }
        if (o instanceof EDataType) {
            EDataType dt = (EDataType)o;
            Class c = dt.getInstanceClass();
            if (c == String.class) {
                return this.processor.getTypeFactory().buildStringType();
            }
            if (c == Integer.class || c.getName().equals("int")) {
                return this.processor.getTypeFactory().buildIntegerType();
            }
            if (c == Boolean.class || c.getName().equals("boolean")) {
                return this.processor.getTypeFactory().buildBooleanType();
            }
            if (c == Float.class || c.getName().equals("float")) {
                return this.processor.getTypeFactory().buildRealType();
            }
            if (c == Double.class || c.getName().equals("double")) {
                return this.processor.getTypeFactory().buildRealType();
            }
            return this.buildOclModelElementType((EClassifier)dt);
        }
        return null;
    }

    public void resetModelElementType() {
        this._modelElementTypes.clear();
    }

    public OclModelElementType buildOclModelElementType(EClassifier ecls) {
        OclModelElementType t = (OclModelElementType)this._modelElementTypes.get(ecls);
        if (t == null) {
            t = new OclModelElementTypeImpl(ecls, this.processor);
            this._modelElementTypes.put(ecls, t);
        }
        return t;
    }

    public EnumerationType buildEnumeration_(EEnum eenum) {
        return new EnumerationImpl(eenum, this.processor);
    }

    public EnumLiteral buildEnumLiteral(EEnumLiteral eenumLit, EnumerationType enumerationType) {
        return new EnumLiteralImpl(eenumLit, enumerationType);
    }

    public OclModelElementType buildOclModelElementType(Object o) {
        if (o instanceof EClass) {
            return this.buildOclModelElementType((EClassifier)((EClass)o));
        }
        return null;
    }

    public EnumerationType buildEnumeration(Object o) {
        if (o instanceof EEnum) {
            return this.buildEnumeration((EEnum)o);
        }
        return null;
    }

    public EnumLiteral buildEnumLiteral(Object o) {
        if (o instanceof EEnumLiteral) {
            return this.buildEnumLiteral((EEnumLiteral)o);
        }
        return null;
    }

    public Classifier buildClassifier(Object o) {
        if (o instanceof EClassifier) {
            return this.buildClassifier((EClassifier)o);
        }
        return null;
    }

    public Namespace buildNamespace(Object o) {
        if (o instanceof EPackage) {
            return this.buildNamespace((EPackage)o);
        }
        return null;
    }

    public Property buildProperty(Object o) {
        if (o instanceof EStructuralFeature) {
            return this.buildProperty((EStructuralFeature)o);
        }
        return null;
    }
}

