/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.bridge4emf;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.semantics.SemanticsVisitor;
import org.oslo.ocl20.semantics.bridge.Environment;
import org.oslo.ocl20.semantics.bridge.ModelElement;
import org.oslo.ocl20.semantics.bridge.Namespace;

public class NamespaceImpl
implements Namespace {
    protected OclProcessor processor = null;
    EPackage _ePkg;
    Map _elements = new HashMap();
    Namespace _namespace = null;

    public NamespaceImpl(EPackage ePkg, OclProcessor proc) {
        this.processor = proc;
        this._ePkg = ePkg;
    }

    public ModelElement lookupOwnedElement(String name) {
        ModelElement mel = (ModelElement)this._elements.get(name);
        if (mel == null) {
            EClassifier ecl = this._ePkg.getEClassifier(name);
            if (ecl == null) {
                return null;
            }
            mel = this.processor.getBridgeFactory().buildClassifier((Object)ecl);
            this._elements.put(name, mel);
        }
        return mel;
    }

    public Namespace getNamespace() {
        if (this._namespace == null) {
            this._namespace = new NamespaceImpl(this._ePkg.getESuperPackage(), this.processor);
        }
        return this._namespace;
    }

    public void setNamespace(Namespace n) {
        this._namespace = n;
    }

    public Environment getEnvironmentWithoutParents() {
        Environment env = this.processor.getBridgeFactory().buildEnvironment();
        env.addNamespace((Namespace)this);
        env.setParent(null);
        return env;
    }

    public Environment getEnvironmentWithParents() {
        if (this.getNamespace() == null) {
            return null;
        }
        Environment result = this.getEnvironmentWithoutParents();
        result.setParent(this.getNamespace().getEnvironmentWithParents());
        return result;
    }

    public String getName() {
        return this._ePkg.getName();
    }

    public String getFullName(String sep) {
        String name = "";
        EPackage pkg = this._ePkg.getESuperPackage();
        while (pkg != null) {
            if (!name.equals("")) {
                name = String.valueOf(sep) + name;
            }
            name = String.valueOf(pkg.getName()) + name;
            pkg = pkg.getESuperPackage();
        }
        if (!name.equals("")) {
            name = String.valueOf(name) + sep;
        }
        return String.valueOf(name) + this._ePkg.getName();
    }

    public void setName(String name) {
    }

    public Object accept(SemanticsVisitor v, Object obj) {
        return v.visit((Namespace)this, obj);
    }

    public Object clone() {
        return new NamespaceImpl(this._ePkg, this.processor);
    }

    public Object getDelegate() {
        return this._ePkg;
    }
}

