/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.bridge4emf;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.bridge4emf.OperationImpl;
import org.oslo.ocl20.semantics.SemanticsVisitor;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.bridge.Namespace;
import org.oslo.ocl20.semantics.bridge.OclModelElementType;
import org.oslo.ocl20.semantics.bridge.Operation;
import org.oslo.ocl20.semantics.bridge.Property;
import org.oslo.ocl20.standard.types.OclAnyTypeImpl;

public class OclModelElementTypeImpl
extends OclAnyTypeImpl
implements OclModelElementType {
    EClassifier _impl;
    Map _properties = new HashMap();

    public OclModelElementTypeImpl(EClassifier impl, OclProcessor proc) {
        super(proc);
        this._impl = impl;
        List oper = super.getOperations();
        oper.add(proc.getBridgeFactory().buildOperation((Classifier)proc.getTypeFactory().buildBooleanType(), "=", new Classifier[]{this}));
        oper.add(proc.getBridgeFactory().buildOperation((Classifier)proc.getTypeFactory().buildBooleanType(), "<>", new Classifier[]{this}));
        List oclAnyOper = proc.getTypeFactory().buildOclAnyType().getOperations();
        oper.addAll(oclAnyOper);
    }

    public EClassifier getImplementation() {
        return this._impl;
    }

    public Property lookupProperty(String name) {
        Property prop = (Property)this._properties.get(name);
        if (prop == null) {
            if (this._impl instanceof EClass) {
                EStructuralFeature sf = ((EClass)this._impl).getEStructuralFeature(name);
                if (sf == null) {
                    String n2 = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
                    sf = ((EClass)this._impl).getEStructuralFeature(n2);
                }
                if (sf != null) {
                    prop = this.processor.getBridgeFactory().buildProperty((Object)sf);
                    this._properties.put(name, prop);
                }
            } else if (!(this._impl instanceof EEnum)) {
                boolean cfr_ignored_0 = this._impl instanceof EDataType;
            }
        }
        if (prop == null && this._impl instanceof EClass) {
            EList l = ((EClass)this._impl).getESuperTypes();
            Iterator i = l.iterator();
            while (i.hasNext()) {
                Classifier spCls = this.processor.getBridgeFactory().buildClassifier(i.next());
                prop = spCls.lookupProperty(name);
                if (prop == null) continue;
                this._properties.put(name, prop);
                break;
            }
        }
        return prop;
    }

    public List getProperties() {
        return new Vector(this._properties.values());
    }

    public void addProperty(Property p) {
        this._properties.put(p.getName(), p);
    }

    public Operation lookupOperation(String name, List types) {
        Operation o = super.lookupOperation(name, types);
        if (o == null && this._impl instanceof EClass) {
            EClass impCls = (EClass)this._impl;
            if (o == null) {
                for (EOperation op : impCls.getEAllOperations()) {
                    if (!op.getName().equals(name)) continue;
                    o = new OperationImpl(op, this.processor);
                    break;
                }
            }
        }
        if (o == null && this._impl instanceof EClass) {
            EList l = ((EClass)this._impl).getESuperTypes();
            Iterator i = l.iterator();
            while (i.hasNext()) {
                Classifier spCls = this.processor.getBridgeFactory().buildClassifier(i.next());
                o = spCls.lookupOperation(name, types);
                if (o != null) break;
            }
        }
        return o;
    }

    public String getName() {
        return this._impl.getName();
    }

    public Namespace getNamespace() {
        Namespace ns = super.getNamespace();
        if (ns == null) {
            ns = this.processor.getBridgeFactory().buildNamespace((Object)this._impl.getEPackage());
            super.setNamespace(ns);
        }
        return ns;
    }

    public Boolean conformsTo(Classifier c) {
        if (c.equals(this.processor.getTypeFactory().buildOclAnyType())) {
            return Boolean.TRUE;
        }
        if (this._impl instanceof EClass) {
            if (c instanceof OclModelElementTypeImpl) {
                EClassifier cc = ((OclModelElementTypeImpl)c)._impl;
                EClass self = (EClass)this._impl;
                return new Boolean(cc.equals(self) || self.getEAllSuperTypes().contains((Object)cc));
            }
        } else if (!(this._impl instanceof EEnum)) {
            boolean cfr_ignored_0 = this._impl instanceof EDataType;
        }
        return Boolean.FALSE;
    }

    public Object accept(SemanticsVisitor v, Object obj) {
        return v.visit((OclModelElementType)this, obj);
    }

    public String toString() {
        return "OclModelElementType(" + this._impl.getName() + ")";
    }

    public Object getDelegate() {
        return this._impl.getInstanceClass();
    }
}

