/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.kent.cs.kmf.patterns;

import java.lang.reflect.Method;
import java.util.List;
import uk.ac.kent.cs.kmf.patterns.Factory;
import uk.ac.kent.cs.kmf.util.ILog;

public class FactoryImpl
implements Factory {
    ILog _log = null;

    public FactoryImpl(ILog log) {
        this._log = log;
    }

    public Object create(String name) {
        Object elem = null;
        try {
            Method m = this.getClass().getMethod("create" + name, new Class[0]);
            elem = m.invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            this._log.reportError("Cannot create element '" + name + "' in factory for " + this);
        }
        return elem;
    }

    public Object create(String name, List types, List objects) {
        Object elem = null;
        try {
            Method m = this.getClass().getMethod("create" + name, types.toArray(new Class[0]));
            elem = m.invoke((Object)this, objects.toArray());
        }
        catch (Exception e) {
            this._log.reportError("Cannot create element '" + name + types + "' in factory " + this);
        }
        return elem;
    }

    public void destroy(String name, Object elem) {
        try {
            Method m = null;
            Method[] meths = this.getClass().getMethods();
            int i = 0;
            while (i < meths.length) {
                if (meths[i].getName().equals("destroy" + name)) {
                    m = meths[i];
                }
                ++i;
            }
            if (m == null) {
                this._log.reportError("Cannot find destroy method for '" + name + "' in factory for " + this);
            } else {
                m.invoke((Object)this, elem);
            }
        }
        catch (Exception e) {
            this._log.reportError("Cannot destroy element '" + elem + "' using factory for " + this);
        }
    }
}

