/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.kent.cs.kmf.util.reflection;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

final class ClassUtilities {
    private static final Map objectToPrimitiveMap = new HashMap(13);
    private static final Map primitiveWideningsMap;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectToPrimitiveMap.put(clazz, Boolean.TYPE);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectToPrimitiveMap.put(clazz2, Byte.TYPE);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectToPrimitiveMap.put(clazz3, Character.TYPE);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectToPrimitiveMap.put(clazz4, Double.TYPE);
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectToPrimitiveMap.put(clazz5, Float.TYPE);
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectToPrimitiveMap.put(clazz6, Integer.TYPE);
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectToPrimitiveMap.put(clazz7, Long.TYPE);
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectToPrimitiveMap.put(clazz8, Short.TYPE);
        primitiveWideningsMap = new HashMap(11);
        HashSet<Class<Number>> set = new HashSet<Class<Number>>();
        set.add(Short.TYPE);
        set.add(Integer.TYPE);
        set.add(Long.TYPE);
        set.add(Float.TYPE);
        set.add(Double.TYPE);
        primitiveWideningsMap.put(Byte.TYPE, set);
        set = new HashSet();
        set.add(Integer.TYPE);
        set.add(Long.TYPE);
        set.add(Float.TYPE);
        set.add(Double.TYPE);
        primitiveWideningsMap.put(Short.TYPE, set);
        primitiveWideningsMap.put(Character.TYPE, set);
        set = new HashSet();
        set.add(Long.TYPE);
        set.add(Float.TYPE);
        set.add(Double.TYPE);
        primitiveWideningsMap.put(Integer.TYPE, set);
        set = new HashSet();
        set.add(Float.TYPE);
        set.add(Double.TYPE);
        primitiveWideningsMap.put(Long.TYPE, set);
        set = new HashSet();
        set.add(Double.TYPE);
        primitiveWideningsMap.put(Float.TYPE, set);
    }

    private ClassUtilities() {
    }

    static Class classForNameOrPrimitive(String name, ClassLoader loader) throws ClassNotFoundException {
        if (name == null || name.equals("") || name.equals("null") || name.equals("void")) {
            return Void.TYPE;
        }
        if (name.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("byte")) {
            return Byte.TYPE;
        }
        if (name.equals("char")) {
            return Character.TYPE;
        }
        if (name.equals("double")) {
            return Double.TYPE;
        }
        if (name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("short")) {
            return Short.TYPE;
        }
        return Class.forName(name, false, loader);
    }

    static boolean classIsAccessible(Class aClass) {
        return Modifier.isPublic(aClass.getModifiers());
    }

    static boolean compatibleClasses(Class[] lhs, Class[] rhs) {
        if (lhs.length != rhs.length) {
            return false;
        }
        int i = 0;
        while (i < lhs.length) {
            Class rhsPrimEquiv;
            Class lhsPrimEquiv;
            if (rhs[i] == null || rhs[i].equals(Void.TYPE) ? lhs[i].isPrimitive() : !lhs[i].isAssignableFrom(rhs[i]) && !ClassUtilities.primitiveIsAssignableFrom(lhsPrimEquiv = ClassUtilities.primitiveEquivalentOf(lhs[i]), rhsPrimEquiv = ClassUtilities.primitiveEquivalentOf(rhs[i]))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static Method getAccessibleMethodFrom(Class aClass, String methodName, Class[] parameterTypes) {
        Class superclass = aClass.getSuperclass();
        Method overriddenMethod = null;
        if (superclass != null && ClassUtilities.classIsAccessible(superclass)) {
            try {
                overriddenMethod = superclass.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (overriddenMethod != null) {
                return overriddenMethod;
            }
        }
        Class<?>[] interfaces = aClass.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            overriddenMethod = null;
            if (ClassUtilities.classIsAccessible(interfaces[i])) {
                try {
                    overriddenMethod = interfaces[i].getMethod(methodName, parameterTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (overriddenMethod != null) {
                    return overriddenMethod;
                }
            }
            ++i;
        }
        overriddenMethod = null;
        if (superclass != null && (overriddenMethod = ClassUtilities.getAccessibleMethodFrom(superclass, methodName, parameterTypes)) != null) {
            return overriddenMethod;
        }
        i = 0;
        while (i < interfaces.length) {
            overriddenMethod = ClassUtilities.getAccessibleMethodFrom(interfaces[i], methodName, parameterTypes);
            if (overriddenMethod != null) {
                return overriddenMethod;
            }
            ++i;
        }
        return null;
    }

    static Class primitiveEquivalentOf(Class aClass) {
        return aClass.isPrimitive() ? aClass : (Class)objectToPrimitiveMap.get(aClass);
    }

    static boolean primitiveIsAssignableFrom(Class lhs, Class rhs) {
        if (lhs == null || rhs == null) {
            return false;
        }
        if (!lhs.isPrimitive() || !rhs.isPrimitive()) {
            return false;
        }
        if (lhs.equals(rhs)) {
            return true;
        }
        Set wideningSet = (Set)primitiveWideningsMap.get(rhs);
        if (wideningSet == null) {
            return false;
        }
        return wideningSet.contains(lhs);
    }
}

